/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.cooldowns;

import com.ssomar.executableitems.configs.Message;
import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeature;
import com.ssomar.score.features.custom.cooldowns.Cooldown;
import com.ssomar.score.features.custom.cooldowns.CooldownsManager;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectBuildable;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CooldownFeature
extends FeatureWithHisOwnEditor<CooldownFeature, CooldownFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private IntegerFeature cooldown;
    private ColoredStringFeature cooldownMessage;
    private BooleanFeature displayCooldownMessage;
    private BooleanFeature isCooldownInTicks;
    private BooleanFeature cancelEventIfInCooldown;
    private BooleanFeature pauseWhenOffline;
    private PlaceholderConditionGroupFeature pausePlaceholdersConditions;
    private BooleanFeature enableVisualCooldown;
    private String cooldownId;
    private SPlugin sPlugin;
    private boolean enableCooldownForOp;
    private boolean isPremium;
    private boolean isGlobal;

    public CooldownFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, SPlugin sPlugin, boolean enableCooldownForOp, boolean isGlobal) {
        super(parent, featureSettings);
        this.sPlugin = sPlugin;
        boolean bl = this.isPremium = !sPlugin.isLotOfWork();
        if (this.getParent() instanceof SActivator) {
            SActivator newSActivator = (SActivator)this.getParent();
            this.cooldownId = sPlugin.getShortName() + ":" + newSActivator.getParentObjectId() + ":" + newSActivator.getId();
        } else {
            this.cooldownId = UUID.randomUUID().toString();
        }
        this.enableCooldownForOp = enableCooldownForOp;
        this.isGlobal = isGlobal;
        this.reset();
    }

    public CooldownFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, SPlugin sPlugin, boolean enableCooldownForOp) {
        super(parent, featureSettings);
        this.sPlugin = sPlugin;
        boolean bl = this.isPremium = !sPlugin.isLotOfWork();
        if (this.getParent() instanceof SActivator) {
            SActivator newSActivator = (SActivator)this.getParent();
            this.cooldownId = sPlugin.getShortName() + ":" + newSActivator.getParentObjectId() + ":" + newSActivator.getId();
        } else {
            this.cooldownId = UUID.randomUUID().toString();
        }
        this.enableCooldownForOp = enableCooldownForOp;
        this.isGlobal = false;
        this.reset();
    }

    public boolean checkCooldown(Entity entity, @Nullable Event event, StringPlaceholder sp, SObject sObject) {
        Optional<Cooldown> inCooldownOpt;
        if (!(entity instanceof Permissible && this.hasNoCDPerm((Permissible)entity, sObject) || !(inCooldownOpt = CooldownsManager.getInstance().getCooldown(this.sPlugin, this.cooldownId, entity.getUniqueId(), this.isGlobal)).isPresent())) {
            if (this.displayCooldownMessage.getValue().booleanValue() && entity instanceof CommandSender) {
                this.displayCooldownMessage((CommandSender)entity, inCooldownOpt.get().getTimeLeft(), sp);
            }
            if (event != null && event instanceof Cancellable && this.cancelEventIfInCooldown.getValue().booleanValue()) {
                ((Cancellable)event).setCancelled(true);
            }
            return false;
        }
        return true;
    }

    public void displayCooldownMessage(CommandSender commandSender, double timeLeft, StringPlaceholder sp) {
        String message = (String)((Optional)this.cooldownMessage.getValue()).get();
        if (message.isEmpty()) {
            message = MessageMain.getInstance().getMessage(this.sPlugin.getPlugin(), (MessageInterface)Message.TIME_LEFT);
        }
        sp.getTimePlch().setTimePlcHldr(timeLeft);
        message = sp.replacePlaceholder(message);
        commandSender.sendMessage(StringConverter.coloredString(message));
    }

    public void addCooldown(Entity entity, @NotNull SObject sObject, @Nullable StringPlaceholder sp) {
        if (sp == null) {
            sp = new StringPlaceholder();
        }
        if (!this.hasNoCDPerm((Permissible)entity, sObject) && this.cooldown.getValue(entity.getUniqueId(), sp).get() != 0) {
            Cooldown cooldown = new Cooldown(this.sPlugin, this.cooldownId, entity.getUniqueId(), this.cooldown.getValue(entity.getUniqueId(), sp).get(), this.isCooldownInTicks.getValue(), System.currentTimeMillis(), false);
            cooldown.setPauseFeatures(this.pauseWhenOffline.getValue(), this.pausePlaceholdersConditions);
            CooldownsManager.getInstance().addCooldown(cooldown);
            if (SCore.is1v21v2Plus() && this.enableVisualCooldown.getValue().booleanValue() && entity instanceof HumanEntity && sObject instanceof SObjectBuildable) {
                SObjectBuildable sObjectBuildable = (SObjectBuildable)((Object)sObject);
                ItemStack item = sObjectBuildable.buildItem(1, Optional.empty());
                HumanEntity humanEntity = (HumanEntity)entity;
                humanEntity.setCooldown(item, cooldown.getTimeLeftFlatValue() * 20);
            }
        }
    }

    public void addCooldown(Entity entity, @NotNull SObject sObject, int time, boolean isInTicks) {
        if (!this.hasNoCDPerm((Permissible)entity, sObject) && time != 0) {
            Cooldown cooldown = new Cooldown(this.sPlugin, this.cooldownId, entity.getUniqueId(), time, isInTicks, System.currentTimeMillis(), false);
            cooldown.setPauseFeatures(this.pauseWhenOffline.getValue(), this.pausePlaceholdersConditions);
            CooldownsManager.getInstance().addCooldown(cooldown);
            if (SCore.is1v21v2Plus() && this.enableVisualCooldown.getValue().booleanValue() && entity instanceof HumanEntity && sObject instanceof SObjectBuildable) {
                SObjectBuildable sObjectBuildable = (SObjectBuildable)((Object)sObject);
                ItemStack item = sObjectBuildable.buildItem(1, Optional.empty());
                HumanEntity humanEntity = (HumanEntity)entity;
                humanEntity.setCooldown(item, cooldown.getTimeLeftFlatValue() * 20);
            }
        }
    }

    public void addGlobalCooldown(int time, boolean isInTicks) {
        Cooldown cooldown = new Cooldown(this.sPlugin, this.cooldownId, null, time, isInTicks, System.currentTimeMillis(), true);
        CooldownsManager.getInstance().addCooldown(cooldown);
    }

    public void addGlobalCooldown(@NotNull SObject sObject) {
        StringPlaceholder sp = new StringPlaceholder();
        Cooldown cooldown = new Cooldown(this.sPlugin, this.cooldownId, null, this.cooldown.getValue(null, sp).get(), this.isCooldownInTicks.getValue(), System.currentTimeMillis(), true);
        CooldownsManager.getInstance().addCooldown(cooldown);
    }

    public boolean hasNoCDPerm(Permissible p, SObject sObject) {
        boolean hasNoCDPerm;
        String id = sObject.getId();
        if (this.sPlugin.isLotOfWork()) {
            return false;
        }
        boolean bl = hasNoCDPerm = p.hasPermission(this.sPlugin.getName() + ".nocd." + id) || p.hasPermission(this.sPlugin.getShortName().toLowerCase() + ".nocd." + id) || p.hasPermission(this.sPlugin.getName() + ".nocd.*") || p.hasPermission(this.sPlugin.getShortName().toLowerCase() + ".nocd.*");
        if (p.isOp() || p.hasPermission("*")) {
            return !this.enableCooldownForOp;
        }
        return hasNoCDPerm;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.cooldown.load(plugin, section, isPremiumLoading));
            errors.addAll(this.displayCooldownMessage.load(plugin, section, isPremiumLoading));
            errors.addAll(this.cancelEventIfInCooldown.load(plugin, section, isPremiumLoading));
            errors.addAll(this.cooldownMessage.load(plugin, section, isPremiumLoading));
            errors.addAll(this.isCooldownInTicks.load(plugin, section, isPremiumLoading));
            errors.addAll(this.pauseWhenOffline.load(plugin, section, isPremiumLoading));
            errors.addAll(this.pausePlaceholdersConditions.load(plugin, section, isPremiumLoading));
            errors.addAll(this.enableVisualCooldown.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public CooldownFeature clone(FeatureParentInterface newParent) {
        CooldownFeature clone = new CooldownFeature(newParent, this.getFeatureSettings(), this.getSPlugin(), this.isEnableCooldownForOp());
        clone.setCooldown(this.cooldown.clone(clone));
        clone.setDisplayCooldownMessage(this.displayCooldownMessage.clone(clone));
        clone.setCancelEventIfInCooldown(this.cancelEventIfInCooldown.clone(clone));
        clone.setCooldownMessage(this.cooldownMessage.clone(clone));
        clone.setIsCooldownInTicks(this.isCooldownInTicks.clone(clone));
        clone.setCooldownId(this.cooldownId);
        clone.setPauseWhenOffline(this.pauseWhenOffline.clone(clone));
        clone.setPausePlaceholdersConditions(this.pausePlaceholdersConditions.clone(clone));
        clone.setEnableVisualCooldown(this.enableVisualCooldown.clone(clone));
        clone.setGlobal(this.isGlobal);
        clone.setPremium(this.isPremium);
        return clone;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.cooldown.save(section);
        this.isCooldownInTicks.save(section);
        this.cooldownMessage.save(section);
        this.displayCooldownMessage.save(section);
        this.cancelEventIfInCooldown.save(section);
        if (!this.isGlobal) {
            this.pauseWhenOffline.save(section);
            this.pausePlaceholdersConditions.save(section);
        } else {
            section.set(FeatureSettingsSCore.pauseWhenOffline.getName(), null);
            section.set(FeatureSettingsSCore.pausePlaceholdersConditions.getName(), null);
        }
        this.enableVisualCooldown.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public CooldownFeature getValue() {
        return this;
    }

    @Override
    public CooldownFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 6];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 6] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 5] = "&7Cooldown: &e" + String.valueOf(((Optional)this.getCooldown().getValue()).get());
        finalDescription[finalDescription.length - 4] = this.isCooldownInTicks.getValue() != false ? "&7Cooldown in ticks: &a&l\u2714" : "&7Cooldown in ticks: &c&l\u2718";
        finalDescription[finalDescription.length - 3] = this.displayCooldownMessage.getValue() != false ? "&7Display cooldown message: &a&l\u2714" : "&7Display cooldown message: &c&l\u2718";
        finalDescription[finalDescription.length - 2] = this.cancelEventIfInCooldown.getValue() != false ? "&7Cancel event if in cooldown: &a&l\u2714" : "&7Cancel event if in cooldown: &c&l\u2718";
        finalDescription[finalDescription.length - 1] = "&7Cooldown bypass perm: &b" + this.sPlugin.getShortName().toLowerCase() + ".nocd.*";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public void reset() {
        this.cooldown = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.cooldown);
        this.isCooldownInTicks = new BooleanFeature(this, false, FeatureSettingsSCore.isCooldownInTicks);
        this.cooldownMessage = new ColoredStringFeature(this, Optional.of("&cYou are in cooldown ! &7(&e%time_H%&6H &e%time_M%&6M &e%time_S%&6S&7)"), FeatureSettingsSCore.cooldownMsg);
        this.displayCooldownMessage = new BooleanFeature(this, true, FeatureSettingsSCore.displayCooldownMessage);
        this.cancelEventIfInCooldown = new BooleanFeature(this, false, FeatureSettingsSCore.cancelEventIfInCooldown);
        this.pauseWhenOffline = new BooleanFeature(this, false, FeatureSettingsSCore.pauseWhenOffline);
        this.pausePlaceholdersConditions = new PlaceholderConditionGroupFeature(this, FeatureSettingsSCore.pausePlaceholdersConditions);
        this.enableVisualCooldown = new BooleanFeature(this, false, FeatureSettingsSCore.enableVisualCooldown);
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> featureInterfaces = new ArrayList<FeatureInterface>(Arrays.asList(this.cooldown, this.isCooldownInTicks, this.cooldownMessage, this.displayCooldownMessage, this.cancelEventIfInCooldown));
        if (!this.isGlobal) {
            featureInterfaces.add(this.pauseWhenOffline);
            featureInterfaces.add(this.pausePlaceholdersConditions);
        }
        if (SCore.is1v21v2Plus()) {
            featureInterfaces.add(this.enableVisualCooldown);
        }
        return featureInterfaces;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof CooldownFeature) || !feature.getName().equals(this.getName())) continue;
            CooldownFeature coolodwn = (CooldownFeature)feature;
            coolodwn.setCooldown(this.cooldown);
            coolodwn.setIsCooldownInTicks(this.isCooldownInTicks);
            coolodwn.setCooldownMessage(this.cooldownMessage);
            coolodwn.setDisplayCooldownMessage(this.displayCooldownMessage);
            coolodwn.setCancelEventIfInCooldown(this.cancelEventIfInCooldown);
            coolodwn.setPauseWhenOffline(this.pauseWhenOffline);
            coolodwn.setPausePlaceholdersConditions(this.pausePlaceholdersConditions);
            coolodwn.setEnableVisualCooldown(this.enableVisualCooldown);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public IntegerFeature getCooldown() {
        return this.cooldown;
    }

    @Generated
    public ColoredStringFeature getCooldownMessage() {
        return this.cooldownMessage;
    }

    @Generated
    public BooleanFeature getDisplayCooldownMessage() {
        return this.displayCooldownMessage;
    }

    @Generated
    public BooleanFeature getIsCooldownInTicks() {
        return this.isCooldownInTicks;
    }

    @Generated
    public BooleanFeature getCancelEventIfInCooldown() {
        return this.cancelEventIfInCooldown;
    }

    @Generated
    public BooleanFeature getPauseWhenOffline() {
        return this.pauseWhenOffline;
    }

    @Generated
    public PlaceholderConditionGroupFeature getPausePlaceholdersConditions() {
        return this.pausePlaceholdersConditions;
    }

    @Generated
    public BooleanFeature getEnableVisualCooldown() {
        return this.enableVisualCooldown;
    }

    @Generated
    public String getCooldownId() {
        return this.cooldownId;
    }

    @Generated
    public SPlugin getSPlugin() {
        return this.sPlugin;
    }

    @Generated
    public boolean isEnableCooldownForOp() {
        return this.enableCooldownForOp;
    }

    @Override
    @Generated
    public boolean isPremium() {
        return this.isPremium;
    }

    @Generated
    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Generated
    public void setCooldown(IntegerFeature cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setCooldownMessage(ColoredStringFeature cooldownMessage) {
        this.cooldownMessage = cooldownMessage;
    }

    @Generated
    public void setDisplayCooldownMessage(BooleanFeature displayCooldownMessage) {
        this.displayCooldownMessage = displayCooldownMessage;
    }

    @Generated
    public void setIsCooldownInTicks(BooleanFeature isCooldownInTicks) {
        this.isCooldownInTicks = isCooldownInTicks;
    }

    @Generated
    public void setCancelEventIfInCooldown(BooleanFeature cancelEventIfInCooldown) {
        this.cancelEventIfInCooldown = cancelEventIfInCooldown;
    }

    @Generated
    public void setPauseWhenOffline(BooleanFeature pauseWhenOffline) {
        this.pauseWhenOffline = pauseWhenOffline;
    }

    @Generated
    public void setPausePlaceholdersConditions(PlaceholderConditionGroupFeature pausePlaceholdersConditions) {
        this.pausePlaceholdersConditions = pausePlaceholdersConditions;
    }

    @Generated
    public void setEnableVisualCooldown(BooleanFeature enableVisualCooldown) {
        this.enableVisualCooldown = enableVisualCooldown;
    }

    @Generated
    public void setCooldownId(String cooldownId) {
        this.cooldownId = cooldownId;
    }

    @Generated
    public void setSPlugin(SPlugin sPlugin) {
        this.sPlugin = sPlugin;
    }

    @Generated
    public void setEnableCooldownForOp(boolean enableCooldownForOp) {
        this.enableCooldownForOp = enableCooldownForOp;
    }

    @Override
    @Generated
    public void setPremium(boolean isPremium) {
        this.isPremium = isPremium;
    }

    @Generated
    public void setGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }
}

