/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.cooldowns;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.custom.cooldowns.Cooldown;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class CooldownsManager {
    private static final boolean DEBUG = true;
    private static CooldownsManager instance;
    private final Map<String, List<Cooldown>> cooldowns = new HashMap<String, List<Cooldown>>();
    private final Map<UUID, List<Cooldown>> cooldownsUUID = new HashMap<UUID, List<Cooldown>>();

    public static CooldownsManager getInstance() {
        if (instance == null) {
            instance = new CooldownsManager();
        }
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<String> onRequestPlaceholder(OfflinePlayer player, String params) {
        if (!params.startsWith("cooldown_")) return Optional.empty();
        UUID uuid = player.getUniqueId();
        boolean castInt = false;
        boolean castMax = false;
        Object cooldownId = "";
        if (params.contains("cooldown_slot")) {
            String slotNumber = params.replaceFirst(".*cooldown_slot(\\d+).*", "$1");
            int slot = Integer.parseInt(slotNumber);
            if (!player.isOnline() || player.getPlayer() == null) return Optional.of("Player Offline");
            ItemStack item = player.getPlayer().getInventory().getItem(slot);
            if (item == null) return Optional.of("No Item in specified slot");
            if (!item.hasItemMeta() || player == null) return Optional.of("No ItemMeta found or player is null");
            ItemMeta iM = item.getItemMeta();
            NamespacedKey key = new NamespacedKey((Plugin)ExecutableItems.getPluginSt(), "ei-id");
            String eiid = (String)iM.getPersistentDataContainer().get(key, PersistentDataType.STRING);
            if (eiid == null) return Optional.of("Not an Executable Item: " + item.getItemMeta().getDisplayName());
            cooldownId = (String)cooldownId + "EI:" + eiid + ":";
            params = params.replaceFirst("slot\\d+:", "");
        }
        if (params.contains("_int")) {
            castInt = true;
            params = params.replaceFirst("_int", "");
        }
        if (params.contains("_timemax")) {
            castMax = true;
            params = params.replaceFirst("_timemax", "");
        }
        cooldownId = (String)cooldownId + params.split("cooldown_")[1];
        SsomarDev.testMsg("CD ID " + (String)cooldownId, true);
        Optional<Cooldown> cooldownOpt = this.getCooldown((String)cooldownId, uuid, false);
        if (!cooldownOpt.isPresent()) return Optional.of("0");
        SsomarDev.testMsg("CD " + cooldownOpt.get().toString(), true);
        Cooldown cd = cooldownOpt.get();
        if (castInt && castMax) {
            return Optional.of("" + cd.getCooldown());
        }
        if (castMax) {
            return Optional.of("" + cd.getCooldown());
        }
        if (!castInt) return Optional.of("" + cd.getTimeLeft());
        return Optional.of("" + (int)cd.getTimeLeft());
    }

    public void addCooldown(Cooldown cd) {
        if (cd.getCooldown() == 0) {
            return;
        }
        String id = cd.getId();
        SsomarDev.testMsg("ADDDD " + cd.toString(), true);
        if (this.cooldowns.containsKey(id)) {
            cds = this.cooldowns.get(id);
            if (cds == null) {
                cds = new ArrayList();
            }
            cds.add(cd);
            this.cooldowns.put(id, cds);
        } else {
            cds = new ArrayList<Cooldown>();
            cds.add(cd);
            this.cooldowns.put(id, cds);
        }
        UUID id2 = cd.getEntityUUID();
        if (id2 == null) {
            return;
        }
        if (this.cooldownsUUID.containsKey(id2)) {
            List<Cooldown> cds = this.cooldownsUUID.get(id2);
            if (cds == null) {
                cds = new ArrayList<Cooldown>();
            }
            cds.add(cd);
        } else {
            ArrayList<Cooldown> cds = new ArrayList<Cooldown>();
            cds.add(cd);
            this.cooldownsUUID.put(id2, cds);
        }
    }

    public void addCooldowns(List<Cooldown> cds) {
        for (Cooldown cd : cds) {
            double timeLeft = cd.getTimeLeft();
            if (!(timeLeft > 0.0)) continue;
            this.addCooldown(cd);
        }
    }

    public Optional<Cooldown> getCooldown(String id, UUID uuid, boolean onlyGlobal) {
        return this.getCooldown(SCore.plugin, id, uuid, onlyGlobal);
    }

    public Optional<Cooldown> getCooldown(SPlugin sPlugin, String id, UUID uuid, boolean onlyGlobal) {
        if (this.cooldowns.containsKey(id)) {
            double maxTimeLeft = -1.0;
            List<Cooldown> cds = this.cooldowns.get(id);
            if (cds != null && !cds.isEmpty()) {
                Cooldown cdMax = null;
                int cptRemoved = 0;
                int size = cds.size();
                for (int i = 0; i < size; ++i) {
                    Cooldown cd = cds.get(i - cptRemoved);
                    if (cd == null || onlyGlobal && !cd.isGlobal() || !cd.isGlobal() && !cd.getEntityUUID().equals(uuid)) continue;
                    double timeLeft = cd.getTimeLeft();
                    if (maxTimeLeft < timeLeft && timeLeft > 0.0) {
                        maxTimeLeft = timeLeft;
                        cdMax = cd;
                        continue;
                    }
                    cd.setNull(true);
                    cds.remove(i - cptRemoved);
                    ++cptRemoved;
                    try {
                        this.cooldownsUUID.get(uuid).remove(cd);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return Optional.ofNullable(cdMax);
            }
        }
        SsomarDev.testMsg("NO COOLDOWN ", true);
        return Optional.empty();
    }

    public List<Cooldown> getCooldownsOf(UUID uuid) {
        if (this.cooldownsUUID.containsKey(uuid)) {
            ArrayList cds = this.cooldownsUUID.get(uuid);
            return cds == null ? new ArrayList() : cds;
        }
        return new ArrayList<Cooldown>();
    }

    public List<Cooldown> getAllCooldowns() {
        ArrayList<Cooldown> result = new ArrayList<Cooldown>();
        for (String id : this.cooldowns.keySet()) {
            List<Cooldown> cds = this.cooldowns.get(id);
            if (cds == null) continue;
            result.addAll(cds);
        }
        return result;
    }

    public void clearCooldowns() {
        this.cooldowns.clear();
        this.cooldownsUUID.clear();
    }

    public void removeCooldownsOf(UUID uuid) {
        this.cooldownsUUID.remove(uuid);
        block0: for (String s : this.cooldowns.keySet()) {
            List<Cooldown> cds = this.cooldowns.get(s);
            for (int i = 0; i < cds.size(); ++i) {
                Cooldown cd = cds.get(i);
                if (cd == null || cd.getEntityUUID() == null || !cd.getEntityUUID().equals(uuid)) continue;
                cds.set(i, null);
                continue block0;
            }
        }
    }

    public void clearCooldown(String cooldownId, @Nullable UUID uuid) {
        block0: for (String s : this.cooldowns.keySet()) {
            List<Cooldown> cds = this.cooldowns.get(s);
            for (int i = 0; i < cds.size(); ++i) {
                Cooldown cd = cds.get(i);
                if (cd == null || !cd.getId().equalsIgnoreCase(cooldownId) || uuid != null && (cd.getEntityUUID() == null || !cd.getEntityUUID().equals(uuid))) continue;
                if (cd.getEntityUUID() != null) {
                    this.cooldownsUUID.get(cd.getEntityUUID()).remove(cd);
                }
                cds.set(i, null);
                continue block0;
            }
        }
    }

    public List<String> getAllCooldownIds() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.cooldowns.keySet());
        return result;
    }

    public void printInfo() {
        List<Cooldown> cds;
        System.out.println("--------^^^^^^^^^^^^^^^^^^^^-------------");
        int total = 0;
        for (String string : this.cooldowns.keySet()) {
            cds = this.cooldowns.get(string);
            total += cds.size();
        }
        System.out.println(" total : " + total);
        total = 0;
        for (UUID uUID : this.cooldownsUUID.keySet()) {
            cds = this.cooldownsUUID.get(uUID);
            total += cds.size();
        }
        System.out.println(" total : " + total);
        for (String string : this.cooldowns.keySet()) {
            for (Cooldown cd2 : this.cooldowns.get(string)) {
                if (cd2 != null) {
                    System.out.println(cd2.toString());
                    continue;
                }
                System.out.println("null");
            }
        }
        System.out.println("----------------------");
        for (UUID uUID : this.cooldownsUUID.keySet()) {
            for (Cooldown cd2 : this.cooldownsUUID.get(uUID)) {
                if (cd2 != null) {
                    System.out.println(cd2.toString());
                    continue;
                }
                System.out.println("null");
            }
        }
        System.out.println("---------vvvvvvvvvvvvvvvvv-------------");
    }
}

