/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.directional;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BlockFaceFeature;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DirectionalFeatures
extends FeatureWithHisOwnEditor<DirectionalFeatures, DirectionalFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private BooleanFeature forceBlockFaceOnPlace;
    private BlockFaceFeature blockFaceOnPlace;

    public DirectionalFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.directionalFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.forceBlockFaceOnPlace = new BooleanFeature(this, false, FeatureSettingsSCore.forceBlockFaceOnPlace);
        this.blockFaceOnPlace = new BlockFaceFeature(this, Optional.empty(), null, FeatureSettingsSCore.blockFaceOnPlace);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection containerFeaturesSection = config.getConfigurationSection(this.getName());
            error.addAll(this.forceBlockFaceOnPlace.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.blockFaceOnPlace.load(plugin, containerFeaturesSection, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection furnaceFeaturesSection = config.createSection(this.getName());
        this.forceBlockFaceOnPlace.save(furnaceFeaturesSection);
        this.blockFaceOnPlace.save(furnaceFeaturesSection);
    }

    @Override
    public DirectionalFeatures getValue() {
        return this;
    }

    @Override
    public DirectionalFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = "&7Directional force BlockFace: &e" + this.forceBlockFaceOnPlace.getValue();
        finalDescription[finalDescription.length - 1] = "&7Directional BlockFace: &e" + String.valueOf(((Optional)this.blockFaceOnPlace.getValue()).orElse(null));
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public DirectionalFeatures clone(FeatureParentInterface newParent) {
        DirectionalFeatures eF = new DirectionalFeatures(newParent);
        eF.forceBlockFaceOnPlace = this.forceBlockFaceOnPlace.clone(eF);
        eF.blockFaceOnPlace = this.blockFaceOnPlace.clone(eF);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.forceBlockFaceOnPlace);
        features.add(this.blockFaceOnPlace);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DirectionalFeatures)) continue;
            DirectionalFeatures eF = (DirectionalFeatures)feature;
            eF.setForceBlockFaceOnPlace(this.forceBlockFaceOnPlace);
            eF.setBlockFaceOnPlace(this.blockFaceOnPlace);
            break;
        }
    }

    public boolean canBeApplied(BlockData blockData) {
        return blockData instanceof Directional;
    }

    public void applyDirectionalFeatures(Block block) {
        if (this.canBeApplied(block.getBlockData())) {
            Directional directional = (Directional)block.getBlockData();
            if (this.forceBlockFaceOnPlace.getValue().booleanValue() && ((Optional)this.blockFaceOnPlace.getValue()).isPresent()) {
                directional.setFacing((BlockFace)((Optional)this.blockFaceOnPlace.getValue()).get());
                block.setBlockData((BlockData)directional);
            }
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public BooleanFeature getForceBlockFaceOnPlace() {
        return this.forceBlockFaceOnPlace;
    }

    @Generated
    public BlockFaceFeature getBlockFaceOnPlace() {
        return this.blockFaceOnPlace;
    }

    @Generated
    public void setForceBlockFaceOnPlace(BooleanFeature forceBlockFaceOnPlace) {
        this.forceBlockFaceOnPlace = forceBlockFaceOnPlace;
    }

    @Generated
    public void setBlockFaceOnPlace(BlockFaceFeature blockFaceOnPlace) {
        this.blockFaceOnPlace = blockFaceOnPlace;
    }
}

