/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.entities.entity;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.entities.group.EntityTypeGroupFeature;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.EntityTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class EntityTypeForGroupFeature
extends FeatureWithHisOwnEditor<EntityTypeForGroupFeature, EntityTypeForGroupFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private EntityTypeFeature entityType;
    private String id;

    public EntityTypeForGroupFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.entityType);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.entityType = new EntityTypeFeature(this, Optional.of(EntityType.ZOMBIE), FeatureSettingsSCore.entityType);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.entityType.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the EntityType with its options because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    public List<String> load(SPlugin plugin, String config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>(this.entityType.load(plugin, config, isPremiumLoading));
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        this.reload();
        ((EntityTypeGroupFeature)this.getParent()).save(config);
    }

    @Override
    public EntityTypeForGroupFeature getValue() {
        return this;
    }

    @Override
    public EntityTypeForGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = "&7EntityType: &e" + String.valueOf(((Optional)this.entityType.getValue()).get());
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public EntityTypeForGroupFeature clone(FeatureParentInterface newParent) {
        EntityTypeForGroupFeature eF = new EntityTypeForGroupFeature(newParent, this.id);
        eF.setEntityType(this.entityType.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Collections.singletonList(this.entityType));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            EntityTypeForGroupFeature aFOF;
            if (!(feature instanceof EntityTypeForGroupFeature) || !(aFOF = (EntityTypeForGroupFeature)feature).getId().equals(this.id)) continue;
            aFOF.setEntityType(this.entityType);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public EntityTypeFeature getEntityType() {
        return this.entityType;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setEntityType(EntityTypeFeature entityType) {
        this.entityType = entityType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

