/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.equippableFeatures;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.SlotFeature;
import com.ssomar.score.features.types.SoundFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.features.types.list.ListEntityTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.backward_compatibility.SoundUtils;
import com.ssomar.score.utils.emums.AttributeSlot;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.jetbrains.annotations.NotNull;

public class EquippableFeatures
extends FeatureWithHisOwnEditor<EquippableFeatures, EquippableFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private BooleanFeature enable;
    private SlotFeature slot;
    private BooleanFeature enableSound;
    private SoundFeature sound;
    private UncoloredStringFeature model;
    private UncoloredStringFeature cameraOverlay;
    private BooleanFeature isDamageableOnHurt;
    private BooleanFeature isDispensable;
    private BooleanFeature isSwappable;
    private ListEntityTypeFeature allowedEntities;

    public EquippableFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.equippableFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.enable = new BooleanFeature(this, false, FeatureSettingsSCore.enable);
        this.slot = new SlotFeature(this, Optional.of(AttributeSlot.BODY), FeatureSettingsSCore.slot);
        this.slot.setOnlyArmorSlots(true);
        this.enableSound = new BooleanFeature(this, false, FeatureSettingsSCore.enableSound);
        this.sound = new SoundFeature(this, Optional.of(Sound.ITEM_ARMOR_EQUIP_DIAMOND), FeatureSettingsSCore.sound);
        this.model = new UncoloredStringFeature(this, Optional.empty(), FeatureSettingsSCore.equipModel, false);
        this.cameraOverlay = new UncoloredStringFeature(this, Optional.empty(), FeatureSettingsSCore.cameraOverlay, false);
        this.isDamageableOnHurt = new BooleanFeature(this, false, FeatureSettingsSCore.damageableOnHurt);
        this.isDispensable = new BooleanFeature(this, true, FeatureSettingsSCore.dispensable);
        this.isSwappable = new BooleanFeature(this, true, FeatureSettingsSCore.swappable);
        this.allowedEntities = new ListEntityTypeFeature(this, new ArrayList<EntityType>(Collections.singleton(EntityType.PLAYER)), FeatureSettingsSCore.allowedEntities);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (FeatureInterface feature : this.getFeatures()) {
                errors.addAll(feature.load(plugin, section, isPremiumLoading));
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public EquippableFeatures getValue() {
        return this;
    }

    @Override
    public EquippableFeatures initItemParentEditor(GUI gui, int slot) {
        int len = 11;
        String[] finalDescription = new String[this.getEditorDescription().length + len];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - len] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - --len] = "&7Enable: &e" + (this.enable.getValue() != false ? "&a&l\u2714" : "&c&l\u2718");
        finalDescription[finalDescription.length - --len] = "&7Slot: &e" + String.valueOf(((Optional)this.slot.getValue()).get());
        finalDescription[finalDescription.length - --len] = "&7Enable Sound: &e" + (this.enableSound.getValue() != false ? "&a&l\u2714" : "&c&l\u2718");
        finalDescription[finalDescription.length - --len] = "&7Sound: &e" + SoundUtils.getSounds().get(((Optional)this.sound.getValue()).get());
        finalDescription[finalDescription.length - --len] = "&7Model: &e" + ((Optional)this.model.getValue()).orElse("");
        finalDescription[finalDescription.length - --len] = "&7Camera Overlay: &e" + ((Optional)this.cameraOverlay.getValue()).orElse("");
        finalDescription[finalDescription.length - --len] = "&7Is Damageable On Hurt: &e" + (this.isDamageableOnHurt.getValue() != false ? "&a&l\u2714" : "&c&l\u2718");
        finalDescription[finalDescription.length - --len] = "&7Is Dispensable: &e" + (this.isDispensable.getValue() != false ? "&a&l\u2714" : "&c&l\u2718");
        finalDescription[finalDescription.length - --len] = "&7Is Swappable: &e" + (this.isSwappable.getValue() != false ? "&a&l\u2714" : "&c&l\u2718");
        finalDescription[finalDescription.length - --len] = "&7Allowed Entities: &e" + String.valueOf(this.allowedEntities.getValue());
        --len;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public EquippableFeatures clone(FeatureParentInterface newParent) {
        EquippableFeatures dropFeatures = new EquippableFeatures(newParent);
        dropFeatures.setEnable(this.enable.clone(dropFeatures));
        dropFeatures.setSlot(this.slot.clone(dropFeatures));
        dropFeatures.setEnableSound(this.enableSound.clone(dropFeatures));
        dropFeatures.setSound(this.sound.clone(dropFeatures));
        dropFeatures.setModel(this.model.clone(dropFeatures));
        dropFeatures.setCameraOverlay(this.cameraOverlay.clone(dropFeatures));
        dropFeatures.setIsDamageableOnHurt(this.isDamageableOnHurt.clone(dropFeatures));
        dropFeatures.setIsDispensable(this.isDispensable.clone(dropFeatures));
        dropFeatures.setIsSwappable(this.isSwappable.clone(dropFeatures));
        dropFeatures.setAllowedEntities(this.allowedEntities.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enable);
        features.add(this.slot);
        features.add(this.enableSound);
        features.add(this.sound);
        features.add(this.model);
        features.add(this.cameraOverlay);
        features.add(this.isDamageableOnHurt);
        features.add(this.isDispensable);
        features.add(this.isSwappable);
        features.add(this.allowedEntities);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof EquippableFeatures)) continue;
            EquippableFeatures hiders = (EquippableFeatures)feature;
            hiders.setEnable(this.enable);
            hiders.setSlot(this.slot);
            hiders.setEnableSound(this.enableSound);
            hiders.setSound(this.sound);
            hiders.setModel(this.model);
            hiders.setCameraOverlay(this.cameraOverlay);
            hiders.setIsDamageableOnHurt(this.isDamageableOnHurt);
            hiders.setIsDispensable(this.isDispensable);
            hiders.setIsSwappable(this.isSwappable);
            hiders.setAllowedEntities(this.allowedEntities);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v21v2Plus();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return true;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        if (this.isAvailable() && this.enable.getValue().booleanValue()) {
            ItemMeta meta = args.getMeta();
            EquippableComponent equippable = meta.getEquippable();
            equippable.setSlot(this.slot.getEquipmentSlotValue().get());
            if (this.enableSound.getValue().booleanValue()) {
                equippable.setEquipSound((Sound)((Optional)this.sound.getValue()).get());
            }
            if (!((Optional)this.model.getValue()).orElse("").isEmpty()) {
                equippable.setModel(NamespacedKey.fromString((String)((String)((Optional)this.model.getValue()).get())));
            }
            if (!((Optional)this.cameraOverlay.getValue()).orElse("").isEmpty()) {
                equippable.setCameraOverlay(NamespacedKey.fromString((String)((String)((Optional)this.cameraOverlay.getValue()).get())));
            }
            equippable.setDispensable(this.isDispensable.getValue().booleanValue());
            equippable.setDamageOnHurt(this.isDamageableOnHurt.getValue().booleanValue());
            equippable.setSwappable(this.isSwappable.getValue().booleanValue());
            if (this.allowedEntities.getValue().isEmpty()) {
                equippable.setAllowedEntities(EntityType.PLAYER);
            } else {
                equippable.setAllowedEntities((Collection)this.allowedEntities.getValue());
            }
            meta.setEquippable(equippable);
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta meta;
        if (this.isAvailable() && (meta = args.getMeta()).hasEquippable()) {
            EquippableComponent equippable = meta.getEquippable();
            this.enable.setValue(true);
            this.slot.setValue(Optional.ofNullable(AttributeSlot.fromEquipmentSlot(equippable.getSlot())));
            this.enableSound.setValue(equippable.getEquipSound() != null);
            this.sound.setValue(Optional.ofNullable(equippable.getEquipSound()));
            if (equippable.getModel() != null) {
                this.model.setValue(Optional.of(equippable.getModel().toString()));
            }
            if (equippable.getCameraOverlay() != null) {
                this.cameraOverlay.setValue(Optional.of(equippable.getCameraOverlay().toString()));
            }
            this.isDamageableOnHurt.setValue(equippable.isDamageOnHurt());
            this.isDispensable.setValue(equippable.isDispensable());
            this.isSwappable.setValue(equippable.isSwappable());
            if (equippable.getAllowedEntities() != null) {
                this.allowedEntities.setValues(new ArrayList(equippable.getAllowedEntities()));
            }
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.EQUIPPABLE;
    }

    @Generated
    public BooleanFeature getEnable() {
        return this.enable;
    }

    @Generated
    public SlotFeature getSlot() {
        return this.slot;
    }

    @Generated
    public BooleanFeature getEnableSound() {
        return this.enableSound;
    }

    @Generated
    public SoundFeature getSound() {
        return this.sound;
    }

    @Generated
    public UncoloredStringFeature getModel() {
        return this.model;
    }

    @Generated
    public UncoloredStringFeature getCameraOverlay() {
        return this.cameraOverlay;
    }

    @Generated
    public BooleanFeature getIsDamageableOnHurt() {
        return this.isDamageableOnHurt;
    }

    @Generated
    public BooleanFeature getIsDispensable() {
        return this.isDispensable;
    }

    @Generated
    public BooleanFeature getIsSwappable() {
        return this.isSwappable;
    }

    @Generated
    public ListEntityTypeFeature getAllowedEntities() {
        return this.allowedEntities;
    }

    @Generated
    public void setEnable(BooleanFeature enable) {
        this.enable = enable;
    }

    @Generated
    public void setSlot(SlotFeature slot) {
        this.slot = slot;
    }

    @Generated
    public void setEnableSound(BooleanFeature enableSound) {
        this.enableSound = enableSound;
    }

    @Generated
    public void setSound(SoundFeature sound) {
        this.sound = sound;
    }

    @Generated
    public void setModel(UncoloredStringFeature model) {
        this.model = model;
    }

    @Generated
    public void setCameraOverlay(UncoloredStringFeature cameraOverlay) {
        this.cameraOverlay = cameraOverlay;
    }

    @Generated
    public void setIsDamageableOnHurt(BooleanFeature isDamageableOnHurt) {
        this.isDamageableOnHurt = isDamageableOnHurt;
    }

    @Generated
    public void setIsDispensable(BooleanFeature isDispensable) {
        this.isDispensable = isDispensable;
    }

    @Generated
    public void setIsSwappable(BooleanFeature isSwappable) {
        this.isSwappable = isSwappable;
    }

    @Generated
    public void setAllowedEntities(ListEntityTypeFeature allowedEntities) {
        this.allowedEntities = allowedEntities;
    }
}

