/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.hopper;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Hopper;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HopperFeatures
extends FeatureWithHisOwnEditor<HopperFeatures, HopperFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private IntegerFeature amountItemsTransferred;

    public HopperFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.hopperFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.amountItemsTransferred = new IntegerFeature(this, Optional.empty(), FeatureSettingsSCore.amountItemsTransferred);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection containerFeaturesSection = config.getConfigurationSection(this.getName());
            error.addAll(this.amountItemsTransferred.load(plugin, containerFeaturesSection, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection containerFeaturesSection = config.createSection(this.getName());
        this.amountItemsTransferred.save(containerFeaturesSection);
    }

    @Override
    public HopperFeatures getValue() {
        return this;
    }

    @Override
    public HopperFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7Amount transferred: &e" + String.valueOf(((Optional)this.amountItemsTransferred.getValue()).orElse(1));
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public HopperFeatures clone(FeatureParentInterface newParent) {
        HopperFeatures eF = new HopperFeatures(newParent);
        eF.amountItemsTransferred = this.amountItemsTransferred.clone(eF);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.amountItemsTransferred);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof HopperFeatures)) continue;
            HopperFeatures eF = (HopperFeatures)feature;
            eF.setAmountItemsTransferred(this.amountItemsTransferred);
            break;
        }
    }

    public boolean canBeApplied(BlockData blockData) {
        return blockData instanceof Hopper;
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public IntegerFeature getAmountItemsTransferred() {
        return this.amountItemsTransferred;
    }

    @Generated
    public void setAmountItemsTransferred(IntegerFeature amountItemsTransferred) {
        this.amountItemsTransferred = amountItemsTransferred;
    }
}

