/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.ifhas.executableitems.attribute;

import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.detailedslots.DetailedSlots;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.ExecutableItemFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HasExecutableItemFeature
extends FeatureWithHisOwnEditor<HasExecutableItemFeature, HasExecutableItemFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private ExecutableItemFeature executableItem;
    private IntegerFeature amount;
    private DetailedSlots detailedSlots;
    private NumberConditionFeature usageCondition;
    private String id;

    public HasExecutableItemFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.hasExecutableItem);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.executableItem = new ExecutableItemFeature(this, FeatureSettingsSCore.executableItem);
        this.amount = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.amount);
        this.detailedSlots = new DetailedSlots(this);
        this.usageCondition = new NumberConditionFeature(this, FeatureSettingsSCore.usageConditions);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.executableItem.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.amount.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.detailedSlots.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.usageCondition.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the HasExecutableItem feature because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.executableItem.save(attributeConfig);
        this.amount.save(attributeConfig);
        this.detailedSlots.save(attributeConfig);
        this.usageCondition.save(attributeConfig);
    }

    @Override
    public HasExecutableItemFeature getValue() {
        return this;
    }

    @Override
    public HasExecutableItemFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 5];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 5] = ((Optional)this.executableItem.getValue()).isPresent() ? "&7ExecutableItem: &e" + ((ExecutableItemInterface)((Optional)this.executableItem.getValue()).get()).getId() : "&7ExecutableItem: &cINVALID EI";
        finalDescription[finalDescription.length - 4] = "&7Amount: &e" + String.valueOf(((Optional)this.amount.getValue()).get());
        finalDescription[finalDescription.length - 3] = "&7Slots count: &c" + this.detailedSlots.getSlots().size();
        finalDescription[finalDescription.length - 2] = ((Optional)this.usageCondition.getValue()).isPresent() ? "&7Usage Condition: &e" + (String)((Optional)this.usageCondition.getValue()).get() : "&7Usage Condition: &cNO CONDITION";
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public HasExecutableItemFeature clone(FeatureParentInterface newParent) {
        HasExecutableItemFeature eF = new HasExecutableItemFeature(newParent, this.id);
        eF.setExecutableItem(this.executableItem.clone(eF));
        eF.setAmount(this.amount.clone(eF));
        eF.setDetailedSlots(this.detailedSlots.clone(eF));
        eF.setUsageCondition(this.usageCondition.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.executableItem, this.amount, this.detailedSlots, this.usageCondition));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection parentSection = this.getParent().getConfigurationSection();
        if (parentSection.isConfigurationSection(this.getId())) {
            return parentSection.getConfigurationSection(this.getId());
        }
        return parentSection.createSection(this.getId());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            HasExecutableItemFeature aFOF;
            if (!(feature instanceof HasExecutableItemFeature) || !(aFOF = (HasExecutableItemFeature)feature).getId().equals(this.id)) continue;
            aFOF.setExecutableItem(this.executableItem);
            aFOF.setAmount(this.amount);
            aFOF.setDetailedSlots(this.detailedSlots);
            aFOF.setUsageCondition(this.usageCondition);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public ExecutableItemFeature getExecutableItem() {
        return this.executableItem;
    }

    @Generated
    public IntegerFeature getAmount() {
        return this.amount;
    }

    @Generated
    public DetailedSlots getDetailedSlots() {
        return this.detailedSlots;
    }

    @Generated
    public NumberConditionFeature getUsageCondition() {
        return this.usageCondition;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setExecutableItem(ExecutableItemFeature executableItem) {
        this.executableItem = executableItem;
    }

    @Generated
    public void setAmount(IntegerFeature amount) {
        this.amount = amount;
    }

    @Generated
    public void setDetailedSlots(DetailedSlots detailedSlots) {
        this.detailedSlots = detailedSlots;
    }

    @Generated
    public void setUsageCondition(NumberConditionFeature usageCondition) {
        this.usageCondition = usageCondition;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

