/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.ifhas.executableitems.group;

import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.ifhas.executableitems.attribute.HasExecutableItemFeature;
import com.ssomar.score.features.custom.ifhas.executableitems.group.HasExecutableItemGroupFeatureEditor;
import com.ssomar.score.features.custom.ifhas.executableitems.group.HasExecutableItemGroupFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringCalculation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HasExecutableItemGroupFeature
extends FeatureWithHisOwnEditor<HasExecutableItemGroupFeature, HasExecutableItemGroupFeature, HasExecutableItemGroupFeatureEditor, HasExecutableItemGroupFeatureEditorManager>
implements FeaturesGroup<FeatureInterface> {
    private Map<String, FeatureInterface> hasExecutableItems;
    private boolean notSaveIfNoValue;
    private String multipleChoicesID;

    public HasExecutableItemGroupFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettingsInterface, boolean notSaveIfNoValue) {
        super(parent, featureSettingsInterface);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    public HasExecutableItemGroupFeature(FeatureParentInterface parent, String multipleChoicesID) {
        super(parent, FeatureSettingsSCore.multiChoices);
        this.notSaveIfNoValue = true;
        this.multipleChoicesID = multipleChoicesID;
        this.reset();
    }

    @Override
    public void reset() {
        this.hasExecutableItems = new HashMap<String, FeatureInterface>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        Object section = this.multipleChoicesID == null || this.multipleChoicesID.isEmpty() ? this.getName() : this.multipleChoicesID + ".multi-choices";
        if (config.isConfigurationSection((String)section)) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection((String)section);
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                ConfigurationSection cdtSection = enchantmentsSection.getConfigurationSection(attributeID);
                List<Object> subErrors = new ArrayList();
                if (cdtSection.isConfigurationSection("multi-choices")) {
                    HasExecutableItemGroupFeature multiChoices = new HasExecutableItemGroupFeature((FeatureParentInterface)this, attributeID);
                    multiChoices.load(plugin, enchantmentsSection, isPremiumLoading);
                    this.hasExecutableItems.put(attributeID, multiChoices);
                } else {
                    HasExecutableItemFeature attribute = new HasExecutableItemFeature((FeatureParentInterface)this, attributeID);
                    subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                    this.hasExecutableItems.put(attributeID, attribute);
                }
                if (subErrors.size() <= 0) continue;
                error.addAll(subErrors);
            }
        }
        return error;
    }

    public boolean verifHas(ItemStack[] items, int heldSlot) {
        for (FeatureInterface feature : this.hasExecutableItems.values()) {
            if (feature instanceof HasExecutableItemFeature) {
                if (this.verifHasExecutableItem(items, heldSlot, (HasExecutableItemFeature)feature)) continue;
                return false;
            }
            if (!(feature instanceof HasExecutableItemGroupFeature)) continue;
            HasExecutableItemGroupFeature f = (HasExecutableItemGroupFeature)feature;
            boolean has = false;
            for (FeatureInterface feature1 : f.getHasExecutableItems().values()) {
                if (feature1 instanceof HasExecutableItemFeature) {
                    if (!this.verifHasExecutableItem(items, heldSlot, (HasExecutableItemFeature)feature1)) continue;
                    has = true;
                    continue;
                }
                if (!(feature1 instanceof HasExecutableItemGroupFeature) || this.verifHas(items, heldSlot)) continue;
                return false;
            }
            if (has) continue;
            return false;
        }
        return true;
    }

    public boolean verifHasExecutableItem(ItemStack[] items, int heldSlot, HasExecutableItemFeature f) {
        boolean valid = false;
        Object ei = f.getExecutableItem().getValue();
        if (!((Optional)ei).isPresent()) {
            return true;
        }
        ExecutableItemInterface executableItem = (ExecutableItemInterface)((Optional)ei).get();
        int needed = (Integer)((Optional)f.getAmount().getValue()).get();
        int slot = 0;
        for (ItemStack item : items) {
            ExecutableItemObject eiObject;
            if (f.getDetailedSlots().verifSlot(slot, slot == heldSlot) && item != null && (eiObject = new ExecutableItemObject(item)).isValid() && eiObject.getConfig().getId().equals(executableItem.getId())) {
                if (((Optional)f.getUsageCondition().getValue()).isPresent()) {
                    eiObject.loadExecutableItemInfos();
                    if (!StringCalculation.calculation((String)((Optional)f.getUsageCondition().getValue()).get(), eiObject.getUsage())) continue;
                }
                needed -= item.getAmount();
            }
            if (needed <= 0) {
                valid = true;
                break;
            }
            ++slot;
        }
        return valid;
    }

    public boolean verifHasNot(ItemStack[] items, int heldSlot) {
        return !this.verifHas(items, heldSlot);
    }

    @Override
    public void save(ConfigurationSection config) {
        ConfigurationSection attributesSection;
        if (this.multipleChoicesID == null || this.multipleChoicesID.isEmpty()) {
            config.set(this.getName(), null);
            if (this.notSaveIfNoValue && this.hasExecutableItems.size() == 0) {
                return;
            }
            attributesSection = config.createSection(this.getName());
        } else {
            config.set(this.getMultipleChoicesID(), null);
            attributesSection = config.createSection(this.getMultipleChoicesID() + ".multi-choices");
        }
        for (String enchantmentID : this.hasExecutableItems.keySet()) {
            this.hasExecutableItems.get(enchantmentID).save(attributesSection);
        }
    }

    @Override
    public HasExecutableItemGroupFeature getValue() {
        return this;
    }

    @Override
    public HasExecutableItemGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oHasExecutableItems(s) added: &e" + this.hasExecutableItems.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public FeatureInterface getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (FeatureInterface x : this.hasExecutableItems.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public HasExecutableItemGroupFeature clone(FeatureParentInterface newParent) {
        HasExecutableItemGroupFeature eF = new HasExecutableItemGroupFeature(newParent, this.getFeatureSettings(), this.isNotSaveIfNoValue());
        HashMap<String, FeatureInterface> newHasExecutableItems = new HashMap<String, FeatureInterface>();
        for (String key : this.hasExecutableItems.keySet()) {
            newHasExecutableItems.put(key, this.hasExecutableItems.get(key).clone(eF));
        }
        eF.setHasExecutableItems(newHasExecutableItems);
        eF.setMultipleChoicesID(this.getMultipleChoicesID());
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.hasExecutableItems.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (this.multipleChoicesID == null || this.multipleChoicesID.isEmpty()) {
            if (section.isConfigurationSection(this.getName())) {
                return section.getConfigurationSection(this.getName());
            }
            return section.createSection(this.getName());
        }
        if (section.isConfigurationSection(this.getMultipleChoicesID() + ".multi-choices")) {
            return section.getConfigurationSection(this.getMultipleChoicesID() + ".multi-choices");
        }
        return section.createSection(this.getMultipleChoicesID() + ".multi-choices");
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof HasExecutableItemGroupFeature)) continue;
            HasExecutableItemGroupFeature eF = (HasExecutableItemGroupFeature)feature;
            eF.setHasExecutableItems(this.getHasExecutableItems());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        HasExecutableItemGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "hasExecutableItem";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.hasExecutableItems.containsKey(id)) continue;
            HasExecutableItemFeature eF = new HasExecutableItemFeature((FeatureParentInterface)this, id);
            this.hasExecutableItems.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, FeatureInterface feature) {
        if (feature instanceof HasExecutableItemFeature) {
            HasExecutableItemFeature eF = (HasExecutableItemFeature)feature;
            this.hasExecutableItems.remove(eF.getId());
        } else if (feature instanceof HasExecutableItemGroupFeature) {
            HasExecutableItemGroupFeature eF = (HasExecutableItemGroupFeature)feature;
            this.hasExecutableItems.remove(eF.getMultipleChoicesID());
        }
    }

    @Generated
    public Map<String, FeatureInterface> getHasExecutableItems() {
        return this.hasExecutableItems;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public String getMultipleChoicesID() {
        return this.multipleChoicesID;
    }

    @Generated
    public void setHasExecutableItems(Map<String, FeatureInterface> hasExecutableItems) {
        this.hasExecutableItems = hasExecutableItems;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }

    @Generated
    public void setMultipleChoicesID(String multipleChoicesID) {
        this.multipleChoicesID = multipleChoicesID;
    }
}

