/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.loop;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LoopFeatures
extends FeatureWithHisOwnEditor<LoopFeatures, LoopFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private IntegerFeature delay;
    private BooleanFeature delayInTick;

    public LoopFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.loop);
        this.reset();
    }

    @Override
    public void reset() {
        this.delay = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.delay);
        this.delayInTick = new BooleanFeature(this, false, FeatureSettingsSCore.delayInTick);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>(this.delay.load(plugin, config, isPremiumLoading));
        if ((Integer)((Optional)this.delay.getValue()).get() <= 0) {
            this.delay.setValue(Optional.of(1));
        }
        errors.addAll(this.delayInTick.load(plugin, config, isPremiumLoading));
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        this.delay.save(config);
        this.delayInTick.save(config);
    }

    @Override
    public LoopFeatures getValue() {
        return this;
    }

    @Override
    public LoopFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = "&7Delay: &e" + String.valueOf(((Optional)this.delay.getValue()).get());
        finalDescription[finalDescription.length - 1] = this.delayInTick.getValue() != false ? "&7In ticks: &a&l\u2714" : "&7In ticks: &c&l\u2718";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public LoopFeatures clone(FeatureParentInterface newParent) {
        LoopFeatures loopFeatures = new LoopFeatures(newParent);
        loopFeatures.setDelay(this.delay.clone(loopFeatures));
        loopFeatures.setDelayInTick(this.delayInTick.clone(loopFeatures));
        return loopFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.delay, this.delayInTick));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof LoopFeatures)) continue;
            LoopFeatures loopFeatures = (LoopFeatures)feature;
            loopFeatures.setDelay(this.delay);
            loopFeatures.setDelayInTick(this.delayInTick);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public IntegerFeature getDelay() {
        return this.delay;
    }

    @Generated
    public BooleanFeature getDelayInTick() {
        return this.delayInTick;
    }

    @Generated
    public void setDelay(IntegerFeature delay) {
        this.delay = delay;
    }

    @Generated
    public void setDelayInTick(BooleanFeature delayInTick) {
        this.delayInTick = delayInTick;
    }
}

