/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.materialwithgroupsandtags.materialandtags;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.MaterialWithGroupsFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.MaterialWithGroups;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MaterialAndTagsFeature
extends FeatureWithHisOwnEditor<MaterialAndTagsFeature, MaterialAndTagsFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private static final String symbolStart = "{";
    private static final String symbolEnd = "}";
    private static final String symbolEquals = ":";
    private static final String symbolSeparator = "\\+";
    private MaterialWithGroupsFeature material;
    private UncoloredStringFeature tags;
    private String id;
    private boolean acceptAir;
    private boolean acceptItems;
    private boolean acceptBlocks;

    public MaterialAndTagsFeature(FeatureParentInterface parent, String id, boolean acceptAir, boolean acceptItems, boolean acceptBlocks) {
        super(parent, FeatureSettingsSCore.materialAndTags);
        this.id = id;
        this.acceptAir = acceptAir;
        this.acceptItems = acceptItems;
        this.acceptBlocks = acceptBlocks;
        this.reset();
    }

    @Override
    public void reset() {
        this.material = new MaterialWithGroupsFeature(this, Optional.of(MaterialWithGroups.getMaterialWithGroupsList(this.acceptAir, this.acceptItems, this.acceptBlocks).get(0)), FeatureSettingsSCore.material, this.acceptAir, this.acceptItems, this.acceptBlocks);
        this.tags = new UncoloredStringFeature(this, Optional.empty(), FeatureSettingsSCore.tags, false);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.material.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.tags.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Material and Tags option because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.material.save(attributeConfig);
        this.tags.save(attributeConfig);
    }

    @Override
    public MaterialAndTagsFeature getValue() {
        return this;
    }

    @Override
    public MaterialAndTagsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = "&7Material: &e" + (String)((Optional)this.material.getValue()).get();
        if (((Optional)this.tags.getValue()).isPresent()) {
            Object command = (String)((Optional)this.tags.getValue()).get();
            if (((String)command).length() > 40) {
                command = ((String)command).substring(0, 39) + "...";
            }
            finalDescription[finalDescription.length - 2] = "&7Tags: &e" + (String)command;
        } else {
            finalDescription[finalDescription.length - 2] = "&7Tags: &cNO TAGS DEFINED";
        }
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(MaterialWithGroups.getMaterial((String)((Optional)this.material.getValue()).get()), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public MaterialAndTagsFeature clone(FeatureParentInterface newParent) {
        MaterialAndTagsFeature eF = new MaterialAndTagsFeature(newParent, this.id, this.isAcceptAir(), this.isAcceptItems(), this.isAcceptBlocks());
        eF.setMaterial(this.material.clone(eF));
        eF.setTags(this.tags.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.material, this.tags));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            MaterialAndTagsFeature aFOF;
            if (!(feature instanceof MaterialAndTagsFeature) || !(aFOF = (MaterialAndTagsFeature)feature).getId().equals(this.id)) continue;
            aFOF.setMaterial(this.material);
            aFOF.setTags(this.tags);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public MaterialWithGroupsFeature getMaterial() {
        return this.material;
    }

    @Generated
    public UncoloredStringFeature getTags() {
        return this.tags;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public boolean isAcceptAir() {
        return this.acceptAir;
    }

    @Generated
    public boolean isAcceptItems() {
        return this.acceptItems;
    }

    @Generated
    public boolean isAcceptBlocks() {
        return this.acceptBlocks;
    }

    @Generated
    public void setMaterial(MaterialWithGroupsFeature material) {
        this.material = material;
    }

    @Generated
    public void setTags(UncoloredStringFeature tags) {
        this.tags = tags;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setAcceptAir(boolean acceptAir) {
        this.acceptAir = acceptAir;
    }

    @Generated
    public void setAcceptItems(boolean acceptItems) {
        this.acceptItems = acceptItems;
    }

    @Generated
    public void setAcceptBlocks(boolean acceptBlocks) {
        this.acceptBlocks = acceptBlocks;
    }
}

