/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.nbttags;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireSubTextEditorInEditor;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.nbttags.BooleanNBTTag;
import com.ssomar.score.features.custom.nbttags.ByteNBTTag;
import com.ssomar.score.features.custom.nbttags.CompoundNBTTag;
import com.ssomar.score.features.custom.nbttags.DoubleNBTTag;
import com.ssomar.score.features.custom.nbttags.IntNBTTag;
import com.ssomar.score.features.custom.nbttags.ListCompoundNBTTag;
import com.ssomar.score.features.custom.nbttags.ListStringNBTTag;
import com.ssomar.score.features.custom.nbttags.NBTTag;
import com.ssomar.score.features.custom.nbttags.StringNBTTag;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import de.tr7zw.nbtapi.NBT;
import de.tr7zw.nbtapi.NBTItem;
import de.tr7zw.nbtapi.NBTType;
import de.tr7zw.nbtapi.iface.ReadWriteItemNBT;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NBTTags
extends FeatureAbstract<Optional<List<String>>, NBTTags>
implements FeatureRequireSubTextEditorInEditor {
    private static final long serialVersionUID = 1L;
    private ArrayList<NBTTag> tags = new ArrayList();

    public NBTTags(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.nbt);
    }

    public static List<String> blackListedTags() {
        ArrayList<String> blackListedTags = new ArrayList<String>();
        blackListedTags.add("Enchantments");
        blackListedTags.add("Unbreakable");
        blackListedTags.add("Damage");
        blackListedTags.add("display");
        blackListedTags.add("Lore");
        blackListedTags.add("HideFlags");
        blackListedTags.add("score:usage");
        blackListedTags.add("executableitems:ei-id");
        if (!SCore.is1v12Less()) {
            blackListedTags.add("AttributeModifiers");
            blackListedTags.add("CustomModelData");
            blackListedTags.add("Name");
        }
        return blackListedTags;
    }

    public void load(ItemStack item) {
        if (SCore.hasNBTAPI) {
            NBTItem nbti = new NBTItem(item);
            SsomarDev.testMsg(" >>>>>>> load nbt tags of item: " + String.valueOf(item.getType()), true);
            for (String s : nbti.getKeys()) {
                if (NBTTags.blackListedTags().contains(s)) {
                    SsomarDev.testMsg(" >>>>>>> blacklisted tag: " + s, true);
                    continue;
                }
                NBTType type = nbti.getType(s);
                SsomarDev.testMsg(" >>>>>>> load tag: " + s + " type: " + String.valueOf(type), true);
                block0 : switch (type) {
                    case NBTTagInt: {
                        this.tags.add(new IntNBTTag(s, nbti.getInteger(s)));
                        break;
                    }
                    case NBTTagByte: {
                        this.tags.add(new ByteNBTTag(s, nbti.getByte(s)));
                        break;
                    }
                    case NBTTagCompound: {
                        this.tags.add(new CompoundNBTTag(s, nbti.getCompound(s)));
                        break;
                    }
                    case NBTTagDouble: {
                        this.tags.add(new DoubleNBTTag(s, nbti.getDouble(s)));
                        break;
                    }
                    case NBTTagList: {
                        switch (nbti.getListType(s)) {
                            case NBTTagString: {
                                this.tags.add(new ListStringNBTTag(s, (List<String>)nbti.getStringList(s)));
                                break block0;
                            }
                        }
                        this.tags.add(new ListCompoundNBTTag(s, nbti.getCompoundList(s)));
                        break;
                    }
                    case NBTTagString: {
                        this.tags.add(new StringNBTTag(s, nbti.getString(s)));
                    }
                }
            }
        }
    }

    @Override
    public List<String> load(SPlugin sPlugin, ConfigurationSection configurationSection, boolean isPremiumLoading) {
        this.tags.clear();
        ArrayList<String> error = new ArrayList<String>();
        if (configurationSection.contains("nbt")) {
            if (!isPremiumLoading && this.isRequirePremium()) {
                error.add(StringConverter.coloredString("&cREQUIRE PREMIUM: to edit NBT you need the premium version"));
            } else {
                ConfigurationSection nbtSection = configurationSection.getConfigurationSection("nbt");
                block23: for (String nbtId : nbtSection.getKeys(false)) {
                    ConfigurationSection tagSection = nbtSection.getConfigurationSection(nbtId);
                    String type = tagSection.getString("type").toUpperCase();
                    String key = tagSection.getString("key");
                    NBTTag tag = null;
                    switch (type) {
                        case "BOOLEAN": 
                        case "BOOL": {
                            tag = new BooleanNBTTag(tagSection);
                            break;
                        }
                        case "STRING": 
                        case "STR": {
                            tag = new StringNBTTag(tagSection);
                            break;
                        }
                        case "DOUBLE": {
                            tag = new DoubleNBTTag(tagSection);
                            break;
                        }
                        case "INTEGER": 
                        case "INT": {
                            tag = new IntNBTTag(tagSection);
                            break;
                        }
                        case "BYTE": {
                            tag = new ByteNBTTag(tagSection);
                            break;
                        }
                        case "COMPOUND": {
                            tag = new CompoundNBTTag(tagSection);
                            break;
                        }
                        case "STRING_LIST": {
                            tag = new ListStringNBTTag(tagSection);
                            break;
                        }
                        case "COMPOUND_LIST": {
                            tag = new ListCompoundNBTTag(tagSection);
                            break;
                        }
                        default: {
                            error.add("&cInvalid nbt type for the nbt with the id: " + nbtId + ", look the wiki !");
                            continue block23;
                        }
                    }
                    this.tags.add(tag);
                }
            }
        }
        return error;
    }

    public List<String> load(SPlugin sPlugin, List<String> list, boolean isPremiumLoading) {
        File file = new File(sPlugin.getPlugin().getDataFolder(), "nbt.yml");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        int i = 0;
        for (String s : list) {
            String[] split = s.split("::");
            config.set("nbt." + i + ".type", (Object)split[0]);
            config.set("nbt." + i + ".key", (Object)split[1]);
            config.set("nbt." + i + ".value", (Object)split[2]);
        }
        file.delete();
        return this.load(sPlugin, (ConfigurationSection)config, isPremiumLoading);
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("nbt", null);
        int i = 0;
        for (NBTTag tag : this.tags) {
            tag.saveInConfig(config, i);
            ++i;
        }
    }

    @Override
    public Optional<List<String>> getValue() {
        ArrayList<String> list = new ArrayList<String>();
        for (NBTTag tag : this.tags) {
            if (!(tag instanceof StringNBTTag) && !(tag instanceof BooleanNBTTag) && !(tag instanceof DoubleNBTTag) && !(tag instanceof IntNBTTag)) continue;
            list.add(tag.toString());
        }
        return Optional.of(list);
    }

    @Override
    public NBTTags initItemParentEditor(GUI gui, int i) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, i, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        gui.updateConditionList(this.getEditorName(), this.getCurrentValues(), "&cEMPTY");
    }

    @Override
    public void reset() {
        ArrayList<NBTTag> toRemove = new ArrayList<NBTTag>();
        for (NBTTag tag : this.tags) {
            if (!(tag instanceof StringNBTTag) && !(tag instanceof BooleanNBTTag) && !(tag instanceof DoubleNBTTag) && !(tag instanceof IntNBTTag)) continue;
            toRemove.add(tag);
        }
        this.tags.removeAll(toRemove);
    }

    public ItemStack writeNBTTags(ItemStack item) {
        if (SCore.hasNBTAPI) {
            NBT.modify((ItemStack)item, nbtItem -> {
                Optional<ReadWriteItemNBT> nbtItemOptional = Optional.of(nbtItem);
                for (NBTTag nbtTag : this.tags) {
                    nbtTag.applyTo((ReadWriteNBT)nbtItemOptional.get(), true);
                }
            });
        }
        return item;
    }

    @Override
    public NBTTags clone(FeatureParentInterface featureParentInterface) {
        NBTTags clone = new NBTTags(featureParentInterface);
        clone.tags = this.tags;
        return clone;
    }

    @Override
    public Optional<String> verifyMessageReceived(String s) {
        String[] split = s.split("::");
        if (split.length < 3) {
            return Optional.of("&cInvalid format ! &7TYPE::KEY::VALUE");
        }
        String type = split[0].toUpperCase();
        String[] acceptedTypes = new String[]{"BOOLEAN", "STRING", "DOUBLE", "INTEGER"};
        if (!Arrays.asList(acceptedTypes).contains(type)) {
            return Optional.of("&cInvalid type ! &7BOOLEAN, STRING, DOUBLE, INTEGER");
        }
        return Optional.empty();
    }

    @Override
    public List<String> getCurrentValues() {
        if (((Optional)this.getValue()).isPresent()) {
            return (List)((Optional)this.getValue()).get();
        }
        return new ArrayList<String>();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        Suggestion suggestion = new Suggestion("BOOLEAN::MY_KEY::MY_VALUE", "&6[&7Boolean&6]", "&7&oClick here to add a &eboolean &7nbt");
        Suggestion suggestion1 = new Suggestion("STRING::MY_KEY::MY_VALUE", "&6[&7String&6]", "&7&oClick here to add a &estring &7nbt");
        Suggestion suggestion2 = new Suggestion("DOUBLE::MY_KEY::MY_VALUE", "&6[&7Double&6]", "&7&oClick here to add a &edouble &7nbt");
        Suggestion suggestion3 = new Suggestion("INTEGER::MY_KEY::MY_VALUE", "&6[&7Integer&6]", "&7&oClick here to add a &einteger &7nbt");
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        suggestions.add(suggestion);
        suggestions.add(suggestion1);
        suggestions.add(suggestion2);
        suggestions.add(suggestion3);
        return suggestions;
    }

    @Override
    public String getTips() {
        return "&7&o Type &eTYPE&a::&eKEY&a::&eVALUE";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    @Override
    public void finishEditInSubEditor(Player editor, NewGUIManager manager) {
        this.reset();
        ArrayList<NBTTag> saveOthers = new ArrayList<NBTTag>(this.tags);
        List<String> values = StringConverter.decoloredString(manager.currentWriting.get(editor));
        this.load((SPlugin)ExecutableItems.plugin, values, this.isRequirePremium());
        this.tags.addAll(saveOthers);
        manager.requestWriting.remove(editor);
        manager.activeTextEditor.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }
}

