/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.patterns.subpattern;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.patterns.subpattern.SubPatternFeatureEditor;
import com.ssomar.score.features.custom.patterns.subpattern.SubPatternFeatureEditorManager;
import com.ssomar.score.features.types.ObjectFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SubPatternFeature
extends FeatureWithHisOwnEditor<SubPatternFeature, SubPatternFeature, SubPatternFeatureEditor, SubPatternFeatureEditorManager> {
    private UncoloredStringFeature string;
    private ObjectFeature object;
    private String id;

    public SubPatternFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.subPattern);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.string = new UncoloredStringFeature(this, Optional.empty(), FeatureSettingsSCore.string, false);
        this.object = new ObjectFeature(this, FeatureSettingsSCore.object);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.string.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.object.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Sub Pattern with its options because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.string.save(attributeConfig);
        this.object.save(attributeConfig);
    }

    @Override
    public SubPatternFeature getValue() {
        return this;
    }

    @Override
    public SubPatternFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 1];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public SubPatternFeature clone(FeatureParentInterface newParent) {
        SubPatternFeature eF = new SubPatternFeature(newParent, this.id);
        eF.setString(this.string.clone(eF));
        eF.setObject(this.object.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.string, this.object));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            SubPatternFeature aFOF;
            if (!(feature instanceof SubPatternFeature) || !(aFOF = (SubPatternFeature)feature).getId().equals(this.id)) continue;
            aFOF.setString(this.string);
            aFOF.setObject(this.object);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        SubPatternFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public UncoloredStringFeature getString() {
        return this.string;
    }

    @Generated
    public ObjectFeature getObject() {
        return this.object;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setString(UncoloredStringFeature string) {
        this.string = string;
    }

    @Generated
    public void setObject(ObjectFeature object) {
        this.object = object;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

