/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.potioneffects.potioneffect;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.PotionEffectTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class PotionEffectFeature
extends FeatureWithHisOwnEditor<PotionEffectFeature, PotionEffectFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private IntegerFeature amplifier;
    private IntegerFeature duration;
    private PotionEffectTypeFeature type;
    private BooleanFeature ambient;
    private BooleanFeature particles;
    private BooleanFeature icon;
    private String id;

    public PotionEffectFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.potionEffect);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        PotionEffectType type = SCore.is1v20v5Plus() ? PotionEffectType.HEALTH_BOOST : PotionEffectType.getByName((String)"HEAL");
        this.amplifier = new IntegerFeature(this, Optional.ofNullable(0), FeatureSettingsSCore.amplifier);
        this.duration = new IntegerFeature(this, Optional.ofNullable(30), FeatureSettingsSCore.duration);
        this.type = new PotionEffectTypeFeature(this, Optional.ofNullable(type), FeatureSettingsSCore.potionEffectType);
        this.ambient = new BooleanFeature(this, false, FeatureSettingsSCore.isAmbient);
        this.particles = new BooleanFeature(this, false, FeatureSettingsSCore.hasParticles);
        this.icon = new BooleanFeature(this, false, FeatureSettingsSCore.hasIcon);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.amplifier.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.duration.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.type.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.ambient.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.particles.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.icon.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Attribute with its options because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    public PotionEffect getPotionEffect() {
        if (SCore.is1v12Less()) {
            return new PotionEffect((PotionEffectType)((Optional)this.type.getValue()).get(), ((Integer)((Optional)this.duration.getValue()).get()).intValue(), ((Integer)((Optional)this.amplifier.getValue()).get()).intValue(), this.ambient.getValue().booleanValue(), this.particles.getValue().booleanValue());
        }
        return new PotionEffect((PotionEffectType)((Optional)this.type.getValue()).get(), ((Integer)((Optional)this.duration.getValue()).get()).intValue(), ((Integer)((Optional)this.amplifier.getValue()).get()).intValue(), this.ambient.getValue().booleanValue(), this.particles.getValue().booleanValue(), this.icon.getValue().booleanValue());
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.ambient.save(attributeConfig);
        this.duration.save(attributeConfig);
        this.type.save(attributeConfig);
        this.amplifier.save(attributeConfig);
        this.particles.save(attributeConfig);
        this.icon.save(attributeConfig);
    }

    @Override
    public PotionEffectFeature getValue() {
        return this;
    }

    @Override
    public PotionEffectFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 7];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 7] = "&7Type: &e" + ((PotionEffectType)((Optional)this.type.getValue()).get()).getName();
        finalDescription[finalDescription.length - 6] = "&7Amplifier: &e" + String.valueOf(((Optional)this.amplifier.getValue()).get());
        finalDescription[finalDescription.length - 5] = "&7Duration: &e" + String.valueOf(((Optional)this.duration.getValue()).get());
        finalDescription[finalDescription.length - 4] = this.ambient.getValue() != false ? "&7Ambient: &a&l\u2714" : "&7Ambient: &c&l\u2718";
        finalDescription[finalDescription.length - 3] = this.particles.getValue() != false ? "&7Particles: &a&l\u2714" : "&7Particles: &c&l\u2718";
        finalDescription[finalDescription.length - 2] = SCore.is1v11Less() ? "&7Icon : &c&lNot for 1.12 or lower" : (this.icon.getValue() != false ? "&7Icon: &a&l\u2714" : "&7Icon: &c&l\u2718");
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public PotionEffectFeature clone(FeatureParentInterface newParent) {
        PotionEffectFeature eF = new PotionEffectFeature(newParent, this.id);
        eF.setAmbient(this.ambient.clone(eF));
        eF.setDuration(this.duration.clone(eF));
        eF.setType(this.type.clone(eF));
        eF.setAmplifier(this.amplifier.clone(eF));
        eF.setParticles(this.particles.clone(eF));
        eF.setIcon(this.icon.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.type);
        features.add(this.amplifier);
        features.add(this.duration);
        features.add(this.ambient);
        features.add(this.particles);
        if (!SCore.is1v12Less()) {
            features.add(this.icon);
        }
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            PotionEffectFeature aFOF;
            if (!(feature instanceof PotionEffectFeature) || !(aFOF = (PotionEffectFeature)feature).getId().equals(this.id)) continue;
            aFOF.setAmbient(this.ambient);
            aFOF.setDuration(this.duration);
            aFOF.setType(this.type);
            aFOF.setAmplifier(this.amplifier);
            aFOF.setParticles(this.particles);
            aFOF.setIcon(this.icon);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public IntegerFeature getAmplifier() {
        return this.amplifier;
    }

    @Generated
    public IntegerFeature getDuration() {
        return this.duration;
    }

    @Generated
    public PotionEffectTypeFeature getType() {
        return this.type;
    }

    @Generated
    public BooleanFeature getAmbient() {
        return this.ambient;
    }

    @Generated
    public BooleanFeature getParticles() {
        return this.particles;
    }

    @Generated
    public BooleanFeature getIcon() {
        return this.icon;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setAmplifier(IntegerFeature amplifier) {
        this.amplifier = amplifier;
    }

    @Generated
    public void setDuration(IntegerFeature duration) {
        this.duration = duration;
    }

    @Generated
    public void setType(PotionEffectTypeFeature type) {
        this.type = type;
    }

    @Generated
    public void setAmbient(BooleanFeature ambient) {
        this.ambient = ambient;
    }

    @Generated
    public void setParticles(BooleanFeature particles) {
        this.particles = particles;
    }

    @Generated
    public void setIcon(BooleanFeature icon) {
        this.icon = icon;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

