/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.recognition;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireSubTextEditorInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.custom.recognition.Recognition;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;

public class ListRecognitionFeature
extends FeatureAbstract<List<Recognition>, ListRecognitionFeature>
implements FeatureRequireSubTextEditorInEditor {
    private List<Recognition> value;
    private List<Recognition> defaultValue;

    public ListRecognitionFeature(FeatureParentInterface parent, List<Recognition> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        this.value = new ArrayList<Recognition>();
        for (String s : config.getStringList(this.getName())) {
            s = StringConverter.decoloredString(s);
            try {
                Recognition mat = Recognition.valueOf(s.toUpperCase());
                this.value.add(mat);
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the Recognition value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> Recognition available: MATERIAL, NAME, LORE, HIDE_ATTRIBUTE, By default its HIDE_ATTRIBUTE !");
            }
        }
        FeatureReturnCheckPremium<List<Recognition>> checkPremium = this.checkPremium("List of Recognitions", this.value, Optional.of(this.defaultValue), isPremiumLoading);
        if (checkPremium.isHasError()) {
            this.value = checkPremium.getNewValue();
        }
        return errors;
    }

    public boolean isClassicRecognition() {
        return this.value.isEmpty() || this.value.contains((Object)Recognition.HIDE_ATTRIBUTE);
    }

    public List<Recognition> getCustomRecognitions() {
        ArrayList<Recognition> customRecognitions = new ArrayList<Recognition>();
        if (this.value.contains((Object)Recognition.MATERIAL)) {
            customRecognitions.add(Recognition.MATERIAL);
        }
        if (this.value.contains((Object)Recognition.NAME)) {
            customRecognitions.add(Recognition.NAME);
        }
        if (this.value.contains((Object)Recognition.LORE)) {
            customRecognitions.add(Recognition.LORE);
        }
        return customRecognitions;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (this.isSavingOnlyIfDiffDefault() && new HashSet<Recognition>(this.defaultValue).containsAll(this.getCurrentValues())) {
            config.set(this.getName(), null);
            return;
        }
        config.set(this.getName(), this.getCurrentValues());
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public List<Recognition> getValue() {
        return this.value;
    }

    @Override
    public ListRecognitionFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        gui.updateConditionList(this.getEditorName(), this.getCurrentValues(), "&cEMPTY");
    }

    @Override
    public ListRecognitionFeature clone(FeatureParentInterface newParent) {
        ListRecognitionFeature clone = new ListRecognitionFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValue((List<Recognition>)this.getValue());
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        message = StringConverter.decoloredString(message);
        try {
            Recognition mat = Recognition.valueOf(message);
            this.value.add(mat);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of("&4&l[ERROR] &cThe message you entered is not a Recognition &6>> Recognition available: MATERIAL, NAME, LORE, HIDE_ATTRIBUTE, By default its HIDE_ATTRIBUTE !");
        }
    }

    @Override
    public List<String> getCurrentValues() {
        ArrayList<String> currentValues = new ArrayList<String>();
        for (Recognition mat : this.value) {
            currentValues.add(mat.name());
        }
        return currentValues;
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (EntityDamageEvent.DamageCause mat : EntityDamageEvent.DamageCause.values()) {
            map.put(mat.toString(), new Suggestion(String.valueOf(mat), "&6[&e" + String.valueOf(mat) + "&6]", "&7Add &e" + String.valueOf(mat)));
        }
        return new ArrayList<Suggestion>(map.values());
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void finishEditInSubEditor(Player editor, NewGUIManager manager) {
        this.value = new ArrayList<Recognition>();
        for (String s : manager.currentWriting.get(editor)) {
            s = StringConverter.decoloredString(s);
            try {
                Recognition mat = Recognition.valueOf(s);
                this.value.add(mat);
            }
            catch (Exception exception) {}
        }
        manager.requestWriting.remove(editor);
        manager.activeTextEditor.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, true, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    @Generated
    public List<Recognition> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(List<Recognition> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(List<Recognition> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

