/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.required.executableitems.item;

import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.SCore;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.required.RequiredPlayerInterface;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.ExecutableItemFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringCalculation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class RequiredExecutableItemFeature
extends FeatureWithHisOwnEditor<RequiredExecutableItemFeature, RequiredExecutableItemFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements RequiredPlayerInterface {
    private ExecutableItemFeature executableItem;
    private IntegerFeature amount;
    private String id;
    private NumberConditionFeature usageCondition;

    public RequiredExecutableItemFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.requiredExecutableItem);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.executableItem = new ExecutableItemFeature(this, FeatureSettingsSCore.executableItem);
        this.amount = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.amount);
        this.usageCondition = new NumberConditionFeature(this, FeatureSettingsSCore.usageConditions);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.executableItem.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.amount.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.usageCondition.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Required ExecutableItem because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.executableItem.save(attributeConfig);
        this.amount.save(attributeConfig);
        this.usageCondition.save(attributeConfig);
    }

    @Override
    public RequiredExecutableItemFeature getValue() {
        return this;
    }

    @Override
    public RequiredExecutableItemFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        ItemStack item = new ItemStack(Material.STONE);
        if (((Optional)this.executableItem.getValue()).isPresent()) {
            finalDescription[finalDescription.length - 3] = "&7&oExecutableItem: &a" + ((ExecutableItemInterface)((Optional)this.executableItem.getValue()).get()).getId();
            item = ((ExecutableItemInterface)((Optional)this.executableItem.getValue()).get()).buildItem(1, Optional.empty(), Optional.empty());
        } else {
            finalDescription[finalDescription.length - 3] = "&7&oExecutableItem: &cNone";
        }
        finalDescription[finalDescription.length - 2] = "&7Amount: &e" + String.valueOf(((Optional)this.amount.getValue()).get());
        finalDescription[finalDescription.length - 1] = ((Optional)this.usageCondition.getValue()).isPresent() ? "&7Usage Condition: &e" + (String)((Optional)this.usageCondition.getValue()).get() : "&7Usage Condition: &cNO CONDITION";
        gui.createItem(item, 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RequiredExecutableItemFeature clone(FeatureParentInterface newParent) {
        RequiredExecutableItemFeature eF = new RequiredExecutableItemFeature(newParent, this.id);
        eF.setExecutableItem(this.executableItem.clone(eF));
        eF.setAmount(this.amount.clone(eF));
        eF.setUsageCondition(this.usageCondition.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.executableItem, this.amount, this.usageCondition));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            RequiredExecutableItemFeature aFOF;
            if (!(feature instanceof RequiredExecutableItemFeature) || !(aFOF = (RequiredExecutableItemFeature)feature).getId().equals(this.id)) continue;
            aFOF.setExecutableItem(this.executableItem);
            aFOF.setAmount(this.amount);
            aFOF.setUsageCondition(this.usageCondition);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean verify(Player player, Event event, StringPlaceholder sp) {
        PlayerInventory inventory = player.getInventory();
        return this.verify((Inventory)inventory, event, sp);
    }

    public boolean verify(Inventory inventory, Event event, StringPlaceholder sp) {
        int needed = this.amount.getValue(null, sp).get();
        if (!SCore.hasExecutableItems || !((Optional)this.getExecutableItem().getValue()).isPresent()) {
            return true;
        }
        for (ItemStack it : inventory.getContents()) {
            if (it == null) continue;
            ExecutableItemObject eiObject = new ExecutableItemObject(it);
            if (eiObject.isValid() && eiObject.getConfig().getId().equalsIgnoreCase(((ExecutableItemInterface)((Optional)this.executableItem.getValue()).get()).getId())) {
                if (((Optional)this.getUsageCondition().getValue()).isPresent()) {
                    eiObject.loadExecutableItemInfos();
                    if (!StringCalculation.calculation((String)((Optional)this.getUsageCondition().getValue()).get(), eiObject.getUsage())) continue;
                }
                needed -= it.getAmount();
            }
            if (needed > 0) continue;
            return true;
        }
        return needed <= 0;
    }

    @Override
    public void take(Player player, StringPlaceholder sp) {
        PlayerInventory inventory = player.getInventory();
        int needed = this.amount.getValue(player.getUniqueId(), sp).get();
        if (!SCore.hasExecutableItems || !((Optional)this.getExecutableItem().getValue()).isPresent()) {
            return;
        }
        for (ItemStack it : inventory.getContents()) {
            Optional<ExecutableItemInterface> eiOpt = ExecutableItemsAPI.getExecutableItemsManager().getExecutableItem(it);
            if (!eiOpt.isPresent() || !eiOpt.get().getId().equalsIgnoreCase(((ExecutableItemInterface)((Optional)this.executableItem.getValue()).get()).getId())) continue;
            if (needed >= it.getAmount()) {
                needed -= it.getAmount();
                int slot = -1;
                for (ItemStack item : inventory.getContents()) {
                    ++slot;
                    if (item != null && item.equals((Object)it)) break;
                }
                inventory.clear(slot);
            } else {
                it.setAmount(it.getAmount() - needed);
                needed = 0;
            }
            if (needed <= 0) break;
        }
        player.updateInventory();
    }

    @Generated
    public ExecutableItemFeature getExecutableItem() {
        return this.executableItem;
    }

    @Generated
    public IntegerFeature getAmount() {
        return this.amount;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public NumberConditionFeature getUsageCondition() {
        return this.usageCondition;
    }

    @Generated
    public void setExecutableItem(ExecutableItemFeature executableItem) {
        this.executableItem = executableItem;
    }

    @Generated
    public void setAmount(IntegerFeature amount) {
        this.amount = amount;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setUsageCondition(NumberConditionFeature usageCondition) {
        this.usageCondition = usageCondition;
    }
}

