/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.required.items.item;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.required.RequiredPlayerInterface;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.MaterialFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class RequiredItemFeature
extends FeatureWithHisOwnEditor<RequiredItemFeature, RequiredItemFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements RequiredPlayerInterface {
    private static final Boolean DEBUG = false;
    private MaterialFeature material;
    private IntegerFeature amount;
    private BooleanFeature notExecutableItem;
    private String id;

    public RequiredItemFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.requiredItem);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.material = new MaterialFeature(this, Optional.of(Material.STONE), FeatureSettingsSCore.material);
        this.amount = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.amount);
        this.notExecutableItem = new BooleanFeature(this, false, FeatureSettingsSCore.notExecutableItem);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.material.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.amount.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.notExecutableItem.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Required Item because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.material.save(attributeConfig);
        this.amount.save(attributeConfig);
        this.notExecutableItem.save(attributeConfig);
    }

    @Override
    public RequiredItemFeature getValue() {
        return this;
    }

    @Override
    public RequiredItemFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = "&7Material: &e" + ((Material)((Optional)this.material.getValue()).get()).name();
        finalDescription[finalDescription.length - 1] = "&7Amount: &e" + String.valueOf(((Optional)this.amount.getValue()).get());
        gui.createItem((Material)((Optional)this.material.getValue()).get(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RequiredItemFeature clone(FeatureParentInterface newParent) {
        RequiredItemFeature eF = new RequiredItemFeature(newParent, this.id);
        eF.setMaterial(this.material.clone(eF));
        eF.setAmount(this.amount.clone(eF));
        eF.setNotExecutableItem(this.notExecutableItem.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.material, this.amount, this.notExecutableItem));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            RequiredItemFeature aFOF;
            if (!(feature instanceof RequiredItemFeature) || !(aFOF = (RequiredItemFeature)feature).getId().equals(this.id)) continue;
            aFOF.setMaterial(this.material);
            aFOF.setAmount(this.amount);
            aFOF.setNotExecutableItem(this.notExecutableItem);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean verify(Player player, Event event, StringPlaceholder sp) {
        PlayerInventory inventory = player.getInventory();
        return this.verify((Inventory)inventory, event, sp);
    }

    public boolean verify(Inventory inventory, Event event, StringPlaceholder sp) {
        int needed = this.amount.getValue(null, sp).get();
        for (ItemStack it : inventory.getContents()) {
            if (it == null || !it.getType().equals(((Optional)this.material.getValue()).get())) continue;
            if (!this.notExecutableItem.getValue().booleanValue() || !SCore.hasExecutableItems) {
                needed -= it.getAmount();
            } else {
                Optional<ExecutableItemInterface> eiOpt = ExecutableItemsAPI.getExecutableItemsManager().getExecutableItem(it);
                if (eiOpt.isPresent()) continue;
                needed -= it.getAmount();
            }
            if (needed > 0) continue;
            return true;
        }
        return needed <= 0;
    }

    @Override
    public void take(Player player, StringPlaceholder sp) {
        PlayerInventory inventory = player.getInventory();
        int needed = this.amount.getValue(player.getUniqueId(), sp).get();
        SsomarDev.testMsg("required item: " + ((Material)((Optional)this.material.getValue()).get()).name() + " " + String.valueOf(this.amount.getValue(player.getUniqueId(), sp).get()), DEBUG);
        ItemStack itemStack = player.getItemOnCursor();
        SsomarDev.testMsg("item on cursor: " + itemStack.getType().name() + " " + itemStack.getAmount(), true);
        for (ItemStack it : inventory.getContents()) {
            if (it == null || !it.getType().equals(((Optional)this.material.getValue()).get())) continue;
            SsomarDev.testMsg("item: " + it.getType().name() + " " + it.getAmount(), DEBUG);
            if (!this.notExecutableItem.getValue().booleanValue() || !SCore.hasExecutableItems) {
                if (needed >= it.getAmount()) {
                    needed -= it.getAmount();
                    int slot = inventory.first(it);
                    inventory.clear(slot);
                } else {
                    it.setAmount(it.getAmount() - needed);
                    SsomarDev.testMsg("new amount: " + it.getAmount(), DEBUG);
                    needed = 0;
                }
            } else {
                SsomarDev.testMsg("executable item", DEBUG);
                Optional<ExecutableItemInterface> eiOpt = ExecutableItemsAPI.getExecutableItemsManager().getExecutableItem(it);
                if (eiOpt.isPresent()) continue;
                if (needed >= it.getAmount()) {
                    needed -= it.getAmount();
                    int slot = -1;
                    for (ItemStack item : inventory.getContents()) {
                        ++slot;
                        if (item != null && item.equals((Object)it)) break;
                    }
                    SsomarDev.testMsg("slot: " + slot, DEBUG);
                    inventory.clear(slot);
                } else {
                    it.setAmount(it.getAmount() - needed);
                    SsomarDev.testMsg("new amount: " + it.getAmount(), DEBUG);
                    needed = 0;
                }
            }
            if (needed <= 0) break;
        }
        player.updateInventory();
    }

    @Generated
    public MaterialFeature getMaterial() {
        return this.material;
    }

    @Generated
    public IntegerFeature getAmount() {
        return this.amount;
    }

    @Generated
    public BooleanFeature getNotExecutableItem() {
        return this.notExecutableItem;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setMaterial(MaterialFeature material) {
        this.material = material;
    }

    @Generated
    public void setAmount(IntegerFeature amount) {
        this.amount = amount;
    }

    @Generated
    public void setNotExecutableItem(BooleanFeature notExecutableItem) {
        this.notExecutableItem = notExecutableItem;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

