/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.required.mana;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.required.RequiredPlayerInterface;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.AuraSkillsAPI;
import com.ssomar.score.usedapi.AureliumSkillsAPI;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.usedapi.MMOCoreAPI;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class RequiredMana
extends FeatureWithHisOwnEditor<RequiredMana, RequiredMana, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements RequiredPlayerInterface {
    private IntegerFeature mana;
    private ColoredStringFeature errorMessage;
    private BooleanFeature cancelEventIfError;

    public RequiredMana(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.requiredMana);
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            if (!isPremiumLoading) {
                error.add("&cERROR, Couldn't load the Required Mana value of " + this.getName() + " from config, &7&o" + this.getParent().getParentInfo() + " &6>> Because it's a premium feature !");
                return error;
            }
            this.mana.load(plugin, section, isPremiumLoading);
            this.errorMessage.load(plugin, section, isPremiumLoading);
            this.cancelEventIfError.load(plugin, section, isPremiumLoading);
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (((Optional)this.mana.getValue()).isPresent() && (Integer)((Optional)this.mana.getValue()).get() > 0) {
            ConfigurationSection requiredMoneySection = config.createSection(this.getName());
            this.mana.save(requiredMoneySection);
            this.errorMessage.save(requiredMoneySection);
            this.cancelEventIfError.save(requiredMoneySection);
            if (this.isSavingOnlyIfDiffDefault() && requiredMoneySection.getKeys(false).isEmpty()) {
                config.set(this.getName(), null);
                return;
            }
            if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
                config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
            }
        }
    }

    @Override
    public boolean verify(Player player, Event event, StringPlaceholder sp) {
        if (this.mana.getValue(player.getUniqueId(), sp).isPresent() && this.mana.getValue(player.getUniqueId(), sp).get() > 0 && (SCore.hasAureliumSkills || SCore.hasMMOCore || Dependency.AURA_SKILLS.isInstalled())) {
            if (SCore.hasAureliumSkills) {
                if (!AureliumSkillsAPI.checkMana(player, this.mana.getValue(player.getUniqueId(), sp).get().intValue())) {
                    if (((Optional)this.errorMessage.getValue()).isPresent()) {
                        String message = (String)((Optional)this.errorMessage.getValue()).get();
                        message = sp.replacePlaceholder(message);
                        SendMessage.sendMessageNoPlch(player, message);
                    }
                    if (this.cancelEventIfError.getValue().booleanValue() && event instanceof Cancellable) {
                        ((Cancellable)event).setCancelled(true);
                    }
                    return false;
                }
            } else if (Dependency.AURA_SKILLS.isInstalled()) {
                if (!AuraSkillsAPI.checkMana(player, this.mana.getValue(player.getUniqueId(), sp).get().intValue())) {
                    if (((Optional)this.errorMessage.getValue()).isPresent()) {
                        SendMessage.sendMessageNoPlch(player, (String)((Optional)this.errorMessage.getValue()).get());
                    }
                    if (this.cancelEventIfError.getValue().booleanValue() && event instanceof Cancellable) {
                        ((Cancellable)event).setCancelled(true);
                    }
                    return false;
                }
            } else if (SCore.hasMMOCore && !MMOCoreAPI.checkMana(player, this.mana.getValue(player.getUniqueId(), sp).get().intValue())) {
                if (((Optional)this.errorMessage.getValue()).isPresent()) {
                    SendMessage.sendMessageNoPlch(player, (String)((Optional)this.errorMessage.getValue()).get());
                }
                if (this.cancelEventIfError.getValue().booleanValue() && event instanceof Cancellable) {
                    ((Cancellable)event).setCancelled(true);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void take(Player player, StringPlaceholder sp) {
        if (this.mana.getValue(player.getUniqueId(), sp).isPresent() && this.mana.getValue(player.getUniqueId(), sp).get() > 0 && (SCore.hasAureliumSkills || Dependency.AURA_SKILLS.isInstalled() || SCore.hasMMOCore)) {
            if (SCore.hasAureliumSkills) {
                AureliumSkillsAPI.takeMana(player, this.mana.getValue(player.getUniqueId(), sp).get().intValue());
            } else if (Dependency.AURA_SKILLS.isInstalled()) {
                AuraSkillsAPI.takeMana(player, this.mana.getValue(player.getUniqueId(), sp).get().intValue());
            } else if (SCore.hasMMOCore) {
                MMOCoreAPI.takeMana(player, this.mana.getValue(player.getUniqueId(), sp).get().intValue());
            }
        }
    }

    @Override
    public RequiredMana getValue() {
        return this;
    }

    @Override
    public RequiredMana initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oRequired mana: &e" + String.valueOf(((Optional)this.mana.getValue()).get());
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RequiredMana clone(FeatureParentInterface newParent) {
        RequiredMana requiredLevel = new RequiredMana(newParent);
        requiredLevel.setMana(this.mana.clone(requiredLevel));
        requiredLevel.setErrorMessage(this.errorMessage.clone(requiredLevel));
        requiredLevel.setCancelEventIfError(this.cancelEventIfError.clone(requiredLevel));
        return requiredLevel;
    }

    @Override
    public void reset() {
        this.mana = new IntegerFeature(this.getParent(), Optional.of(0), FeatureSettingsSCore.requiredMana);
        this.errorMessage = new ColoredStringFeature(this.getParent(), Optional.of("&4&l>> &cError you don't have the required mana"), FeatureSettingsSCore.errorMessage);
        this.cancelEventIfError = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.cancelEventIfError);
    }

    @Override
    public void openEditor(Player player) {
        if (!this.isPremium() && this.isRequirePremium()) {
            return;
        }
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return Arrays.asList(this.mana, this.errorMessage, this.cancelEventIfError);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo() + ".(requiredMana)";
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof RequiredMana)) continue;
            RequiredMana requiredLevel = (RequiredMana)feature;
            requiredLevel.setMana(this.mana);
            requiredLevel.setErrorMessage(this.errorMessage);
            requiredLevel.setCancelEventIfError(this.cancelEventIfError);
            break;
        }
    }

    @Generated
    public IntegerFeature getMana() {
        return this.mana;
    }

    @Generated
    public ColoredStringFeature getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public BooleanFeature getCancelEventIfError() {
        return this.cancelEventIfError;
    }

    @Generated
    public void setMana(IntegerFeature mana) {
        this.mana = mana;
    }

    @Generated
    public void setErrorMessage(ColoredStringFeature errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setCancelEventIfError(BooleanFeature cancelEventIfError) {
        this.cancelEventIfError = cancelEventIfError;
    }
}

