/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.required.money;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.required.RequiredPlayerInterface;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.VaultAPI;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class RequiredMoney
extends FeatureWithHisOwnEditor<RequiredMoney, RequiredMoney, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements RequiredPlayerInterface {
    private DoubleFeature money;
    private ColoredStringFeature errorMessage;
    private BooleanFeature cancelEventIfError;

    public RequiredMoney(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.requiredMoney);
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            if (!isPremiumLoading) {
                error.add("&cERROR, Couldn't load the Required Money value of " + this.getName() + " from config, &7&o" + this.getParent().getParentInfo() + " &6>> Because it's a premium feature !");
                return error;
            }
            this.money.load(plugin, section, isPremiumLoading);
            this.errorMessage.load(plugin, section, isPremiumLoading);
            this.cancelEventIfError.load(plugin, section, isPremiumLoading);
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (((Optional)this.money.getValue()).isPresent() && (Double)((Optional)this.money.getValue()).get() > 0.0) {
            ConfigurationSection requiredMoneySection = config.createSection(this.getName());
            this.money.save(requiredMoneySection);
            this.errorMessage.save(requiredMoneySection);
            this.cancelEventIfError.save(requiredMoneySection);
            if (this.isSavingOnlyIfDiffDefault() && requiredMoneySection.getKeys(false).isEmpty()) {
                config.set(this.getName(), null);
                return;
            }
            if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
                config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
            }
        }
    }

    @Override
    public boolean verify(Player player, Event event, StringPlaceholder sp) {
        VaultAPI v = new VaultAPI();
        if (this.money.getValue(player.getUniqueId(), sp).isPresent() && this.money.getValue(player.getUniqueId(), sp).get() > 0.0 && v.verifEconomy(player)) {
            String errMessage = "";
            if (((Optional)this.errorMessage.getValue()).isPresent()) {
                errMessage = (String)((Optional)this.errorMessage.getValue()).get();
                errMessage = sp.replacePlaceholder(errMessage);
            }
            if (!v.hasMoney(player, this.money.getValue(player.getUniqueId(), sp).get(), errMessage)) {
                if (this.cancelEventIfError.getValue().booleanValue() && event instanceof Cancellable) {
                    ((Cancellable)event).setCancelled(true);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void take(Player player, StringPlaceholder sp) {
        if (this.money.getValue(player.getUniqueId(), sp).isPresent() && this.money.getValue(player.getUniqueId(), sp).get() > 0.0) {
            VaultAPI v = new VaultAPI();
            v.takeMoney(player, this.money.getValue(player.getUniqueId(), sp).get());
        }
    }

    @Override
    public RequiredMoney getValue() {
        return this;
    }

    @Override
    public RequiredMoney initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oRequired money: &e" + String.valueOf(((Optional)this.money.getValue()).get());
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RequiredMoney clone(FeatureParentInterface newParent) {
        RequiredMoney requiredLevel = new RequiredMoney(newParent);
        requiredLevel.setMoney(this.money.clone(requiredLevel));
        requiredLevel.setErrorMessage(this.errorMessage.clone(requiredLevel));
        requiredLevel.setCancelEventIfError(this.cancelEventIfError.clone(requiredLevel));
        return requiredLevel;
    }

    @Override
    public void reset() {
        this.money = new DoubleFeature(this.getParent(), Optional.of(0.0), FeatureSettingsSCore.requiredMoney);
        this.errorMessage = new ColoredStringFeature(this.getParent(), Optional.of("&4&l>> &cError you don't have the required money"), FeatureSettingsSCore.errorMessage);
        this.cancelEventIfError = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.cancelEventIfError);
    }

    @Override
    public void openEditor(Player player) {
        if (!this.isPremium() && this.isRequirePremium()) {
            return;
        }
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return Arrays.asList(this.money, this.errorMessage, this.cancelEventIfError);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo() + ".(requiredMoney)";
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof RequiredMoney)) continue;
            RequiredMoney requiredLevel = (RequiredMoney)feature;
            requiredLevel.setMoney(this.money);
            requiredLevel.setErrorMessage(this.errorMessage);
            requiredLevel.setCancelEventIfError(this.cancelEventIfError);
            break;
        }
    }

    @Generated
    public DoubleFeature getMoney() {
        return this.money;
    }

    @Generated
    public ColoredStringFeature getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public BooleanFeature getCancelEventIfError() {
        return this.cancelEventIfError;
    }

    @Generated
    public void setMoney(DoubleFeature money) {
        this.money = money;
    }

    @Generated
    public void setErrorMessage(ColoredStringFeature errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setCancelEventIfError(BooleanFeature cancelEventIfError) {
        this.cancelEventIfError = cancelEventIfError;
    }
}

