/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.toolrules.group;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.toolrules.group.ToolRulesGroupFeatureEditor;
import com.ssomar.score.features.custom.toolrules.group.ToolRulesGroupFeatureEditorManager;
import com.ssomar.score.features.custom.toolrules.toolrule.ToolRuleFeature;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.jetbrains.annotations.NotNull;

public class ToolRulesGroupFeature
extends FeatureWithHisOwnEditor<ToolRulesGroupFeature, ToolRulesGroupFeature, ToolRulesGroupFeatureEditor, ToolRulesGroupFeatureEditorManager>
implements FeaturesGroup<ToolRuleFeature>,
FeatureForItem {
    private BooleanFeature enable;
    private Map<String, ToolRuleFeature> toolRules;
    private DoubleFeature defaultMiningSpeed;
    private IntegerFeature damagePerBlock;
    private boolean notSaveIfNoValue;
    private int premiumLimit = 5;

    public ToolRulesGroupFeature(FeatureParentInterface parent, boolean notSaveIfNoValue) {
        super(parent, FeatureSettingsSCore.toolRules);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    @Override
    public void reset() {
        this.enable = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.enable);
        this.toolRules = new LinkedHashMap<String, ToolRuleFeature>();
        this.defaultMiningSpeed = new DoubleFeature(this, Optional.of(1.0), FeatureSettingsSCore.defaultMiningSpeed);
        this.damagePerBlock = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.damagePerBlock);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                if (attributeID.equals(this.enable.getName()) || attributeID.equals(this.defaultMiningSpeed.getName()) || attributeID.equals(this.damagePerBlock.getName())) continue;
                if (this.toolRules.size() >= this.premiumLimit && !this.isPremium()) {
                    error.add("&cERROR, Couldn't load the Tool rule of " + attributeID + " from config, &7&o" + this.getParent().getParentInfo() + " &6>> Because it requires the premium version to have more than 2 tool rule !");
                    return error;
                }
                ToolRuleFeature attribute = new ToolRuleFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.toolRules.put(attributeID, attribute);
            }
            error.addAll(this.enable.load(plugin, enchantmentsSection, isPremiumLoading));
            error.addAll(this.defaultMiningSpeed.load(plugin, enchantmentsSection, isPremiumLoading));
            error.addAll(this.damagePerBlock.load(plugin, enchantmentsSection, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfNoValue && this.toolRules.size() == 0) {
            return;
        }
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.toolRules.keySet()) {
            this.toolRules.get(enchantmentID).save(attributesSection);
        }
        this.enable.save(attributesSection);
        this.defaultMiningSpeed.save(attributesSection);
        this.damagePerBlock.save(attributesSection);
    }

    @Override
    public ToolRulesGroupFeature getValue() {
        return this;
    }

    @Override
    public ToolRulesGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 5];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 5] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 4] = this.enable.getValue() != false ? "&7&oEnabled: &a&l\u2714" : "&7&oEnabled: &c&l\u2718";
        finalDescription[finalDescription.length - 3] = "&7&oTool rule(s) added: &e" + this.toolRules.size();
        finalDescription[finalDescription.length - 2] = "&7&oDefault Mining Speed: &e" + String.valueOf(((Optional)this.defaultMiningSpeed.getValue()).get());
        finalDescription[finalDescription.length - 1] = "&7&oDamage per block: &e" + String.valueOf(((Optional)this.damagePerBlock.getValue()).get());
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ToolRuleFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (ToolRuleFeature x : this.toolRules.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public ToolRulesGroupFeature clone(FeatureParentInterface newParent) {
        ToolRulesGroupFeature eF = new ToolRulesGroupFeature(newParent, this.isNotSaveIfNoValue());
        LinkedHashMap<String, ToolRuleFeature> newAttributes = new LinkedHashMap<String, ToolRuleFeature>();
        for (String x : this.toolRules.keySet()) {
            newAttributes.put(x, this.toolRules.get(x).clone(eF));
        }
        eF.setToolRules(newAttributes);
        eF.setEnable(this.enable.clone(newParent));
        eF.setDefaultMiningSpeed(this.defaultMiningSpeed.clone(newParent));
        eF.setDamagePerBlock(this.damagePerBlock.clone(newParent));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>(this.toolRules.values());
        features.add((ToolRuleFeature)((Object)this.enable));
        features.add((ToolRuleFeature)((Object)this.defaultMiningSpeed));
        features.add((ToolRuleFeature)((Object)this.damagePerBlock));
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ToolRulesGroupFeature)) continue;
            ToolRulesGroupFeature eF = (ToolRulesGroupFeature)feature;
            eF.setToolRules(this.getToolRules());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        ToolRulesGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        if (!this.isPremium() && this.toolRules.size() >= this.premiumLimit) {
            return;
        }
        String baseId = "toolRule";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.toolRules.containsKey(id)) continue;
            ToolRuleFeature eF = new ToolRuleFeature((FeatureParentInterface)this, id);
            this.toolRules.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, ToolRuleFeature feature) {
        this.toolRules.remove(feature.getId());
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20v5Plus();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return true;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        if (this.getEnable().getValue().booleanValue()) {
            ItemMeta meta = args.getMeta();
            ToolComponent tool = meta.getTool();
            tool.setDamagePerBlock(((Integer)((Optional)this.getDamagePerBlock().getValue()).get()).intValue());
            tool.setDefaultMiningSpeed(((Double)((Optional)this.getDefaultMiningSpeed().getValue()).get()).floatValue());
            for (ToolRuleFeature rule : this.getToolRules().values()) {
                float miningSpeed = ((Double)((Optional)rule.getMiningSpeed().getValue()).get()).floatValue();
                boolean correctForDrops = rule.getCorrectForDrops().getValue();
                List<Tag<Material>> tags = rule.getMaterials().asTagList();
                for (Tag<Material> tag : tags) {
                    tool.addRule(tag, Float.valueOf(miningSpeed), Boolean.valueOf(correctForDrops));
                }
                tool.addRule(rule.getMaterials().asMaterialList(), Float.valueOf(((Double)((Optional)rule.getMiningSpeed().getValue()).get()).floatValue()), rule.getCorrectForDrops().getValue());
            }
            meta.setTool(tool);
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        ItemMeta meta = args.getMeta();
        ToolComponent tool = meta.getTool();
        if (tool != null) {
            this.getDamagePerBlock().setValue(Optional.of(tool.getDamagePerBlock()));
            this.getDefaultMiningSpeed().setValue(Optional.of(Double.valueOf(tool.getDefaultMiningSpeed())));
            int i = 0;
            for (ToolComponent.ToolRule toolRule : tool.getRules()) {
                ToolRuleFeature rule = new ToolRuleFeature((FeatureParentInterface)this, "toolRule" + i);
                Collection materials = toolRule.getBlocks();
                ArrayList<String> materialNames = new ArrayList<String>();
                for (Material material : materials) {
                    materialNames.add(material.toString());
                }
                rule.getMaterials().setValues(materialNames);
                if (toolRule.getSpeed() != null) {
                    rule.getMiningSpeed().setValue(Optional.of(Double.valueOf(toolRule.getSpeed().floatValue())));
                }
                if (toolRule.isCorrectForDrops() != null) {
                    rule.getCorrectForDrops().setValue(toolRule.isCorrectForDrops());
                }
                this.toolRules.put(rule.getId(), rule);
                ++i;
            }
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.TOOL_RULES;
    }

    @Generated
    public BooleanFeature getEnable() {
        return this.enable;
    }

    @Generated
    public Map<String, ToolRuleFeature> getToolRules() {
        return this.toolRules;
    }

    @Generated
    public DoubleFeature getDefaultMiningSpeed() {
        return this.defaultMiningSpeed;
    }

    @Generated
    public IntegerFeature getDamagePerBlock() {
        return this.damagePerBlock;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public int getPremiumLimit() {
        return this.premiumLimit;
    }

    @Generated
    public void setEnable(BooleanFeature enable) {
        this.enable = enable;
    }

    @Generated
    public void setToolRules(Map<String, ToolRuleFeature> toolRules) {
        this.toolRules = toolRules;
    }

    @Generated
    public void setDefaultMiningSpeed(DoubleFeature defaultMiningSpeed) {
        this.defaultMiningSpeed = defaultMiningSpeed;
    }

    @Generated
    public void setDamagePerBlock(IntegerFeature damagePerBlock) {
        this.damagePerBlock = damagePerBlock;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }

    @Generated
    public void setPremiumLimit(int premiumLimit) {
        this.premiumLimit = premiumLimit;
    }
}

