/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.usage;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.usage.useperday.UsePerDayFeature;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class UsageFeatures
extends FeatureWithHisOwnEditor<UsageFeatures, UsageFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private IntegerFeature usage;
    private BooleanFeature isRefreshableClean;
    private IntegerFeature usageLimit;
    private UsePerDayFeature usePerDay;
    private String objectId;

    public UsageFeatures(FeatureParentInterface parent, String objectId) {
        super(parent, FeatureSettingsSCore.usageFeatures);
        this.objectId = objectId;
        this.reset();
    }

    @Override
    public void reset() {
        this.usage = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.usage);
        this.isRefreshableClean = new BooleanFeature(this, true, FeatureSettingsSCore.isRefreshableClean);
        this.usageLimit = new IntegerFeature(this, Optional.of(-1), FeatureSettingsSCore.usageLimit);
        this.usePerDay = new UsePerDayFeature((FeatureParentInterface)this, this.getObjectId());
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            error.addAll(this.usage.load(plugin, section, isPremiumLoading));
            error.addAll(this.isRefreshableClean.load(plugin, section, isPremiumLoading));
            error.addAll(this.usageLimit.load(plugin, section, isPremiumLoading));
            error.addAll(this.usePerDay.load(plugin, section, isPremiumLoading));
        } else {
            error.addAll(this.usage.load(plugin, config, isPremiumLoading));
            error.addAll(this.isRefreshableClean.load(plugin, config, isPremiumLoading));
            error.addAll(this.usageLimit.load(plugin, config, isPremiumLoading));
            error.addAll(this.usePerDay.load(plugin, config, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.usage.save(section);
        this.isRefreshableClean.save(section);
        this.usageLimit.save(section);
        this.usePerDay.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public UsageFeatures getValue() {
        return this;
    }

    @Override
    public UsageFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 5];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 5] = this.isRequirePremium() && !this.isPremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 4] = "&7Usage: &e" + String.valueOf(((Optional)this.usage.getValue()).orElse(0));
        finalDescription[finalDescription.length - 3] = "&7Is Refreshable Clean: &e" + this.isRefreshableClean.getValue();
        finalDescription[finalDescription.length - 2] = "&7Usage Limit: &e" + String.valueOf(((Optional)this.usageLimit.getValue()).orElse(-1));
        finalDescription[finalDescription.length - 1] = "&7Use Per Day: &e" + String.valueOf(((Optional)this.usePerDay.getValue().getMaxUsePerDay().getValue()).orElse(-1));
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public UsageFeatures clone(FeatureParentInterface newParent) {
        UsageFeatures dropFeatures = new UsageFeatures(newParent, this.objectId);
        dropFeatures.setUsage(this.usage.clone(dropFeatures));
        dropFeatures.setIsRefreshableClean(this.isRefreshableClean.clone(dropFeatures));
        dropFeatures.setUsageLimit(this.usageLimit.clone(dropFeatures));
        dropFeatures.setUsePerDay(this.usePerDay.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.usage);
        features.add(this.isRefreshableClean);
        features.add(this.usageLimit);
        features.add(this.usePerDay);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof UsageFeatures)) continue;
            UsageFeatures dropFeatures = (UsageFeatures)feature;
            dropFeatures.setUsage(this.usage);
            dropFeatures.setIsRefreshableClean(this.isRefreshableClean);
            dropFeatures.setUsageLimit(this.usageLimit);
            dropFeatures.setUsePerDay(this.usePerDay);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public IntegerFeature getUsage() {
        return this.usage;
    }

    @Generated
    public BooleanFeature getIsRefreshableClean() {
        return this.isRefreshableClean;
    }

    @Generated
    public IntegerFeature getUsageLimit() {
        return this.usageLimit;
    }

    @Generated
    public UsePerDayFeature getUsePerDay() {
        return this.usePerDay;
    }

    @Generated
    public String getObjectId() {
        return this.objectId;
    }

    @Generated
    public void setUsage(IntegerFeature usage) {
        this.usage = usage;
    }

    @Generated
    public void setIsRefreshableClean(BooleanFeature isRefreshableClean) {
        this.isRefreshableClean = isRefreshableClean;
    }

    @Generated
    public void setUsageLimit(IntegerFeature usageLimit) {
        this.usageLimit = usageLimit;
    }

    @Generated
    public void setUsePerDay(UsePerDayFeature usePerDay) {
        this.usePerDay = usePerDay;
    }

    @Generated
    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }
}

