/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class ArrayFeature<X>
extends FeatureAbstract<X[], ArrayFeature<X>> {
    private X[] value;
    private int maxArraySize;

    public ArrayFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, int maxArraySize) {
        super(parent, featureSettings);
        this.maxArraySize = maxArraySize;
        this.reset();
    }

    public static ArrayFeature buildNull() {
        return new ArrayFeature(null, null, 100);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        List valueStr = config.getList(this.getName());
        if (valueStr != null) {
            this.value = new Object[valueStr.size()];
            for (int i = 0; i < valueStr.size(); ++i) {
                this.value[i] = valueStr.get(i);
            }
        } else {
            errors.add("&cThe feature " + this.getName() + " is not a list of object");
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        ArrayList<X> valueStr = new ArrayList<X>();
        valueStr.addAll(Arrays.asList(this.value));
        config.set(this.getName(), valueStr);
    }

    @Override
    public X[] getValue() {
        return this.value;
    }

    public X getArrayValueAtIndex(int index) {
        return this.value[index];
    }

    @Override
    public ArrayFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ArrayFeature clone(FeatureParentInterface newParent) {
        ArrayFeature<X> clone = new ArrayFeature<X>(newParent, this.getFeatureSettings(), this.getMaxArraySize());
        clone.setValue(this.value);
        return clone;
    }

    @Override
    public void reset() {
        this.value = new Object[100];
    }

    @Generated
    public int getMaxArraySize() {
        return this.maxArraySize;
    }

    @Generated
    public void setValue(X[] value) {
        this.value = value;
    }

    @Generated
    public void setMaxArraySize(int maxArraySize) {
        this.maxArraySize = maxArraySize;
    }
}

