/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class BlockFaceFeature
extends FeatureAbstract<Optional<BlockFace>, BlockFaceFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<BlockFace> value;
    private Optional<BlockFace> defaultValue;
    private Set<BlockFace> whitelist;

    public BlockFaceFeature(FeatureParentInterface parent, Optional<BlockFace> defaultValue, @Nullable Set<BlockFace> whitelist, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
        this.whitelist = whitelist;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            this.value = this.defaultValue;
        } else {
            try {
                BlockFace blockFace = BlockFace.valueOf((String)colorStr.toUpperCase());
                if (this.whitelist != null && !this.whitelist.contains(blockFace)) {
                    errors.add("&cERROR, the BlockFace value of " + this.getName() + " from config is not in the whitelist, value: " + colorStr + " &7&o" + this.getParent().getParentInfo());
                    return errors;
                }
                this.value = Optional.of(blockFace);
                FeatureReturnCheckPremium<BlockFace> checkPremium = this.checkPremium("BlockFace", blockFace, this.defaultValue, isPremiumLoading);
                if (checkPremium.isHasError()) {
                    this.value = Optional.of(checkPremium.getNewValue());
                }
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the BlockFace value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> List: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/block/BlockFace.html");
                this.value = Optional.empty();
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(potionType -> config.set(this.getName(), (Object)potionType.name()));
    }

    @Override
    public Optional<BlockFace> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public BlockFaceFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        BlockFace finalValue = ((Optional)value).orElse(BlockFace.NORTH);
        this.updateBlockFace(finalValue, gui);
    }

    @Override
    public BlockFaceFeature clone(FeatureParentInterface newParent) {
        BlockFaceFeature clone = new BlockFaceFeature(newParent, this.getDefaultValue(), this.getWhitelist(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        BlockFace slot = this.getBlockFace((GUI)manager.getCache().get(editor));
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        slot = this.nextBlockFace(slot);
        this.updateBlockFace(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        BlockFace slot = this.getBlockFace((GUI)manager.getCache().get(editor));
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        slot = this.prevBlockFace(slot);
        this.updateBlockFace(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateBlockFace(this.nextBlockFace(this.getBlockFace((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateBlockFace(this.prevBlockFace(this.getBlockFace((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public BlockFace nextBlockFace(BlockFace slot) {
        boolean next = false;
        for (BlockFace check : this.getSortBlockFace()) {
            if (check.equals((Object)slot)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortBlockFace().get(0);
    }

    public BlockFace prevBlockFace(BlockFace slot) {
        int i = -1;
        int cpt = 0;
        for (BlockFace check : this.getSortBlockFace()) {
            if (check.equals((Object)slot)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortBlockFace().get(this.getSortBlockFace().size() - 1);
        }
        return this.getSortBlockFace().get(cpt - 1);
    }

    public void updateBlockFace(BlockFace slot, GUI gui) {
        this.value = Optional.of(slot);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortBlockFace().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (BlockFace check : this.getSortBlockFace()) {
            if (slot.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + slot.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (BlockFace check : this.getSortBlockFace()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public BlockFace getBlockFace(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return BlockFace.valueOf((String)str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<BlockFace> getSortBlockFace() {
        TreeMap<String, BlockFace> map = new TreeMap<String, BlockFace>();
        for (BlockFace l : BlockFace.values()) {
            if (this.whitelist != null && !this.whitelist.contains(l)) continue;
            map.put(l.name(), l);
        }
        return new ArrayList<BlockFace>(map.values());
    }

    @Generated
    public Optional<BlockFace> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Set<BlockFace> getWhitelist() {
        return this.whitelist;
    }

    @Generated
    public void setValue(Optional<BlockFace> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<BlockFace> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setWhitelist(Set<BlockFace> whitelist) {
        this.whitelist = whitelist;
    }
}

