/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class ItemStackFeature
extends FeatureAbstract<Optional<ItemStack>, ItemStackFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<ItemStack> value;
    private Optional<ItemStack> defaultValue;
    private Optional<String> placeholder;
    private FeatureSettingsInterface featureDoubleClickOpener;
    private String featureDoubleClickOpenerEditorMessage = "";

    public ItemStackFeature(FeatureParentInterface parent, Optional<ItemStack> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.reset();
    }

    public static ItemStackFeature buildNull() {
        return new ItemStackFeature(null, Optional.empty(), null);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String valueStr = config.getString(this.getName(), "NULL");
        if (valueStr.equals("NULL")) {
            this.value = this.defaultValue;
            return errors;
        }
        if (valueStr.contains("%")) {
            this.placeholder = Optional.of(valueStr);
            this.value = Optional.empty();
        } else {
            this.placeholder = Optional.empty();
            int amount = 1;
            try {
                if (valueStr.contains(">>amount:")) {
                    String[] split = valueStr.split(">>amount:");
                    valueStr = split[0];
                    if (split.length > 1) {
                        try {
                            amount = Integer.parseInt(split[1]);
                        }
                        catch (Exception e) {
                            errors.add("&cERROR, Couldn't load the ItemStack value of " + this.getName() + " from config, value: " + valueStr + " (Invalid amount) &7&o" + this.getParent().getParentInfo());
                        }
                    }
                }
                ItemStack item = Bukkit.getServer().getItemFactory().createItemStack(valueStr);
                item.setAmount(amount);
                this.value = Optional.of(item);
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the ItemStack value of " + this.getName() + " from config, value: " + valueStr + " &7&o" + this.getParent().getParentInfo());
                this.value = this.defaultValue;
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (this.placeholder.isPresent()) {
            config.set(this.getName(), (Object)this.placeholder.get());
        } else if (((Optional)this.getValue()).isPresent()) {
            if (this.defaultValue.isPresent() && this.isSavingOnlyIfDiffDefault() && this.value.get().equals((Object)this.defaultValue.get())) {
                config.set(this.getName(), null);
                return;
            }
            ItemStack item = (ItemStack)((Optional)this.getValue()).get();
            Object valStr = this.itemStackToString(item);
            if (item.getAmount() != 1) {
                valStr = (String)valStr + ">>amount:" + item.getAmount();
            }
            config.set(this.getName(), valStr);
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    public String itemStackToString(ItemStack item) {
        Object valStr = "";
        if (SCore.is1v20v6Plus()) {
            String itemTypeKey = item.getType().getKey().toString();
            String components = item.getItemMeta().getAsComponentString();
            String itemAsString = itemTypeKey + components;
            valStr = itemAsString;
        } else {
            valStr = item.hasItemMeta() ? "minecraft:" + item.getType().toString().toLowerCase() + item.getItemMeta().getAsString() : "minecraft:" + item.getType().toString().toLowerCase();
        }
        return valStr;
    }

    public Optional<ItemStack> getValue(@Nullable UUID playerUUID, @Nullable StringPlaceholder sp) {
        if (this.placeholder.isPresent()) {
            String placeholderStr = this.placeholder.get();
            if (sp != null) {
                placeholderStr = sp.replacePlaceholder(placeholderStr);
            }
            placeholderStr = StringPlaceholder.replacePlaceholderOfPAPI(placeholderStr, playerUUID);
            try {
                ItemStack item = Bukkit.getServer().getItemFactory().createItemStack(placeholderStr);
                return Optional.of(item);
            }
            catch (Exception exception) {}
        } else if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Nullable
    public ItemStack getItemsStack(@Nullable UUID playerUUID, @Nullable StringPlaceholder sp) {
        ItemStack item = this.getValue(playerUUID, sp).orElse(null);
        if (item != null) {
            return item.clone();
        }
        return null;
    }

    @Nullable
    public ItemStack getItemsStack() {
        ItemStack item = ((Optional)this.getValue()).orElse(null);
        if (item != null) {
            return item.clone();
        }
        return null;
    }

    @Override
    public Optional<ItemStack> getValue() {
        if (this.value.isPresent()) {
            return Optional.of(this.value.get().clone());
        }
        if (this.placeholder.isPresent()) {
            String placeholderStr = this.placeholder.get();
            placeholderStr = new StringPlaceholder().replacePlaceholderOfPAPI(placeholderStr);
            try {
                ItemStack item = Bukkit.getServer().getItemFactory().createItemStack(placeholderStr);
                return Optional.of(item);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultValue;
    }

    @Override
    public ItemStackFeature initItemParentEditor(GUI gui, int slot) {
        List lore;
        ArrayList<String> customDescription = new ArrayList<String>();
        customDescription.add("&7&o======== EC EDITOR ========");
        customDescription.addAll(Arrays.asList(this.getEditorDescription()));
        if (!this.isPremium() && this.isRequirePremium()) {
            customDescription.add(GUI.PREMIUM);
        } else {
            customDescription.add("&8>> &6LEFT CLICK: &eSET ITEM");
            customDescription.add("&8>> &6RIGHT CLICK: &eREMOVE ITEM");
            customDescription.add("&8>> &6SHIFT + LEFT CLICK: &eIncrement (+1)");
            customDescription.add("&8>> &6SHIFT + RIGHT CLICK: &eDecrement (-1)");
            customDescription.add("&8>> &6MIDDLE CLICK: &eGIVE ITEM");
            if (!this.getFeatureDoubleClickOpenerEditorMessage().isEmpty()) {
                customDescription.add(this.featureDoubleClickOpenerEditorMessage);
            }
        }
        customDescription.add(TM.g(Text.EDITOR_CURRENTLY_NAME));
        customDescription.add("&7&o======== EC EDITOR ========");
        customDescription.replaceAll(StringConverter::coloredString);
        Object value = this.getValue();
        ItemStack item = ((Optional)value).orElseGet(() -> new ItemStack(Material.BARRIER));
        ItemMeta meta = item.getItemMeta();
        List list = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        assert (lore != null);
        if (lore.stream().anyMatch(line -> line.contains("EC EDITOR"))) {
            gui.updateItem(slot, item, this.getEditorName());
            return this;
        }
        lore.addAll(0, customDescription);
        meta.setLore(lore);
        item.setItemMeta(meta);
        gui.updateItem(slot, item, this.getEditorName());
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        if (this.placeholder.isPresent()) {
            gui.updateCurrently(this.getEditorName(), this.placeholder.get());
        } else if (this.value.isPresent()) {
            gui.updateCurrently(this.getEditorName(), "&6&oItem set");
        } else {
            gui.updateCurrently(this.getEditorName(), "&c&oNo item set");
        }
    }

    @Override
    public ItemStackFeature clone(FeatureParentInterface newParent) {
        ItemStackFeature clone = new ItemStackFeature(newParent, this.defaultValue, this.getFeatureSettings());
        clone.setFeatureDoubleClickOpener(this.featureDoubleClickOpener);
        clone.setFeatureDoubleClickOpenerEditorMessage(this.featureDoubleClickOpenerEditorMessage);
        clone.setValue(this.value);
        clone.setPlaceholder(this.getPlaceholder());
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
        this.placeholder = Optional.empty();
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        ItemStack stack = editor.getItemOnCursor().clone();
        if (stack.getType().isAir()) {
            editor.sendMessage(StringConverter.coloredString("&cYou must have an item in your hand to set it as the value"));
        } else {
            ((GUI)manager.getCache().get(editor)).updateCurrently(this.getEditorName(), this.itemStackToString(stack));
            this.value = Optional.of(stack);
            this.placeholder = Optional.empty();
        }
        return true;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        ((GUI)manager.getCache().get(editor)).updateCurrently(this.getEditorName(), "&c&oNo item set");
        this.value = Optional.empty();
        this.placeholder = Optional.empty();
        return true;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        if (this.value.isPresent()) {
            ItemStack stack = this.value.get().clone();
            stack.setAmount(stack.getAmount() + 1);
            ((GUI)manager.getCache().get(editor)).updateCurrently(this.getEditorName(), this.itemStackToString(stack));
            this.value = Optional.of(stack);
            this.placeholder = Optional.empty();
        }
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        if (this.value.isPresent()) {
            ItemStack stack = this.value.get().clone();
            int amount = stack.getAmount();
            stack.setAmount(stack.getAmount() - 1);
            if (amount != 1) {
                ((GUI)manager.getCache().get(editor)).updateCurrently(this.getEditorName(), this.itemStackToString(stack));
                this.value = Optional.of(stack);
                this.placeholder = Optional.empty();
            }
        }
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        if (this.featureDoubleClickOpener != null) {
            for (FeatureInterface feature : this.getParent().getFeatures()) {
                if (feature.getFeatureSettings() != this.featureDoubleClickOpener || !(feature instanceof FeatureParentInterface)) continue;
                FeatureParentInterface featureParent = (FeatureParentInterface)feature;
                this.getParent().reload();
                this.getParent().save();
                featureParent.openEditor(editor);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        ItemStack configuredItem;
        if (editor.getGameMode() != GameMode.CREATIVE && editor.getItemOnCursor().getType() != Material.AIR) {
            return false;
        }
        Object configuredItemOptional = this.getValue();
        if (((Optional)configuredItemOptional).isPresent() && (configuredItem = (ItemStack)((Optional)configuredItemOptional).get()).getType() != Material.AIR) {
            ItemStack itemToPlaceOnCursor = configuredItem.clone();
            editor.setItemOnCursor(itemToPlaceOnCursor);
            return true;
        }
        return false;
    }

    @Generated
    public Optional<ItemStack> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Optional<String> getPlaceholder() {
        return this.placeholder;
    }

    @Generated
    public FeatureSettingsInterface getFeatureDoubleClickOpener() {
        return this.featureDoubleClickOpener;
    }

    @Generated
    public String getFeatureDoubleClickOpenerEditorMessage() {
        return this.featureDoubleClickOpenerEditorMessage;
    }

    @Generated
    public void setValue(Optional<ItemStack> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<ItemStack> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setPlaceholder(Optional<String> placeholder) {
        this.placeholder = placeholder;
    }

    @Generated
    public void setFeatureDoubleClickOpener(FeatureSettingsInterface featureDoubleClickOpener) {
        this.featureDoubleClickOpener = featureDoubleClickOpener;
    }

    @Generated
    public void setFeatureDoubleClickOpenerEditorMessage(String featureDoubleClickOpenerEditorMessage) {
        this.featureDoubleClickOpenerEditorMessage = featureDoubleClickOpenerEditorMessage;
    }
}

