/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SOptionFeature
extends FeatureAbstract<SOption, SOptionFeature>
implements FeatureRequireOnlyClicksInEditor {
    private SOption value;
    private SPlugin plugin;
    private SOption builderInstance;

    public SOptionFeature(SPlugin sPlugin, SOption builderInstance, FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.plugin = sPlugin;
        this.builderInstance = builderInstance;
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        try {
            SOption option = this.builderInstance.getOption(colorStr);
            if (option == null) {
                errors.add("&cERROR, Couldn't load the Option value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Options available: https://docs.ssomar.com/");
                option = this.builderInstance.getDefaultValue();
            }
            this.value = option;
            if (!isPremiumLoading && this.builderInstance.getPremiumOption().contains(option)) {
                errors.add("&cERROR, Couldn't load the Option value of " + this.getName() + " from config, value: " + String.valueOf(this.value) + " &7&o" + this.getParent().getParentInfo() + " &6>> Because it's a premium Option !");
                this.value = this.builderInstance.getDefaultValue();
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the Option value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Options available: https://docs.ssomar.com/");
            this.value = this.builderInstance.getDefaultValue();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), (Object)this.value.toString());
    }

    @Override
    public SOption getValue() {
        return this.value;
    }

    @Override
    public SOptionFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = "&8>> &6SHIFT : &eBOOST SCROLL";
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        this.updateOption(this.getValue(), gui, !this.getPlugin().isLotOfWork(), true);
    }

    @Override
    public SOptionFeature clone(FeatureParentInterface newParent) {
        SOptionFeature clone = new SOptionFeature(this.plugin, this.builderInstance, newParent, this.getFeatureSettings());
        clone.setValue(this.value);
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.builderInstance.getDefaultValue();
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        SOption option = this.getOption((GUI)manager.getCache().get(editor));
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        option = this.nextOption(option);
        this.updateOption(option, (GUI)manager.getCache().get(editor), !this.getPlugin().isLotOfWork(), true);
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        SOption option = this.getOption((GUI)manager.getCache().get(editor));
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        option = this.prevOption(option);
        this.updateOption(option, (GUI)manager.getCache().get(editor), !this.getPlugin().isLotOfWork(), false);
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateOption(this.nextOption(this.getOption((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor), !this.getPlugin().isLotOfWork(), true);
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateOption(this.prevOption(this.getOption((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor), !this.getPlugin().isLotOfWork(), false);
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public SOption nextOption(SOption option) {
        boolean next = false;
        for (SOption check : this.getSortOptions()) {
            if (check.equals(option)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortOptions().get(0);
    }

    public SOption prevOption(SOption option) {
        int i = -1;
        int cpt = 0;
        for (SOption check : this.getSortOptions()) {
            if (check.equals(option)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortOptions().get(this.getSortOptions().size() - 1);
        }
        return this.getSortOptions().get(cpt - 1);
    }

    public void updateOption(SOption option, GUI gui, boolean isPremiumLoading, boolean next) {
        SsomarDev.testMsg("updateOption  " + String.valueOf(option) + " >>" + this.builderInstance.getPremiumOption().contains(option), true);
        while (!isPremiumLoading && this.builderInstance.getPremiumOption().contains(option)) {
            if (next) {
                option = this.nextOption(option);
                continue;
            }
            option = this.prevOption(option);
        }
        this.value = option;
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 3);
        boolean find = false;
        for (SOption check : this.getSortOptions()) {
            if (option.equals(check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + String.valueOf(option)));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            if (!isPremiumLoading && this.builderInstance.getPremiumOption().contains(check)) {
                lore.add(StringConverter.coloredString("&6\u2726 &e" + String.valueOf(check) + " &7Premium"));
                continue;
            }
            lore.add(StringConverter.coloredString("&6\u2726 &e" + String.valueOf(check)));
        }
        for (SOption check : this.getSortOptions()) {
            if (lore.size() == 17) break;
            if (!isPremiumLoading && this.builderInstance.getPremiumOption().contains(check)) {
                lore.add(StringConverter.coloredString("&6\u2726 &e" + String.valueOf(check) + " &7Premium"));
                continue;
            }
            lore.add(StringConverter.coloredString("&6\u2726 &e" + String.valueOf(check)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public SOption getOption(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return this.builderInstance.getOption(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<SOption> getSortOptions() {
        TreeMap<String, SOption> map = new TreeMap<String, SOption>();
        for (SOption l : this.builderInstance.getValues()) {
            map.put(l.toString(), l);
        }
        return new ArrayList<SOption>(map.values());
    }

    @Generated
    public SPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public SOption getBuilderInstance() {
        return this.builderInstance;
    }

    @Generated
    public void setValue(SOption value) {
        this.value = value;
    }

    @Generated
    public void setPlugin(SPlugin plugin) {
        this.plugin = plugin;
    }

    @Generated
    public void setBuilderInstance(SOption builderInstance) {
        this.builderInstance = builderInstance;
    }
}

