/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireClicksOrOneMessageInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.TrimMaterial;

public class TrimMaterialFeature
extends FeatureAbstract<Optional<TrimMaterial>, TrimMaterialFeature>
implements FeatureRequireClicksOrOneMessageInEditor {
    private Optional<TrimMaterial> value;
    private Optional<TrimMaterial> defaultValue;

    public TrimMaterialFeature(FeatureParentInterface parent, Optional<TrimMaterial> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        try {
            TrimMaterial material = this.getTrimMaterial(colorStr);
            this.value = Optional.ofNullable(material);
            FeatureReturnCheckPremium<TrimMaterial> checkPremium = this.checkPremium("TrimMaterial", material, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            if (!colorStr.equals("NULL")) {
                errors.add("&cERROR, Couldn't load the TrimMaterial value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> TrimMaterials available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/inventory/meta/trim/TrimMaterial.html");
            }
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(material -> {
            String fix = material.getKey().toString();
            if (fix.contains("minecraft:")) {
                fix = fix.replace("minecraft:", "");
                fix = fix.toUpperCase();
            }
            config.set(this.getName(), (Object)fix);
        });
    }

    @Override
    public Optional<TrimMaterial> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public TrimMaterialFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = "&8>> &6SHIFT : &eBOOST SCROLL";
        finalDescription[finalDescription.length - 2] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        finalDescription[finalDescription.length - 1] = "&8>> &6Type manually: &eMIDDLE &a(Creative only)";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        TrimMaterial finalValue = ((Optional)value).orElse(TrimMaterial.DIAMOND);
        this.updateMaterial(finalValue, gui);
    }

    @Override
    public TrimMaterialFeature clone(FeatureParentInterface newParent) {
        TrimMaterialFeature clone = new TrimMaterialFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        TrimMaterial material = this.getMaterial((GUI)manager.getCache().get(editor));
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        this.updateMaterial(material, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        TrimMaterial material = this.getMaterial((GUI)manager.getCache().get(editor));
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        this.updateMaterial(material, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateMaterial(this.nextMaterial(this.getMaterial((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateMaterial(this.prevMaterial(this.getMaterial((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public TrimMaterial nextMaterial(TrimMaterial material) {
        boolean next = false;
        for (TrimMaterial check : this.getSortMaterials()) {
            if (check.equals((Object)material)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortMaterials().get(0);
    }

    public TrimMaterial prevMaterial(TrimMaterial material) {
        int i = -1;
        int cpt = 0;
        for (TrimMaterial check : this.getSortMaterials()) {
            if (check.equals((Object)material)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        TrimMaterial finalMaterial = i == 0 ? this.getSortMaterials().get(this.getSortMaterials().size() - 1) : this.getSortMaterials().get(cpt - 1);
        return finalMaterial;
    }

    public void updateMaterial(TrimMaterial material, GUI gui) {
        Material mat = this.getConverter().get(material);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        this.value = Optional.of(material);
        item.setType(mat);
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 4);
        boolean find = false;
        for (TrimMaterial check : this.getSortMaterials()) {
            if (material.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + this.getStringValue(material)));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + this.getStringValue(check)));
        }
        for (TrimMaterial check : this.getSortMaterials()) {
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + this.getStringValue(check)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public TrimMaterial getMaterial(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return this.getTrimMaterial(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<TrimMaterial> getSortMaterials() {
        TreeMap<String, TrimMaterial> map = new TreeMap<String, TrimMaterial>();
        for (TrimMaterial l : Registry.TRIM_MATERIAL) {
            map.put(l.getKey().getKey(), l);
        }
        return new ArrayList<TrimMaterial>(map.values());
    }

    @Override
    public void askInEditor(final Player editor, NewGUIManager manager) {
        manager.requestWriting.put(editor, this.getEditorName());
        Runnable runnable = new Runnable(){
            final /* synthetic */ TrimMaterialFeature this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                editor.closeInventory();
            }
        };
        SCore.schedulerHook.runEntityTaskAsap(runnable, null, (Entity)editor);
        TrimMaterialFeature.space(editor);
        TextComponent message = new TextComponent(StringConverter.coloredString("&a&l[Editor] &aEnter the material or &aedit &athe &aactual: "));
        TextComponent edit = new TextComponent(StringConverter.coloredString("&e&l[EDIT]"));
        edit.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, StringConverter.deconvertColor(((GUI)manager.getCache().get(editor)).getCurrently(this.getEditorName()))));
        edit.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&eClick here to edit the current material")).create()));
        TextComponent newName = new TextComponent(StringConverter.coloredString("&a&l[NEW]"));
        newName.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "Type the new string here.."));
        newName.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick here to set new material")).create()));
        TextComponent noValue = new TextComponent(StringConverter.coloredString("&c&l[NO VALUE / EXIT]"));
        noValue.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/score interact NO VALUE / EXIT"));
        noValue.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&cClick here to exit or don't set a value")).create()));
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)edit);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)newName);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)noValue);
        editor.spigot().sendMessage((BaseComponent)message);
        TrimMaterialFeature.space(editor);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        try {
            Material.valueOf((String)StringConverter.decoloredString(message).trim().toUpperCase());
        }
        catch (Exception e) {
            return Optional.of(StringConverter.coloredString("&4&l[ERROR] &cThe message you entered is not a material"));
        }
        return Optional.empty();
    }

    @Override
    public void finishEditInEditor(Player editor, NewGUIManager manager, String message) {
        this.value = Optional.of(this.getTrimMaterial(StringConverter.decoloredString(message).trim().toUpperCase()));
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void finishEditInEditorNoValue(Player editor, NewGUIManager manager) {
        this.value = Optional.empty();
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    public Map<TrimMaterial, Material> getConverter() {
        HashMap<TrimMaterial, Material> map = new HashMap<TrimMaterial, Material>();
        map.put(TrimMaterial.DIAMOND, Material.DIAMOND);
        map.put(TrimMaterial.AMETHYST, Material.AMETHYST_SHARD);
        map.put(TrimMaterial.COPPER, Material.COPPER_INGOT);
        map.put(TrimMaterial.GOLD, Material.GOLD_INGOT);
        map.put(TrimMaterial.IRON, Material.IRON_INGOT);
        map.put(TrimMaterial.EMERALD, Material.EMERALD);
        map.put(TrimMaterial.LAPIS, Material.LAPIS_LAZULI);
        map.put(TrimMaterial.NETHERITE, Material.NETHERITE_INGOT);
        map.put(TrimMaterial.QUARTZ, Material.QUARTZ);
        map.put(TrimMaterial.REDSTONE, Material.REDSTONE);
        for (TrimMaterial mat : Registry.TRIM_MATERIAL) {
            if (map.containsKey(mat)) continue;
            map.put(mat, Material.BARRIER);
        }
        return map;
    }

    public TrimMaterial getTrimMaterial(String str) {
        Object fix = StringConverter.decoloredString(str);
        if (!((String)fix).contains(":")) {
            fix = "minecraft:" + (String)fix;
            fix = ((String)fix).toLowerCase();
        }
        TrimMaterial material = (TrimMaterial)Registry.TRIM_MATERIAL.get(NamespacedKey.fromString((String)fix));
        return material;
    }

    public String getStringValue(TrimMaterial material) {
        String fix = material.getKey().toString();
        if (fix.contains("minecraft:")) {
            fix = fix.replace("minecraft:", "");
            fix = fix.toUpperCase();
        }
        return fix;
    }

    @Generated
    public Optional<TrimMaterial> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<TrimMaterial> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<TrimMaterial> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

