/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import com.ssomar.score.variables.VariableForEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class VariableForFeature
extends FeatureAbstract<Optional<VariableForEnum>, VariableForFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<VariableForEnum> value;
    private Optional<VariableForEnum> defaultValue;

    public VariableForFeature(FeatureParentInterface parent, Optional<VariableForEnum> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            this.value = this.defaultValue;
        } else {
            try {
                VariableForEnum material = VariableForEnum.valueOf(colorStr);
                this.value = Optional.ofNullable(material);
                FeatureReturnCheckPremium<VariableForEnum> checkPremium = this.checkPremium("Variable For", material, this.defaultValue, isPremiumLoading);
                if (checkPremium.isHasError()) {
                    this.value = Optional.of(checkPremium.getNewValue());
                }
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the VariableFor value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> VariableType available: STRING, NUMBER");
                this.value = Optional.empty();
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(variableType -> config.set(this.getName(), (Object)variableType.name()));
    }

    @Override
    public Optional<VariableForEnum> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public VariableForFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        VariableForEnum finalValue = ((Optional)value).orElse(VariableForEnum.GLOBAL);
        this.updateVariableFor(finalValue, gui);
    }

    @Override
    public VariableForFeature clone(FeatureParentInterface newParent) {
        VariableForFeature clone = new VariableForFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateVariableFor(this.nextVariableType(this.getVariableFor((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateVariableFor(this.prevVariableType(this.getVariableFor((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public VariableForEnum nextVariableType(VariableForEnum material) {
        boolean next = false;
        for (VariableForEnum check : this.getSortVariableFor()) {
            if (check.equals((Object)material)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortVariableFor().get(0);
    }

    public VariableForEnum prevVariableType(VariableForEnum material) {
        int i = -1;
        int cpt = 0;
        for (VariableForEnum check : this.getSortVariableFor()) {
            if (check.equals((Object)material)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortVariableFor().get(this.getSortVariableFor().size() - 1);
        }
        return this.getSortVariableFor().get(cpt - 1);
    }

    public void updateVariableFor(VariableForEnum typeTarget, GUI gui) {
        this.value = Optional.of(typeTarget);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortVariableFor().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (VariableForEnum check : this.getSortVariableFor()) {
            if (typeTarget.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + typeTarget.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (VariableForEnum check : this.getSortVariableFor()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public VariableForEnum getVariableFor(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return VariableForEnum.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<VariableForEnum> getSortVariableFor() {
        TreeMap<String, VariableForEnum> map = new TreeMap<String, VariableForEnum>();
        for (VariableForEnum l : VariableForEnum.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<VariableForEnum>(map.values());
    }

    @Generated
    public Optional<VariableForEnum> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<VariableForEnum> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<VariableForEnum> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

