/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.enums;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EnumFeature<T extends Enum>
extends FeatureAbstract<Optional<T>, EnumFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Class<T> enumClass;
    private T fallBackValue;
    private String enumName;
    private List<T> enumValues;
    private Optional<T> value;
    private Optional<T> defaultValue;

    public EnumFeature(FeatureParentInterface parent, Optional<T> defaultValue, FeatureSettingsInterface settings, Class<T> enumClass, T fallBackValue, String enumName, List<T> enumValues) {
        super(parent, settings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
        this.enumClass = enumClass;
        this.fallBackValue = fallBackValue;
        this.enumName = enumName;
        this.enumValues = enumValues;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            if (this.defaultValue.isPresent()) {
                this.value = this.defaultValue;
            } else {
                errors.add("&cERROR, Couldn't load the " + this.enumName + " value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> " + String.valueOf(this.enumValues));
                this.value = Optional.empty();
            }
            return errors;
        }
        try {
            T attributeSlot = Enum.valueOf(this.enumClass, colorStr);
            this.value = Optional.ofNullable(attributeSlot);
            FeatureReturnCheckPremium<T> checkPremium = this.checkPremium(this.enumName, attributeSlot, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of((Enum)checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the " + this.enumName + " value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> " + String.valueOf(this.enumValues));
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(type -> config.set(this.getName(), (Object)type.name()));
    }

    @Override
    public Optional<T> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public EnumFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        Enum finalValue = (Enum)((Optional)value).orElse(this.fallBackValue);
        this.updateEnum(finalValue, gui);
    }

    @Override
    public EnumFeature clone(FeatureParentInterface newParent) {
        EnumFeature<T> clone = new EnumFeature<T>(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.enumClass, this.fallBackValue, this.enumName, this.enumValues);
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateEnum(this.nextEnum(this.getEnum((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateEnum(this.prevEnum(this.getEnum((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public T nextEnum(T slot) {
        boolean next = false;
        for (Enum check : this.getSortEnum()) {
            if (check.equals(slot)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return (T)check;
        }
        return (T)((Enum)this.getSortEnum().get(0));
    }

    public T prevEnum(T slot) {
        int i = -1;
        int cpt = 0;
        for (Enum check : this.getSortEnum()) {
            if (check.equals(slot)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return (T)((Enum)this.getSortEnum().get(this.getSortEnum().size() - 1));
        }
        return (T)((Enum)this.getSortEnum().get(cpt - 1));
    }

    public void updateEnum(T slot, GUI gui) {
        this.value = Optional.of(slot);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortEnum().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (Enum check : this.getSortEnum()) {
            if (((Enum)slot).equals(check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + ((Enum)slot).name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (Enum check : this.getSortEnum()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        for (HumanEntity e : gui.getInv().getViewers()) {
            if (!(e instanceof Player)) continue;
            Player p = (Player)e;
            p.updateInventory();
        }
    }

    public T getEnum(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return Enum.valueOf(this.enumClass, str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<T> getSortEnum() {
        TreeMap<String, Enum> map = new TreeMap<String, Enum>();
        for (Enum l : this.enumValues) {
            map.put(l.name(), l);
        }
        return new ArrayList(map.values());
    }

    @Generated
    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    @Generated
    public T getFallBackValue() {
        return this.fallBackValue;
    }

    @Generated
    public String getEnumName() {
        return this.enumName;
    }

    @Generated
    public List<T> getEnumValues() {
        return this.enumValues;
    }

    @Generated
    public Optional<T> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setEnumClass(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Generated
    public void setFallBackValue(T fallBackValue) {
        this.fallBackValue = fallBackValue;
    }

    @Generated
    public void setEnumName(String enumName) {
        this.enumName = enumName;
    }

    @Generated
    public void setEnumValues(List<T> enumValues) {
        this.enumValues = enumValues;
    }

    @Generated
    public void setValue(Optional<T> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<T> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

