/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;

public class ListDamageCauseFeature
extends ListFeatureAbstract<EntityDamageEvent.DamageCause, ListDamageCauseFeature> {
    public ListDamageCauseFeature(FeatureParentInterface parent, List<EntityDamageEvent.DamageCause> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, "List of DamageCauses", defaultValue, featureSettings);
        this.reset();
    }

    @Override
    public List<EntityDamageEvent.DamageCause> loadValues(List<String> entries, List<String> errors) {
        ArrayList<EntityDamageEvent.DamageCause> value = new ArrayList<EntityDamageEvent.DamageCause>();
        for (String s : entries) {
            s = StringConverter.decoloredString(s.toUpperCase());
            try {
                EntityDamageEvent.DamageCause mat = EntityDamageEvent.DamageCause.valueOf((String)s);
                value.add(mat);
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the DamageCause value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> DamageCauses available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/event/entity/EntityDamageEvent.DamageCause.html");
            }
        }
        return value;
    }

    @Override
    public String transfromToString(EntityDamageEvent.DamageCause value) {
        return value.name();
    }

    public boolean verifCause(EntityDamageEvent.DamageCause cause) {
        if (cause != null) {
            if (this.getValues().isEmpty()) {
                return true;
            }
            return this.getValues().contains(cause);
        }
        return false;
    }

    @Override
    public ListDamageCauseFeature clone(FeatureParentInterface newParent) {
        ListDamageCauseFeature clone = new ListDamageCauseFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        message = StringConverter.decoloredString(message);
        try {
            EntityDamageEvent.DamageCause mat = EntityDamageEvent.DamageCause.valueOf((String)message);
            this.getValues().add(mat);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of("&4&l[ERROR] &cThe message you entered is not a DamageCause &6>> DamageCause available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/event/entity/EntityDamageEvent.DamageCause.html");
        }
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (EntityDamageEvent.DamageCause mat : EntityDamageEvent.DamageCause.values()) {
            map.put(mat.toString(), new Suggestion(String.valueOf(mat), "&6[&e" + String.valueOf(mat) + "&6]", "&7Add &e" + String.valueOf(mat)));
        }
        return new ArrayList<Suggestion>(map.values());
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, true, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }
}

