/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.executableblocks.api.ExecutableBlocksAPI;
import com.ssomar.executableblocks.executableblocks.ExecutableBlockObject;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.api.executableblocks.config.placed.ExecutableBlockPlacedInterface;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.usedapi.ItemsAdderAPI;
import com.ssomar.score.utils.emums.MaterialWithGroups;
import com.ssomar.score.utils.strings.StringConverter;
import com.ssomar.score.utils.tags.MinecraftTags;
import de.tr7zw.nbtapi.NBTItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListDetailedMaterialFeature
extends ListFeatureAbstract<String, ListDetailedMaterialFeature>
implements Serializable {
    private static final String symbolStart = "{";
    private static final String symbolEnd = "}";
    private static final String symbolEquals = ":";
    private static final String symbolSeparator = "\\+";
    private static final Boolean DEBUG = true;
    private static final String symbolStartMaterialTag = "#";
    private List<String> listOfCustomBlocksPluginSupported = new ArrayList<String>();
    private boolean forBlocks;
    private boolean specificationOfAtLeastOneState;

    public ListDetailedMaterialFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings, boolean forBlocks) {
        super(parent, "List of Materials", defaultValue, featureSettings);
        if (SCore.hasItemsAdder) {
            this.listOfCustomBlocksPluginSupported.add("ITEMSADDER");
        }
        if (SCore.hasExecutableItems) {
            this.listOfCustomBlocksPluginSupported.add("EXECUTABLEITEMS");
        }
        if (SCore.hasExecutableBlocks) {
            this.listOfCustomBlocksPluginSupported.add("EXECUTABLEBLOCKS");
        }
        this.forBlocks = forBlocks;
        this.reset();
    }

    public ListDetailedMaterialFeature(boolean forBlocks) {
        if (SCore.hasItemsAdder) {
            this.listOfCustomBlocksPluginSupported.add("ITEMSADDER");
        }
        if (SCore.hasExecutableItems) {
            this.listOfCustomBlocksPluginSupported.add("EXECUTABLEITEMS");
        }
        if (Dependency.EXECUTABLE_BLOCKS.isInstalled()) {
            this.listOfCustomBlocksPluginSupported.add("EXECUTABLEBLOCKS");
        }
        this.forBlocks = forBlocks;
        this.reset();
    }

    @Override
    public List<String> loadValues(List<String> entries, List<String> errors) {
        ArrayList<String> values = new ArrayList<String>();
        for (String s : entries) {
            String materialStr = s = StringConverter.decoloredString(s);
            boolean isCustomBlock = false;
            for (String customPlugin : this.listOfCustomBlocksPluginSupported) {
                if (!materialStr.startsWith(customPlugin)) continue;
                values.add(s);
                isCustomBlock = true;
                break;
            }
            if (isCustomBlock) continue;
            materialStr = materialStr.toUpperCase();
            boolean isMaterialTag = false;
            if (s.startsWith(symbolStartMaterialTag)) {
                isMaterialTag = true;
                values.add(s);
            }
            if (isMaterialTag) continue;
            if (s.contains(symbolStart)) {
                this.specificationOfAtLeastOneState = true;
                materialStr = s.split("\\{")[0];
                String datas = s.split("\\{")[1].replace(symbolEnd, "");
                for (String data : datas.split(symbolSeparator)) {
                    String[] dataSplit = data.split(symbolEquals);
                    if (dataSplit.length == 2) continue;
                    String parentInfo = "";
                    if (this.getParent() != null) {
                        parentInfo = this.getParent().getParentInfo();
                    }
                    errors.add("&cERROR, Couldn't load the The tags value of " + this.getName() + " from config, value: " + s + " &7&o" + parentInfo + " &6>> Example : FURNACE{lit:true}  BEETROOTS{age:3}, List of tags: https://minecraft.fandom.com/wiki/Block_states");
                }
            }
            if (!MaterialWithGroups.getMaterialWithGroups(materialStr.toUpperCase()).isPresent()) {
                String parentInfo = "";
                if (this.getParent() != null) {
                    parentInfo = this.getParent().getParentInfo();
                }
                errors.add("&cERROR, Couldn't load the Material + GROUPS value of " + this.getName() + " from config, value: " + s + " &7&o" + parentInfo + " &6>> Check the wiki if you want the list of materials and groups");
                continue;
            }
            values.add(s);
        }
        return values;
    }

    @Override
    public String transfromToString(String value) {
        return value;
    }

    public Map<String, List<Map<String, String>>> extractConditions(List<String> values) {
        HashMap<String, List<Map<String, String>>> conditions = new HashMap<String, List<Map<String, String>>>();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String s;
            String materialStr = s = iterator.next();
            boolean isCustomBlock = false;
            for (String customPlugin : this.listOfCustomBlocksPluginSupported) {
                if (!materialStr.startsWith(customPlugin)) continue;
                isCustomBlock = true;
                break;
            }
            if (isCustomBlock) continue;
            HashMap<String, String> tags = new HashMap<String, String>();
            if (s.contains(symbolStart)) {
                materialStr = s.split("\\{")[0];
                String datas = s.split("\\{")[1].replace(symbolEnd, "");
                for (String data : datas.split(symbolSeparator)) {
                    String[] dataSplit = data.split(symbolEquals);
                    tags.put(dataSplit[0].toUpperCase(), dataSplit[1]);
                }
            }
            if (conditions.containsKey(materialStr.toUpperCase())) {
                ((List)conditions.get(materialStr.toUpperCase())).add(tags);
            } else {
                conditions.put(materialStr.toUpperCase(), new ArrayList(Collections.singletonList(tags)));
            }
            SsomarDev.testMsg(" >> conditions size: " + ((List)conditions.get(materialStr.toUpperCase())).size(), DEBUG);
        }
        return conditions;
    }

    public boolean isValidMaterial(@NotNull Material material, Optional<String> statesStrOpt) {
        boolean forValuesBool = this.isValidMaterial(true, this.getValues(), material, statesStrOpt);
        SsomarDev.testMsg(">> verif forValuesBool: " + forValuesBool, DEBUG);
        boolean forBlacklistValuesBool = this.isValidMaterial(false, this.getBlacklistedValues(), material, statesStrOpt);
        SsomarDev.testMsg(">> verif forBlacklistValuesBool: " + forBlacklistValuesBool, DEBUG);
        return forValuesBool && !forBlacklistValuesBool;
    }

    public boolean isValidMaterial(boolean ifEmpty, List<String> references, @NotNull Material material, Optional<String> statesStrOpt) {
        for (String s : references) {
            SsomarDev.testMsg(">> verif references: " + s, DEBUG);
        }
        Map<String, List<Map<String, String>>> conditions = this.extractConditions(references);
        if (conditions.isEmpty()) {
            SsomarDev.testMsg(">> verif conditions.isEmpty(): " + conditions.isEmpty(), DEBUG);
            return ifEmpty;
        }
        String symbolStart = symbolStart;
        String symbolStartSplit = "\\{";
        String symbolEnd = symbolEnd;
        String symbolEquals = symbolEquals;
        String symbolSeparator = ",";
        if (this.forBlocks) {
            symbolStart = "[";
            symbolStartSplit = "\\[";
            symbolEnd = "]";
            symbolEquals = "=";
            symbolSeparator = ",";
        }
        HashMap<String, String> states = new HashMap<String, String>();
        try {
            SsomarDev.testMsg(">> verif statesStrOpt: " + statesStrOpt.isPresent(), DEBUG);
            if (statesStrOpt.isPresent()) {
                String[] spliter1;
                String[] spliter2;
                SsomarDev.testMsg(">> verif statesStr: " + statesStrOpt.get(), DEBUG);
                String statesStr = statesStrOpt.get().toUpperCase();
                if (statesStr.contains(symbolStart) && (spliter2 = (spliter1 = statesStr.split(symbolEnd))[0].split(symbolStartSplit)).length >= 2) {
                    String[] spliterStates;
                    SsomarDev.testMsg(">> spliter2: " + spliter2[1], DEBUG);
                    for (String state : spliterStates = spliter2[1].split(symbolSeparator)) {
                        String[] spliterState = state.split(symbolEquals);
                        if (spliterState.length < 2) {
                            SsomarDev.testMsg(">> spliterState.length: " + spliterState.length, DEBUG);
                            continue;
                        }
                        SsomarDev.testMsg(">> spliterState: " + spliterState[0] + "=" + spliterState[1], DEBUG);
                        states.put(spliterState[0].toUpperCase(), spliterState[1].toUpperCase());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String mat : conditions.keySet()) {
            if (!SCore.is1v11Less() && mat.startsWith(symbolStartMaterialTag)) {
                mat = mat.substring(1).toLowerCase();
                SsomarDev.testMsg(">> verif tag: " + mat, DEBUG);
                Tag<Material> tag = MinecraftTags.getInstance().getTag(mat);
                if (tag != null) {
                    if (MinecraftTags.getInstance().checkIfTagged(material, tag)) {
                        return true;
                    }
                    SsomarDev.testMsg(">> verif tag not found: " + mat + " for material " + String.valueOf(material), DEBUG);
                    continue;
                }
                SsomarDev.testMsg(">> verif tag not found: " + mat, DEBUG);
                continue;
            }
            if (!MaterialWithGroups.verif(material, mat)) continue;
            SsomarDev.testMsg(">> verif mat: " + mat, DEBUG);
            List<Map<String, String>> tagsList = conditions.get(mat);
            SsomarDev.testMsg(">> verif tagsList empty ?: " + tagsList.isEmpty(), DEBUG);
            if (tagsList.isEmpty()) {
                return true;
            }
            for (Map<String, String> tags : tagsList) {
                boolean invalid = false;
                if (tags.isEmpty()) {
                    return true;
                }
                for (String key : tags.keySet()) {
                    SsomarDev.testMsg(">> verif key: " + key, DEBUG);
                    String keyUpper = key.toUpperCase();
                    if (states.containsKey(keyUpper)) {
                        if (!((String)states.get(key)).equalsIgnoreCase(tags.get(key))) {
                            SsomarDev.testMsg(">> verif states.get(key): " + (String)states.get(key) + " != tags.get(key): " + tags.get(key), DEBUG);
                            invalid = true;
                            break;
                        }
                    } else {
                        invalid = true;
                    }
                    if (!invalid) continue;
                    break;
                }
                if (invalid) continue;
                return true;
            }
        }
        return false;
    }

    public List<Tag<Material>> asTagList() {
        ArrayList<Tag<Material>> tags = new ArrayList<Tag<Material>>();
        Iterator iterator = this.getValues().iterator();
        while (iterator.hasNext()) {
            String s;
            String materialStr = s = (String)iterator.next();
            SsomarDev.testMsg(">> materialStr: " + materialStr, DEBUG);
            if (SCore.is1v11Less() || !materialStr.startsWith(symbolStartMaterialTag)) continue;
            materialStr = materialStr.substring(1).toLowerCase();
            SsomarDev.testMsg(">> verif tag: " + materialStr, DEBUG);
            Tag<Material> tag = MinecraftTags.getInstance().getTag(materialStr);
            if (tag != null) {
                tags.add(tag);
                continue;
            }
            SsomarDev.testMsg(">> verif tag not found: " + materialStr, DEBUG);
        }
        return tags;
    }

    public List<Material> asMaterialList() {
        ArrayList<Material> materials = new ArrayList<Material>();
        Iterator iterator = this.getValues().iterator();
        while (iterator.hasNext()) {
            String s;
            String materialStr = s = (String)iterator.next();
            try {
                Material mat = Material.valueOf((String)materialStr.toUpperCase());
                materials.add(mat);
            }
            catch (Exception e) {
                SsomarDev.testMsg(">> verif material not found: " + materialStr, DEBUG);
            }
        }
        return materials;
    }

    public Map<String, List<String>> extractCustomBlocksConditions(List<String> values) {
        HashMap<String, List<String>> conditions = new HashMap<String, List<String>>();
        Iterator<String> iterator = values.iterator();
        block0: while (iterator.hasNext()) {
            String s;
            String materialStr = s = iterator.next();
            SsomarDev.testMsg(">> materialStr: " + materialStr, DEBUG);
            for (String customPlugin : this.listOfCustomBlocksPluginSupported) {
                if (!materialStr.startsWith(customPlugin)) continue;
                if (conditions.containsKey(customPlugin)) {
                    ((List)conditions.get(customPlugin)).add(materialStr.split(symbolEquals)[1]);
                    continue block0;
                }
                conditions.put(customPlugin, new ArrayList<String>(Collections.singletonList(materialStr.split(symbolEquals)[1])));
                continue block0;
            }
        }
        return conditions;
    }

    public boolean isValidCustomBlockOnly(@NotNull Block block) {
        boolean forValuesBool = this.isValidCustomBlock(true, this.getValues(), block);
        SsomarDev.testMsg(">> CUSTOMBLOCK verif forValuesBool: " + forValuesBool, DEBUG);
        boolean forBlacklistValuesBool = this.isValidCustomBlock(false, this.getBlacklistedValues(), block);
        SsomarDev.testMsg(">> CUSTOMBLOCK verif forBlacklistValuesBool: " + forBlacklistValuesBool, DEBUG);
        return forValuesBool && !forBlacklistValuesBool;
    }

    public boolean isValidCustomBlock(boolean ifEmpty, List<String> references, @NotNull Block block) {
        Map<String, List<String>> conditions = this.extractCustomBlocksConditions(references);
        if (conditions.isEmpty()) {
            return ifEmpty;
        }
        for (String customPlugin : this.listOfCustomBlocksPluginSupported) {
            Optional customOpt;
            SsomarDev.testMsg(">> verif customPlugin: " + customPlugin, DEBUG);
            if (!conditions.containsKey(customPlugin)) continue;
            SsomarDev.testMsg(">> verif conditions: YES ", DEBUG);
            if (customPlugin.equals("ITEMSADDER") && SCore.hasItemsAdder) {
                customOpt = ItemsAdderAPI.getCustomBlockID(block);
                SsomarDev.testMsg(">> IA customOpt: " + customOpt.isPresent(), DEBUG);
                if (!customOpt.isPresent()) continue;
                SsomarDev.testMsg(">> IA customOpt: " + (String)customOpt.get(), DEBUG);
                for (String id : conditions.get(customPlugin)) {
                    SsomarDev.testMsg(">> IA id: " + id, DEBUG);
                    if (!((String)customOpt.get()).equalsIgnoreCase(id)) continue;
                    return true;
                }
                continue;
            }
            if (!customPlugin.equals("EXECUTABLEBLOCKS") || !SCore.hasExecutableBlocks) continue;
            customOpt = ExecutableBlocksAPI.getExecutableBlocksPlacedManager().getExecutableBlockPlaced(block);
            SsomarDev.testMsg(">> EB customOpt: " + customOpt.isPresent(), DEBUG);
            if (!customOpt.isPresent()) continue;
            SsomarDev.testMsg(">> EB customOpt: " + ((ExecutableBlockPlacedInterface)customOpt.get()).getEB_ID(), DEBUG);
            for (String id : conditions.get(customPlugin)) {
                SsomarDev.testMsg(">> EB id: " + id, DEBUG);
                if (!((ExecutableBlockPlacedInterface)customOpt.get()).getEB_ID().equalsIgnoreCase(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean verifBlock(@NotNull Block block) {
        return this.verifBlock(block, null, Optional.empty());
    }

    public boolean verifBlock(@NotNull Block block, @Nullable Material material, @NotNull Optional<String> statesStrOpt) {
        if (material == null) {
            material = block.getType();
        }
        SsomarDev.testMsg(">> verif specificationOfAtLeastOneState: " + this.specificationOfAtLeastOneState, DEBUG);
        if (this.specificationOfAtLeastOneState && !statesStrOpt.isPresent()) {
            statesStrOpt = !SCore.is1v12Less() ? Optional.of(block.getBlockData().getAsString(true)) : Optional.empty();
        }
        boolean forValuesBoolMat = this.isValidMaterial(this.getValue().isEmpty(), this.getValues(), material, statesStrOpt);
        SsomarDev.testMsg(">> verif forValuesBool: " + forValuesBoolMat, DEBUG);
        boolean forBlacklistValuesBoolMat = this.isValidMaterial(false, this.getBlacklistedValues(), material, statesStrOpt);
        SsomarDev.testMsg(">> verif forBlacklistValuesBool: " + forBlacklistValuesBoolMat, DEBUG);
        boolean forValuesBool = this.isValidCustomBlock(this.getValue().isEmpty(), this.getValues(), block);
        SsomarDev.testMsg(">> CUSTOMBLOCK verif forValuesBool: " + forValuesBool, DEBUG);
        boolean forBlacklistValuesBool = this.isValidCustomBlock(false, this.getBlacklistedValues(), block);
        SsomarDev.testMsg(">> CUSTOMBLOCK verif forBlacklistValuesBool: " + forBlacklistValuesBool, DEBUG);
        return (forValuesBool || forValuesBoolMat) && !forBlacklistValuesBool && !forBlacklistValuesBoolMat;
    }

    public boolean isValidCustomItemOnly(@NotNull ItemStack item) {
        boolean forValuesBool = this.isValidCustomItem(true, this.getValues(), item);
        boolean forBlacklistValuesBool = this.isValidCustomItem(false, this.getBlacklistedValues(), item);
        return forValuesBool && !forBlacklistValuesBool;
    }

    public boolean isValidCustomItem(boolean ifEmpty, List<String> references, @NotNull ItemStack item) {
        Map<String, List<String>> conditions = this.extractCustomBlocksConditions(references);
        if (conditions.isEmpty()) {
            return ifEmpty;
        }
        for (String customPlugin : this.listOfCustomBlocksPluginSupported) {
            ExecutableBlockObject customOpt;
            SsomarDev.testMsg(">> verif customPlugin: " + customPlugin, DEBUG);
            if (!conditions.containsKey(customPlugin)) continue;
            SsomarDev.testMsg(">> verif conditions: YES ", DEBUG);
            if (customPlugin.equals("ITEMSADDER") && SCore.hasItemsAdder) {
                customOpt = ItemsAdderAPI.getCustomItemID(item);
                SsomarDev.testMsg(">> customOpt: " + customOpt.isPresent(), DEBUG);
                if (!customOpt.isPresent()) continue;
                SsomarDev.testMsg(">> customOpt: " + (String)customOpt.get(), DEBUG);
                for (String id : conditions.get(customPlugin)) {
                    SsomarDev.testMsg(">> id: " + id, DEBUG);
                    if (!((String)customOpt.get()).equalsIgnoreCase(id)) continue;
                    return true;
                }
                continue;
            }
            if (customPlugin.equals("EXECUTABLEBLOCKS") && SCore.hasExecutableBlocks) {
                customOpt = ExecutableBlocksAPI.getExecutableBlockObject((ItemStack)item);
                if (!customOpt.isValid()) continue;
                for (String id : conditions.get(customPlugin)) {
                    SsomarDev.testMsg(">> id: " + id, DEBUG);
                    if (!customOpt.getConfig().getId().equalsIgnoreCase(id)) continue;
                    return true;
                }
                continue;
            }
            if (!customPlugin.equals("EXECUTABLEITEMS") || !SCore.hasExecutableItems || !(customOpt = (ExecutableItemObject)ExecutableItemsAPI.getExecutableItemObject(item)).isValid()) continue;
            for (String id : conditions.get(customPlugin)) {
                SsomarDev.testMsg(">> id EI: " + id, DEBUG);
                if (!customOpt.getConfig().getId().equalsIgnoreCase(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean verifItem(@NotNull ItemStack item) {
        Optional<String> statesStrOpt;
        Material material = item.getType();
        if (SCore.hasNBTAPI && !item.getType().equals((Object)Material.AIR)) {
            NBTItem nbti = new NBTItem(item);
            String str = nbti.toString();
            statesStrOpt = Optional.of(str);
        } else {
            statesStrOpt = Optional.empty();
        }
        boolean forValuesBoolMat = this.isValidMaterial(this.getValue().isEmpty(), this.getValues(), material, statesStrOpt);
        SsomarDev.testMsg(">> verif forValuesBool: " + forValuesBoolMat, DEBUG);
        boolean forBlacklistValuesBoolMat = this.isValidMaterial(false, this.getBlacklistedValues(), material, statesStrOpt);
        SsomarDev.testMsg(">> verif forBlacklistValuesBool: " + forBlacklistValuesBoolMat, DEBUG);
        boolean forValuesBool = this.isValidCustomItem(this.getValue().isEmpty(), this.getValues(), item);
        SsomarDev.testMsg(">> CUSTOMBLOCK verif forValuesBool: " + forValuesBool, DEBUG);
        boolean forBlacklistValuesBool = this.isValidCustomItem(this.getValue().isEmpty(), this.getBlacklistedValues(), item);
        SsomarDev.testMsg(">> CUSTOMBLOCK verif forBlacklistValuesBool: " + forBlacklistValuesBool, DEBUG);
        return (forValuesBool || forValuesBoolMat) && !forBlacklistValuesBool && !forBlacklistValuesBoolMat;
    }

    @Override
    public ListDetailedMaterialFeature clone(FeatureParentInterface newParent) {
        ListDetailedMaterialFeature clone = new ListDetailedMaterialFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.isForBlocks());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        String s;
        String str = s = StringConverter.decoloredString(message).replace("!", "");
        boolean isCustomBlock = false;
        for (String customPlugin : this.listOfCustomBlocksPluginSupported) {
            if (!str.startsWith(customPlugin)) continue;
            isCustomBlock = true;
            break;
        }
        if (isCustomBlock) {
            return Optional.empty();
        }
        boolean isMaterialTag = false;
        if (s.startsWith(symbolStartMaterialTag)) {
            isMaterialTag = true;
        }
        if (isMaterialTag) {
            return Optional.empty();
        }
        if (s.contains(symbolStart)) {
            str = s.split("\\{")[0];
            String datas = s.split("\\{")[1].replace(symbolEnd, "");
            for (String data : datas.split(symbolSeparator)) {
                String[] dataSplit = data.split(symbolEquals);
                if (dataSplit.length == 2) continue;
                return Optional.of("&4&l[ERROR] &cThe message you entered contains an invalid format  &6>> Example : FURNACE{lit:true}  BEETROOTS{age:3}, List of tags: https://minecraft.fandom.com/wiki/Block_states and &7(Check the wiki if you want more examples)");
            }
        }
        if (!MaterialWithGroups.getMaterialWithGroups(str.toUpperCase()).isPresent()) {
            return Optional.of("&4&l[ERROR] &cThe message you entered contains an invalid Material + GROUPS ! (Check the wiki if you want the list)");
        }
        return Optional.empty();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return new ArrayList<TextComponent>();
    }

    @Override
    public List<Suggestion> getSuggestions() {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        for (MaterialWithGroups materialWithGroups : MaterialWithGroups.values()) {
            suggestions.add(new Suggestion(materialWithGroups.toString(), "&6[&e" + String.valueOf((Object)materialWithGroups) + "&6]", "&7Add &e" + String.valueOf((Object)materialWithGroups)));
        }
        return suggestions;
    }

    @Override
    public String getTips() {
        if (this.forBlocks) {
            return "&8Example &7&oFURNACE &8- &7&oBEETROOTS{age:3} &8- &7&oITEMSADDER:turquoise_block";
        }
        return "&8Example &7&oDIAMOND_SWORD &8- &7&oTORCH{CustomModelData:3} &8- &7&oITEMSADDER:ruby_sword &8- &7&oEXECUTABLEITEMS:my_ei_sword";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your detailed " + this.getEditorName() + symbolEquals);
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + symbolEquals, true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    @Generated
    public List<String> getListOfCustomBlocksPluginSupported() {
        return this.listOfCustomBlocksPluginSupported;
    }

    @Generated
    public boolean isForBlocks() {
        return this.forBlocks;
    }

    @Generated
    public boolean isSpecificationOfAtLeastOneState() {
        return this.specificationOfAtLeastOneState;
    }

    @Generated
    public void setListOfCustomBlocksPluginSupported(List<String> listOfCustomBlocksPluginSupported) {
        this.listOfCustomBlocksPluginSupported = listOfCustomBlocksPluginSupported;
    }

    @Generated
    public void setForBlocks(boolean forBlocks) {
        this.forBlocks = forBlocks;
    }

    @Generated
    public void setSpecificationOfAtLeastOneState(boolean specificationOfAtLeastOneState) {
        this.specificationOfAtLeastOneState = specificationOfAtLeastOneState;
    }
}

