/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ListEntityTypeFeature
extends ListFeatureAbstract<EntityType, ListEntityTypeFeature> {
    public ListEntityTypeFeature(FeatureParentInterface parent, List<EntityType> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, "List of EntityTypes", defaultValue, featureSettings);
        this.reset();
    }

    @Override
    public List<EntityType> loadValues(List<String> entries, List<String> errors) {
        ArrayList<EntityType> value = new ArrayList<EntityType>();
        for (String s : entries) {
            s = StringConverter.decoloredString(s);
            try {
                EntityType mat = EntityType.valueOf((String)s);
                value.add(mat);
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the EntityType value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> EntityTypes available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/entity/EntityType.html");
            }
        }
        return value;
    }

    @Override
    public String transfromToString(EntityType value) {
        return value.name();
    }

    @Override
    public ListEntityTypeFeature clone(FeatureParentInterface newParent) {
        ListEntityTypeFeature clone = new ListEntityTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        message = StringConverter.decoloredString(message).toUpperCase();
        try {
            EntityType mat = EntityType.valueOf((String)message);
            this.getValues().add(mat);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of("&4&l[ERROR] &cThe message you entered is not a EntityType &6>> EntityTypes available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/entity/EntityType.html");
        }
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (EntityType mat : EntityType.values()) {
            map.put(mat.toString(), new Suggestion(String.valueOf(mat), "&6[&e" + String.valueOf(mat) + "&6]", "&7Add &e" + String.valueOf(mat)));
        }
        return new ArrayList<Suggestion>(map.values());
    }

    @Override
    public String getTips() {
        return "&8Example &7&oBLAZE";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, true, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }
}

