/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;

public class ListInventoryTypeFeature
extends ListFeatureAbstract<InventoryType, ListInventoryTypeFeature> {
    public ListInventoryTypeFeature(FeatureParentInterface parent, List<InventoryType> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, "List of InventoryType", defaultValue, featureSettings);
        this.reset();
    }

    @Override
    public List<InventoryType> loadValues(List<String> entries, List<String> errors) {
        ArrayList<InventoryType> value = new ArrayList<InventoryType>();
        for (String s : entries) {
            s = StringConverter.decoloredString(s.toUpperCase());
            try {
                InventoryType mat = InventoryType.valueOf((String)s);
                value.add(mat);
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the InventoryType value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> InventoryType available: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/event/inventory/InventoryType.html");
            }
        }
        return value;
    }

    @Override
    public String transfromToString(InventoryType value) {
        return value.name();
    }

    public boolean verifInventoryType(InventoryType cause) {
        if (cause != null) {
            if (this.getValues().isEmpty()) {
                return true;
            }
            return this.getValues().contains(cause);
        }
        return false;
    }

    @Override
    public ListInventoryTypeFeature clone(FeatureParentInterface newParent) {
        ListInventoryTypeFeature clone = new ListInventoryTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        message = StringConverter.decoloredString(message);
        try {
            InventoryType mat = InventoryType.valueOf((String)message);
            this.getValues().add(mat);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of("&4&l[ERROR] &cThe message you entered is not an InventoryType &6>> InventoryType available: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/event/inventory/InventoryType.html");
        }
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (InventoryType mat : InventoryType.values()) {
            map.put(mat.toString(), new Suggestion(String.valueOf(mat), "&6[&e" + String.valueOf(mat) + "&6]", "&7Add &e" + String.valueOf(mat)));
        }
        return new ArrayList<Suggestion>(map.values());
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, true, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }
}

