/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class ListStringFeature
extends ListFeatureAbstract<String, ListStringFeature> {
    private Optional<List<Suggestion>> suggestions;

    public ListStringFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings, Optional<List<Suggestion>> suggestions) {
        super(parent, "List of Strings", defaultValue, featureSettings);
        this.suggestions = suggestions;
        this.reset();
    }

    @Override
    public List<String> loadValues(List<String> entries, List<String> errors) {
        return entries;
    }

    @Override
    public String transfromToString(String value) {
        return value;
    }

    public List<String> getColoredValue() {
        ArrayList<String> colored = new ArrayList<String>();
        for (String s : this.getValues()) {
            colored.add(s);
        }
        return colored;
    }

    @Override
    public ListStringFeature clone(FeatureParentInterface newParent) {
        ListStringFeature clone = new ListStringFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.suggestions);
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        return Optional.empty();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        return this.suggestions.orElseGet(ArrayList::new);
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    public List<String> getValue(StringPlaceholder sp) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.getValues()) {
            result.add(sp.replacePlaceholder(s));
        }
        return result;
    }

    @Generated
    public void setSuggestions(Optional<List<Suggestion>> suggestions) {
        this.suggestions = suggestions;
    }
}

