/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.languages.messages;

import com.ssomar.score.SCore;
import com.ssomar.score.config.Config;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.languages.messages.TextInterface;
import com.ssomar.score.languages.messages.TypeText;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.utils.logging.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class TM {
    private static TM instance;
    private String fileName = "";
    private Map<TextInterface, String> messages = new HashMap<TextInterface, String>();
    private Map<TextInterface, String[]> messagesArray = new HashMap<TextInterface, String[]>();

    public static TM getInstance() {
        if (instance == null) {
            instance = new TM();
        }
        return instance;
    }

    public static TM i() {
        if (instance == null) {
            instance = new TM();
        }
        return instance;
    }

    public void load() {
        this.messages = new HashMap<TextInterface, String>();
        Utils.sendConsoleMsg("&eSCore &7Language of the editor setup on &6" + String.valueOf((Object)GeneralConfig.getInstance().getLocale()));
        this.fileName = "language_" + GeneralConfig.getInstance().getLocale().toString().toLowerCase() + ".yml";
    }

    public void reload() {
        this.messages = new HashMap<TextInterface, String>();
        this.messagesArray = new HashMap<TextInterface, String[]>();
        Utils.sendConsoleMsg("&eSCore &7Language of the editor setup on &6" + String.valueOf((Object)GeneralConfig.getInstance().getLocale()));
        this.fileName = "language_" + GeneralConfig.getInstance().getLocale().toString().toLowerCase() + ".yml";
        this.loadTexts();
        GUI.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTexts() {
        File pdfile;
        if (!SCore.dataFolder.exists()) {
            SCore.dataFolder.mkdir();
        }
        if (!(pdfile = new File(SCore.dataFolder, "languages" + File.separator + this.fileName)).exists()) {
            try {
                pdfile.getParentFile().mkdir();
                pdfile.createNewFile();
                BufferedReader br = new BufferedReader(new InputStreamReader(Config.getResource(SCore.classLoader, this.fileName)));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pdfile), StandardCharsets.UTF_8));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        out.write(line);
                        out.write("\n");
                    }
                }
                finally {
                    br.close();
                    ((Writer)out).close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create the file: " + this.fileName + " for the plugin: SCore", e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)pdfile);
        for (Text msgI : Text.values()) {
            this.loadMessage(msgI, SCore.classLoader, "SCore", pdfile, (FileConfiguration)config, msgI.getKey());
        }
    }

    public void loadMessage(TextInterface msgI, ClassLoader classLoader, String pluginName, File pdFile, FileConfiguration config, String message) {
        if (config.isList(message)) {
            List object = config.getStringList(message);
            this.messagesArray.put(msgI, object.toArray(new String[0]));
        } else if (config.isString(message)) {
            String object = config.getString(message);
            this.messages.put(msgI, object);
        } else {
            this.write(msgI, classLoader, pluginName, pdFile, config, message);
        }
    }

    public void write(TextInterface msgI, ClassLoader classLoader, String pluginName, File pdFile, FileConfiguration config, String what) {
        String insert = "Can't load the string (" + what + ") for the plugin > " + pluginName + " in language: " + String.valueOf((Object)GeneralConfig.getInstance().getLocale()) + ", contact the developper";
        try {
            String defaultLanguage = GeneralConfig.getInstance().getLocale().toString();
            String defaultFileName = "language_" + defaultLanguage.toLowerCase() + ".yml";
            InputStreamReader lecture = new InputStreamReader(Config.getResource(classLoader, defaultFileName), StandardCharsets.UTF_8);
            BufferedReader buff = new BufferedReader(lecture);
            YamlConfiguration real = YamlConfiguration.loadConfiguration((Reader)buff);
            boolean isNotUpdate = false;
            if (real.isList(what)) {
                List object = real.getStringList(what);
                this.messagesArray.put(msgI, object.toArray(new String[0]));
                config.set(what, (Object)object);
            } else if (real.isString(what)) {
                String object = real.getString(what);
                this.messages.put(msgI, object);
                config.set(what, (Object)object);
            } else {
                isNotUpdate = true;
                this.messages.put(msgI, insert);
            }
            if (!isNotUpdate) {
                Utils.sendConsoleMsg("&eSCore &7Update of &6" + what + " &7in your for the plugin > &6" + pluginName + " &7in language: &6" + String.valueOf((Object)GeneralConfig.getInstance().getLocale()));
                config.save(pdFile);
            } else {
                Utils.sendConsoleMsg("&eSCore&c ERROR LOAD MESSAGE &6" + what + "&c for the plugin > &6" + pluginName + "&c in language: &6" + String.valueOf((Object)GeneralConfig.getInstance().getLocale()));
                if (msgI.getType() == TypeText.STRING) {
                    this.messages.put(msgI, msgI.getDefaultValueString());
                } else {
                    this.messagesArray.put(msgI, msgI.getDefaultValueArray());
                }
            }
            buff.close();
        }
        catch (Exception e) {
            Utils.sendConsoleMsg("&eSCore &cERROR LOAD MESSAGE &6" + what + " &cfor the plugin > &6" + pluginName + "&c in language: &6" + String.valueOf((Object)GeneralConfig.getInstance().getLocale()));
            e.printStackTrace();
        }
    }

    public String getText(TextInterface message) {
        if (this.messages.containsKey(message)) {
            return this.messages.get(message);
        }
        if (this.messagesArray.containsKey(message)) {
            String[] array = this.messagesArray.get(message);
            StringBuilder combine = new StringBuilder();
            for (String s : array) {
                combine.append(s).append("\n");
            }
            return combine.toString();
        }
        return "Can't load the string (" + message.getKey() + ") for the plugin > SCore in language: " + String.valueOf((Object)GeneralConfig.getInstance().getLocale()) + ", contact the developer";
    }

    public String[] getArray(TextInterface message) {
        if (this.messagesArray.containsKey(message)) {
            return this.messagesArray.get(message);
        }
        if (this.messages.containsKey(message)) {
            return new String[]{this.messages.get(message)};
        }
        return new String[]{"Can't load the string (" + message.getKey() + ") for the plugin > SCore in language: " + String.valueOf((Object)GeneralConfig.getInstance().getLocale()) + ", contact the developer"};
    }

    public static String g(TextInterface message) {
        return TM.getInstance().getText(message);
    }

    public static String[] gA(TextInterface message) {
        return TM.getInstance().getArray(message);
    }
}

