/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sobject;

import com.ssomar.executableitems.configs.Message;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObjectInterface;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SObject<X extends FeatureInterface<X, X>, Y extends GUI, Z extends NewGUIManager<Y>>
extends FeatureWithHisOwnEditor<X, X, Y, Z>
implements SObjectInterface {
    private SPlugin sPlugin;
    private String id;

    public SObject(SPlugin sPlugin, String id, FeatureSettingsInterface featureSettings) {
        super(null, featureSettings);
        this.sPlugin = sPlugin;
        this.id = id;
    }

    public SObject(SPlugin sPlugin, String id, FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.sPlugin = sPlugin;
        this.id = id;
    }

    public abstract boolean delete();

    @Override
    public String getId() {
        return this.id;
    }

    public SPlugin getPlugin() {
        return this.sPlugin;
    }

    public boolean hasPermission(@NotNull Player player, boolean showError) {
        if (player.isOp()) {
            return true;
        }
        String particle = this.sPlugin.getObjectNameForPermission(this);
        if (this.sPlugin.isLotOfWork()) {
            ArrayList<Object> permissionsToCheck = new ArrayList<Object>();
            permissionsToCheck.add(this.sPlugin.getName() + "." + particle + "." + this.getId());
            permissionsToCheck.add(this.sPlugin.getName() + "." + particle + ".*");
            permissionsToCheck.add(this.sPlugin.getShortName().toLowerCase() + "." + particle + "." + this.getId());
            permissionsToCheck.add(this.sPlugin.getShortName().toLowerCase() + "." + particle + ".*");
            permissionsToCheck.add("*");
            boolean hasPermission = false;
            for (String string : permissionsToCheck) {
                if (!player.hasPermission(string)) continue;
                hasPermission = true;
                break;
            }
            if (!hasPermission) {
                if (showError) {
                    new SendMessage().sendMessage(player, StringConverter.replaceVariable(MessageMain.getInstance().getMessage(this.sPlugin.getPlugin(), (MessageInterface)Message.REQUIRE_PERMISSION), player.getName(), this.getId(), "", 0));
                }
                return false;
            }
        } else {
            if (player.hasPermission("*")) {
                return true;
            }
            ArrayList<CallSite> permissionsToCheck = new ArrayList<CallSite>();
            permissionsToCheck.add((CallSite)((Object)(this.sPlugin.getName() + "." + particle + "." + this.getId())));
            permissionsToCheck.add((CallSite)((Object)(this.sPlugin.getName() + "." + particle + ".*")));
            permissionsToCheck.add((CallSite)((Object)(this.sPlugin.getShortName().toLowerCase() + "." + particle + "." + this.getId())));
            permissionsToCheck.add((CallSite)((Object)(this.sPlugin.getShortName().toLowerCase() + "." + particle + ".*")));
            boolean hasPermission = false;
            for (String string : permissionsToCheck) {
                if (!player.hasPermission(string)) continue;
                hasPermission = true;
                break;
            }
            ArrayList<CallSite> invertedPermissionsToCheck = new ArrayList<CallSite>();
            invertedPermissionsToCheck.add((CallSite)((Object)("-" + this.sPlugin.getName() + "." + particle + "." + this.getId())));
            invertedPermissionsToCheck.add((CallSite)((Object)("-" + this.sPlugin.getName() + "." + particle + ".*")));
            invertedPermissionsToCheck.add((CallSite)((Object)("-" + this.sPlugin.getShortName().toLowerCase() + "." + particle + "." + this.getId())));
            invertedPermissionsToCheck.add((CallSite)((Object)("-" + this.sPlugin.getShortName().toLowerCase() + "." + particle + ".*")));
            for (String string : invertedPermissionsToCheck) {
                if (!player.hasPermission(string)) continue;
                hasPermission = false;
                break;
            }
            if (!hasPermission) {
                if (showError) {
                    new SendMessage().sendMessage(player, StringConverter.replaceVariable(MessageMain.getInstance().getMessage(this.sPlugin.getPlugin(), (MessageInterface)Message.REQUIRE_PERMISSION), player.getName(), this.getId(), "", 0));
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public abstract List<FeatureInterface> getFeatures();

    @Override
    @Nullable
    public FeatureInterface getFeature(FeatureSettingsInterface featureSettings) {
        for (FeatureInterface feature : this.getFeatures()) {
            if (!feature.getFeatureSettings().equals(featureSettings)) continue;
            return feature;
        }
        return null;
    }

    @Generated
    public void setSPlugin(SPlugin sPlugin) {
        this.sPlugin = sPlugin;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

