/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sobject;

import com.ssomar.executableitems.configs.Message;
import com.ssomar.score.SCore;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class SObjectWithFile<X extends FeatureInterface<X, X>, Y extends GUI, Z extends NewGUIManager<Y>>
extends SObject<X, Y, Z> {
    private String path;
    private SObjectWithFileLoader sObjectWithFileLoader;
    private List<String> parentFoldersNames;

    public SObjectWithFile(SPlugin sPlugin, String id, FeatureSettingsInterface featureSettings, String path, SObjectWithFileLoader sObjectWithFileLoader) {
        super(sPlugin, id, null, featureSettings);
        this.path = path;
        this.sObjectWithFileLoader = sObjectWithFileLoader;
        this.parentFoldersNames = null;
    }

    public SObjectWithFile(SPlugin sPlugin, String id, FeatureParentInterface parent, FeatureSettingsInterface featureSettings, String path, SObjectWithFileLoader sObjectWithFileLoader) {
        super(sPlugin, id, parent, featureSettings);
        this.path = path;
        this.sObjectWithFileLoader = sObjectWithFileLoader;
        this.parentFoldersNames = null;
    }

    @Override
    public boolean delete() {
        File file = null;
        file = new File(this.getPath());
        if (file != null) {
            file.delete();
            return true;
        }
        return false;
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        File file = this.getFile();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        return config;
    }

    @Override
    public File getFile() {
        File file = new File(this.path);
        if (!file.exists()) {
            try {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                new File(this.path).createNewFile();
                file = this.sObjectWithFileLoader.searchFileOfObject(this.getId());
            }
            catch (IOException e) {
                Utils.sendConsoleMsg(SCore.plugin, "Error while creating a file: " + this.path);
                e.printStackTrace();
                return null;
            }
        }
        return file;
    }

    public List<String> getParentFoldersNames() {
        if (this.parentFoldersNames != null) {
            return this.parentFoldersNames;
        }
        ArrayList<String> folders = new ArrayList<String>();
        File file = this.getFile();
        SPlugin sPlugin = this.getPlugin();
        for (File parent = file.getParentFile(); parent != null && !parent.getName().equalsIgnoreCase(sPlugin.getName()); parent = parent.getParentFile()) {
            folders.add(parent.getName());
        }
        this.parentFoldersNames = new ArrayList<String>(folders);
        return folders;
    }

    @Override
    public boolean hasPermission(@NotNull Player player, boolean showError) {
        if (player.isOp()) {
            return true;
        }
        SPlugin sPlugin = this.getPlugin();
        String particle = sPlugin.getObjectNameForPermission(this);
        if (sPlugin.isLotOfWork()) {
            ArrayList<Object> permissionsToCheck = new ArrayList<Object>();
            permissionsToCheck.add(sPlugin.getName() + "." + particle + "." + this.getId());
            permissionsToCheck.add(sPlugin.getName() + "." + particle + ".*");
            permissionsToCheck.add(sPlugin.getShortName().toLowerCase() + "." + particle + "." + this.getId());
            permissionsToCheck.add(sPlugin.getShortName().toLowerCase() + "." + particle + ".*");
            permissionsToCheck.add(sPlugin.getName() + "." + particle + ".folder.*");
            permissionsToCheck.add(sPlugin.getShortName().toLowerCase() + "." + particle + ".folder.*");
            for (String string : this.getParentFoldersNames()) {
                permissionsToCheck.add(sPlugin.getName() + "." + particle + ".folder." + string);
                permissionsToCheck.add(sPlugin.getShortName().toLowerCase() + "." + particle + ".folder." + string);
            }
            permissionsToCheck.add("*");
            boolean hasPermission = false;
            for (String string : permissionsToCheck) {
                if (!player.hasPermission(string)) continue;
                hasPermission = true;
                break;
            }
            if (!hasPermission) {
                if (showError) {
                    new SendMessage().sendMessage(player, StringConverter.replaceVariable(MessageMain.getInstance().getMessage(sPlugin.getPlugin(), (MessageInterface)Message.REQUIRE_PERMISSION), player.getName(), this.getId(), "", 0));
                }
                return false;
            }
        } else {
            if (player.hasPermission("*")) {
                return true;
            }
            ArrayList<CallSite> permissionsToCheck = new ArrayList<CallSite>();
            permissionsToCheck.add((CallSite)((Object)(sPlugin.getName() + "." + particle + "." + this.getId())));
            permissionsToCheck.add((CallSite)((Object)(sPlugin.getName() + "." + particle + ".*")));
            permissionsToCheck.add((CallSite)((Object)(sPlugin.getShortName().toLowerCase() + "." + particle + "." + this.getId())));
            permissionsToCheck.add((CallSite)((Object)(sPlugin.getShortName().toLowerCase() + "." + particle + ".*")));
            permissionsToCheck.add((CallSite)((Object)(sPlugin.getName() + "." + particle + ".folder.*")));
            permissionsToCheck.add((CallSite)((Object)(sPlugin.getShortName().toLowerCase() + "." + particle + ".folder.*")));
            for (String string : this.getParentFoldersNames()) {
                permissionsToCheck.add((CallSite)((Object)(sPlugin.getName() + "." + particle + ".folder." + string)));
                permissionsToCheck.add((CallSite)((Object)(sPlugin.getShortName().toLowerCase() + "." + particle + ".folder." + string)));
            }
            boolean hasPermission = false;
            for (String string : permissionsToCheck) {
                if (!player.hasPermission(string)) continue;
                hasPermission = true;
                break;
            }
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            arrayList.add((CallSite)((Object)("-" + sPlugin.getName() + "." + particle + "." + this.getId())));
            arrayList.add((CallSite)((Object)("-" + sPlugin.getName() + "." + particle + ".*")));
            arrayList.add((CallSite)((Object)("-" + sPlugin.getShortName().toLowerCase() + "." + particle + "." + this.getId())));
            arrayList.add((CallSite)((Object)("-" + sPlugin.getShortName().toLowerCase() + "." + particle + ".*")));
            arrayList.add((CallSite)((Object)("-" + sPlugin.getName() + "." + particle + ".folder.*")));
            arrayList.add((CallSite)((Object)("-" + sPlugin.getShortName().toLowerCase() + "." + particle + ".folder.*")));
            for (String string : this.getParentFoldersNames()) {
                arrayList.add((CallSite)((Object)("-" + sPlugin.getName() + "." + particle + ".folder." + string)));
                arrayList.add((CallSite)((Object)("-" + sPlugin.getShortName().toLowerCase() + "." + particle + ".folder." + string)));
            }
            for (String string : arrayList) {
                if (!player.hasPermission(string)) continue;
                hasPermission = false;
                break;
            }
            if (!hasPermission) {
                if (showError) {
                    new SendMessage().sendMessage(player, StringConverter.replaceVariable(MessageMain.getInstance().getMessage(sPlugin.getPlugin(), (MessageInterface)Message.REQUIRE_PERMISSION), player.getName(), this.getId(), "", 0));
                }
                return false;
            }
        }
        return true;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public SObjectWithFileLoader getSObjectWithFileLoader() {
        return this.sObjectWithFileLoader;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setSObjectWithFileLoader(SObjectWithFileLoader sObjectWithFileLoader) {
        this.sObjectWithFileLoader = sObjectWithFileLoader;
    }

    @Generated
    public void setParentFoldersNames(List<String> parentFoldersNames) {
        this.parentFoldersNames = parentFoldersNames;
    }
}

