/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sobject.menu;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectEditable;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class SObjectsNoFileEditor<T extends SObject>
extends SObjectsEditorAbstract<T> {
    public SObjectsNoFileEditor(SPlugin sPlugin, FeatureSettingsInterface settings, SObjectManager manager) {
        super(sPlugin, settings, manager);
        this.load();
    }

    @Override
    public void load() {
        this.clearAndSetBackground();
        int i = 0;
        int total = 0;
        for (SObject object : this.getManager().getObjects(this.getComparator(), this.getPredicates())) {
            if ((index - 1) * 27 <= total && total < index * 27) {
                ItemStack itemS = ((SObjectEditable)((Object)object)).getIconItem();
                ArrayList<String> desc = new ArrayList<String>();
                desc.add("");
                desc.add(GUI.CLICK_HERE_TO_CHANGE);
                if (this.isGiveButton()) {
                    desc.add(TM.g(Text.EDITOR_GIVE_SHIFT_RIGHT_DESCRIPTION));
                }
                if (this.isDeleteButton()) {
                    desc.add(GUI.SHIFT_LEFT_CLICK_TO_REMOVE);
                }
                desc.addAll(((SObjectEditable)((Object)object)).getDescription());
                String[] descArray = new String[desc.size()];
                for (int j = 0; j < desc.size(); ++j) {
                    descArray[j] = ((String)desc.get(j)).length() > 40 ? ((String)desc.get(j)).substring(0, 39) + "..." : (String)desc.get(j);
                }
                this.createItem(itemS, 1, i, CREATION_ID + " &e&o" + object.getId(), false, false, descArray);
                ++i;
            }
            ++total;
        }
        if (this.getManager().getObjects().size() > 27 && index * 27 < this.getManager().getObjects().size()) {
            this.createItem(NEXT_PAGE_MAT, 1, 44, NEXT_PAGE, false, false, new String[0]);
        }
        if (index > 1) {
            this.createItem(PREVIOUS_PAGE_MAT, 1, 37, PREVIOUS_PAGE, false, false, new String[0]);
        }
        this.createItem(RED, 1, 36, EXIT, false, false, new String[0]);
        this.createItem(YELLOW, 1, 37, GUI.CHANGE_LANGUAGE, false, false, GeneralConfig.getInstance().getAvailableLocales("", "&e&oClick here to change the language"));
        String[] desc = new String[1 + TM.gA(Text.EDITOR_PATH_DESCRIPTION).length];
        desc[0] = "&7";
        System.arraycopy(TM.gA(Text.EDITOR_PATH_DESCRIPTION), 0, desc, 1, TM.gA(Text.EDITOR_PATH_DESCRIPTION).length);
        if (this.isPathButton()) {
            this.createItem(Material.ANVIL, 1, 38, TM.g(Text.EDITOR_PATH_NAME), false, false, desc);
        }
        if (this.isNewButton()) {
            this.createItem(GREEN, 1, 40, NEW + " " + this.getManager().getObjectName(), false, false, new String[0]);
        }
        if (this.isDefaultObjectsButton()) {
            if (this.getSPlugin().isLotOfWork()) {
                this.createItem(PURPLE, 1, 43, TM.g(Text.EDITOR_PREMADE_PREMIUM_NAME).replace("%object%", this.getManager().getObjectName()), false, false, new String[0]);
            } else {
                this.createItem(PURPLE, 1, 43, TM.g(Text.EDITOR_PREMADE_PACKS_NAME).replace("%object%", this.getManager().getObjectName()), false, false, new String[0]);
            }
        }
    }

    @Override
    public void goToFolder(String folder) {
    }

    @Override
    public void goBack() {
    }

    @Override
    public SObjectWithFileLoader getLoader() {
        return null;
    }
}

