/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.ssomar.score.SCore;
import com.ssomar.score.usedapi.Dependency;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class WorldGuardAPI {
    public static boolean playerCanBreakInRegion(@NotNull UUID pUUID, @NotNull Location location) {
        if (SCore.is1v12Less()) {
            return true;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapOfflinePlayer(Bukkit.getServer().getOfflinePlayer(pUUID));
        com.sk89q.worldedit.util.Location loc = new com.sk89q.worldedit.util.Location((Extent)BukkitAdapter.adapt((World)location.getWorld()), location.getX(), location.getY(), location.getZ());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        StateFlag[] conditions = new StateFlag[]{Flags.BLOCK_BREAK};
        return query.testBuild(loc, localPlayer, conditions);
    }

    public static boolean playerCanPlaceInRegion(@NotNull UUID pUUID, @NotNull Location location) {
        if (SCore.is1v12Less()) {
            return true;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapOfflinePlayer(Bukkit.getServer().getOfflinePlayer(pUUID));
        com.sk89q.worldedit.util.Location loc = new com.sk89q.worldedit.util.Location((Extent)BukkitAdapter.adapt((World)location.getWorld()), location.getX(), location.getY(), location.getZ());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        StateFlag[] conditions = new StateFlag[]{Flags.BLOCK_PLACE};
        return query.testBuild(loc, localPlayer, conditions);
    }

    public static boolean playerCanOpenInRegion(@NotNull UUID pUUID, @NotNull Location location) {
        if (SCore.is1v12Less()) {
            return true;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapOfflinePlayer(Bukkit.getServer().getOfflinePlayer(pUUID));
        com.sk89q.worldedit.util.Location loc = new com.sk89q.worldedit.util.Location((Extent)BukkitAdapter.adapt((World)location.getWorld()), location.getX(), location.getY(), location.getZ());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        StateFlag[] conditions = new StateFlag[]{Flags.CHEST_ACCESS};
        return query.testBuild(loc, localPlayer, conditions);
    }

    public static boolean isInPvpZone(Player p, Location location) {
        StateFlag.State state;
        if (SCore.is1v12Less()) {
            return true;
        }
        com.sk89q.worldedit.util.Location loc = new com.sk89q.worldedit.util.Location((Extent)BukkitAdapter.adapt((World)location.getWorld()), location.getX(), location.getY(), location.getZ());
        boolean isPVP = true;
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(loc);
        int allowMaxPriority = Integer.MIN_VALUE;
        for (ProtectedRegion region : set) {
            if (region == null || (state = (StateFlag.State)region.getFlag((Flag)Flags.PVP)) == null || !state.equals((Object)StateFlag.State.ALLOW) || allowMaxPriority >= region.getPriority()) continue;
            allowMaxPriority = region.getPriority();
        }
        for (ProtectedRegion region : set) {
            if (region == null || (state = (StateFlag.State)region.getFlag((Flag)Flags.PVP)) == null || !state.equals((Object)StateFlag.State.DENY) || region.getPriority() <= allowMaxPriority) continue;
            isPVP = false;
            break;
        }
        return isPVP;
    }

    public boolean canBuild(@NotNull Player p, Location location) {
        if (SCore.is1v12Less()) {
            return true;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(p);
        com.sk89q.worldedit.util.Location loc = new com.sk89q.worldedit.util.Location((Extent)BukkitAdapter.adapt((World)location.getWorld()), location.getX(), location.getY(), location.getZ());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        StateFlag[] conditions = new StateFlag[]{Flags.BLOCK_BREAK};
        return query.testBuild(loc, localPlayer, conditions);
    }

    public boolean isInRegion(Player p, String name) {
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)p.getLocation());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(BukkitAdapter.adapt((World)p.getWorld()));
        if (regions == null) {
            return false;
        }
        ApplicableRegionSet set = regions.getApplicableRegions(loc.toVector().toBlockPoint());
        for (ProtectedRegion region : set) {
            if (!region.getId().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInRegionWithKeepInventory(Player p) {
        if (!Dependency.WORLD_GUARD_EXTRA_FLAGS.isEnabled()) {
            return false;
        }
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)p.getLocation());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(BukkitAdapter.adapt((World)p.getWorld()));
        if (regions == null) {
            return false;
        }
        ApplicableRegionSet set = regions.getApplicableRegions(loc.toVector().toBlockPoint());
        for (ProtectedRegion region : set) {
            boolean keepInv = (Boolean)region.getFlag((Flag)net.goldtreeservers.worldguardextraflags.flags.Flags.KEEP_INVENTORY);
            if (!keepInv) continue;
            return true;
        }
        return false;
    }

    public boolean isInRegion(Player p, List<String> names) {
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)p.getLocation());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(BukkitAdapter.adapt((World)p.getWorld()));
        if (regions == null) {
            return false;
        }
        ApplicableRegionSet set = regions.getApplicableRegions(loc.toVector().toBlockPoint());
        for (String name : names) {
            for (ProtectedRegion region : set) {
                if (!region.getId().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }
}

