/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.display;

import com.ssomar.score.SCore;
import com.ssomar.score.utils.display.DisplayModule;
import com.ssomar.score.utils.display.DisplayProperties;
import com.ssomar.score.utils.display.DisplayRequestResult;
import com.ssomar.score.utils.display.DisplayResult;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Display {
    public static final String PREFIX = StringConverter.coloredString("&z");
    private static final Map<Integer, List<DisplayModule>> REGISTERED_MODULES = new TreeMap<Integer, List<DisplayModule>>();
    private static final NamespacedKey FINALIZE_KEY = new NamespacedKey((Plugin)SCore.plugin, "finalized");

    public static DisplayRequestResult display(@NotNull ItemStack itemStack) {
        return Display.display(itemStack, null);
    }

    public static boolean isSomethingToModify() {
        for (List<DisplayModule> modules : REGISTERED_MODULES.values()) {
            for (DisplayModule module : modules) {
                if (module.getLoadedIDs().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static DisplayRequestResult display(@NotNull ItemStack itemStack, @Nullable Player player) {
        if (itemStack.getType() == Material.AIR || !itemStack.hasItemMeta()) {
            return new DisplayRequestResult(itemStack, DisplayResult.NOT_MODIFIED);
        }
        ItemStack original = itemStack.clone();
        PlayerInventory inventory = player == null ? null : player.getInventory();
        boolean inInventory = inventory != null && !inventory.isEmpty() && inventory.contains(original);
        boolean inGui = false;
        DisplayProperties properties = new DisplayProperties(inInventory, inGui, original);
        boolean modified = false;
        for (List<DisplayModule> modules : REGISTERED_MODULES.values()) {
            for (DisplayModule module : modules) {
                boolean bl = modified = module.display(itemStack) || modified;
                if (player == null) continue;
                modified = module.display(itemStack, player) || modified;
                modified = module.display(itemStack, player, properties) || modified;
            }
        }
        DisplayResult result = modified ? DisplayResult.MODIFIED : DisplayResult.NOT_MODIFIED;
        return new DisplayRequestResult(itemStack, result);
    }

    public static ItemStack displayAndFinalize(@NotNull ItemStack itemStack) {
        return Display.finalize(Display.display(itemStack, null).getItemStack());
    }

    public static ItemStack displayAndFinalize(@NotNull ItemStack itemStack, @Nullable Player player) {
        return Display.finalize(Display.display(itemStack, player).getItemStack());
    }

    public static ItemStack revert(@NotNull ItemStack itemStack) {
        ItemStack fast;
        ItemMeta meta;
        if (Display.isFinalized(itemStack)) {
            Display.unfinalize(itemStack);
        }
        if (!(meta = (fast = itemStack).getItemMeta()).hasLore()) {
            return itemStack;
        }
        List lore = meta.getLore();
        if (!lore.isEmpty() && lore.removeIf(line -> line.startsWith(StringConverter.coloredString(PREFIX)))) {
            meta.setLore(lore);
            fast.setItemMeta(meta);
        }
        for (List<DisplayModule> modules : REGISTERED_MODULES.values()) {
            for (DisplayModule module : modules) {
                module.revert(itemStack);
            }
        }
        return itemStack;
    }

    public static ItemStack finalize(@NotNull ItemStack itemStack) {
        if (itemStack.getType().getMaxStackSize() > 1) {
            return itemStack;
        }
        ItemMeta meta = itemStack.getItemMeta();
        meta.getPersistentDataContainer().set(FINALIZE_KEY, PersistentDataType.INTEGER, (Object)1);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack unfinalize(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.getPersistentDataContainer().remove(FINALIZE_KEY);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static boolean isFinalized(@NotNull ItemStack itemStack) {
        return itemStack.getItemMeta().getPersistentDataContainer().has(FINALIZE_KEY, PersistentDataType.INTEGER);
    }

    public static void registerDisplayModule(@NotNull DisplayModule module) {
        List modules = REGISTERED_MODULES.getOrDefault(module.getWeight(), new ArrayList());
        modules.removeIf(it -> it.getPluginName().equalsIgnoreCase(module.getPluginName()));
        modules.add(module);
        REGISTERED_MODULES.put(module.getWeight(), modules);
    }

    private Display() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

