/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.placeholders;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.utils.placeholders.PlaceholdersInterface;
import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;

public class ProjectilePlaceholders
extends PlaceholdersInterface
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Projectile projectile;
    private UUID projectileUUID;
    private String projectileType = "";
    private String projectileName = "";
    private double projectileX;
    private double projectileY;
    private double projectileZ;
    private String projectileBlockFace = null;
    private String projectileWorld = "";

    public void setProjectilePlcHldr(Projectile projectile, String blockFace) {
        this.projectile = projectile;
        this.projectileUUID = projectile.getUniqueId();
        this.projectileBlockFace = blockFace;
        this.reloadProjectilePlcHldr();
    }

    public void reloadProjectilePlcHldr() {
        if (this.projectile != null || this.projectileUUID != null) {
            Object entity = this.projectile != null ? this.projectile : (SCore.is1v11Less() ? this.getEntityByUniqueId(this.projectileUUID) : Bukkit.getEntity((UUID)this.projectileUUID));
            SsomarDev.testMsg("entity : " + String.valueOf(entity), true);
            if (entity != null) {
                this.projectileType = entity.getType().toString();
                this.projectileName = entity.getName();
                Location eLoc = entity.getLocation();
                this.projectileX = eLoc.getX();
                this.projectileY = eLoc.getY();
                this.projectileZ = eLoc.getZ();
                this.projectileWorld = eLoc.getWorld().getName();
            }
        }
    }

    public Entity getEntityByUniqueId(UUID uniqueId) {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.getUniqueId().equals(uniqueId)) continue;
                return entity;
            }
        }
        return null;
    }

    public String replacePlaceholder(String s) {
        String toReplace = s;
        if (this.projectileUUID != null) {
            toReplace = toReplace.replaceAll("%projectile%", this.projectileType);
            toReplace = toReplace.replaceAll("%projectile_lower_case%", this.projectileType.toLowerCase());
            toReplace = toReplace.replaceAll("%projectile_name%", this.projectileName);
            toReplace = toReplace.replaceAll("%projectile_name_lower_case%", this.projectileName.toLowerCase());
            toReplace = toReplace.replaceAll("%projectile_uuid%", this.projectileUUID.toString());
            toReplace = toReplace.replaceAll("%projectile_uuid_array%", ProjectilePlaceholders.convertedUUID(this.projectileUUID));
            toReplace = ProjectilePlaceholders.replaceCalculPlaceholder(toReplace, "%projectile_x%", "" + this.projectileX, false);
            toReplace = ProjectilePlaceholders.replaceCalculPlaceholder(toReplace, "%projectile_y%", "" + this.projectileY, false);
            toReplace = ProjectilePlaceholders.replaceCalculPlaceholder(toReplace, "%projectile_z%", "" + this.projectileZ, false);
            toReplace = ProjectilePlaceholders.replaceCalculPlaceholder(toReplace, "%projectile_x_int%", "" + (int)this.projectileX, true);
            toReplace = ProjectilePlaceholders.replaceCalculPlaceholder(toReplace, "%projectile_y_int%", "" + (int)this.projectileY, true);
            toReplace = ProjectilePlaceholders.replaceCalculPlaceholder(toReplace, "%projectile_z_int%", "" + (int)this.projectileZ, true);
            toReplace = toReplace.replaceAll("%projectileworld%", this.projectileWorld);
            toReplace = toReplace.replaceAll("%projectile_world%", this.projectileWorld);
            toReplace = toReplace.replaceAll("%projectile_world_lower%", this.projectileWorld.toLowerCase());
            if (!this.projectileBlockFace.equals("")) {
                toReplace = toReplace.replaceAll("%projectile_blockface%", this.projectileBlockFace.toUpperCase());
                toReplace = toReplace.replaceAll("%projectile_blockface_lower%", this.projectileBlockFace.toLowerCase());
            }
        }
        return toReplace;
    }

    public static String convertedUUID(UUID uuid) {
        StringBuilder sb = new StringBuilder();
        sb.append("[I;");
        String uuidStr = uuid.toString().replaceAll("-", "").toUpperCase();
        sb.append(ProjectilePlaceholders.getDecimal(uuidStr.substring(0, 8)));
        sb.append(",");
        sb.append(ProjectilePlaceholders.getDecimal(uuidStr.substring(8, 16)));
        sb.append(",");
        sb.append(ProjectilePlaceholders.getDecimal(uuidStr.substring(16, 24)));
        sb.append(",");
        sb.append(ProjectilePlaceholders.getDecimal(uuidStr.substring(24, 32)));
        sb.append("]");
        return sb.toString();
    }

    public static int getDecimal(String hex) {
        String digits = "0123456789ABCDEF";
        hex = hex.toUpperCase();
        int val2 = 0;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            int d = digits.indexOf(c);
            val2 = 16 * val2 + d;
        }
        return val2;
    }

    @Generated
    public String getProjectileBlockFace() {
        return this.projectileBlockFace;
    }

    @Generated
    public void setProjectileBlockFace(String projectileBlockFace) {
        this.projectileBlockFace = projectileBlockFace;
    }
}

