/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.strings;

import com.ssomar.score.SCore;
import com.ssomar.score.utils.strings.StringUtils;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatColor;

public class StringConverter {
    public static final char COLOR_CHAR = '\u00a7';
    public static final Pattern HEX_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");

    public static String coloredString(String s) {
        return StringConverter.coloredString(s, false);
    }

    public static String coloredString(String s, boolean bypassNoColor) {
        if (!bypassNoColor && s.contains("NO_COLOR")) {
            return s.replaceAll("NO_COLOR", "").trim();
        }
        String[] keys = new String[]{"& ", "&"};
        String[] values = new String[]{"|<-_->|", "\u00a7"};
        String convert = StringUtils.replaceEach(s, keys, values);
        convert = convert.replaceAll("\\|<-_->\\|", "& ");
        try {
            convert = LegacyComponentSerializer.legacySection().serialize(MiniMessage.miniMessage().deserialize((Object)convert));
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        if (SCore.is1v16Plus()) {
            convert = StringConverter.translateHexCodes(convert);
        }
        return convert;
    }

    public static List<String> coloredString(List<String> list) {
        ArrayList<String> convert = new ArrayList<String>();
        for (String s : list) {
            convert.add(StringConverter.coloredString(s));
        }
        return convert;
    }

    public static List<String> replaceVariable(List<String> list, String player, String item, String quantity, int time) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : list) {
            newList.add(StringConverter.replaceVariable(s, player, item, quantity, time));
        }
        return newList;
    }

    public static String replaceVariable(String s, String player, String item, String quantity, int time) {
        String convert = s;
        String convertItem = item;
        String convertPlayer = player;
        if (!convert.isEmpty()) {
            if ((convert = convert.replace("$", "REGEX-DOLARS")).charAt(0) == '/') {
                convert = convert.replaceFirst("/", "");
            }
            convertItem = convertItem.replace("$", "REGEX-DOLARS");
            convertPlayer = convertPlayer.replace("$", "REGEX-DOLARS");
            convert = convert.replaceAll("%player%", convertPlayer);
            convert = convert.replaceAll("%item%", convertItem);
            convert = convert.replaceAll("%quantity%", quantity);
            convert = convert.replaceAll("REGEX-DOLARS", "\\$");
            int M = time / 60;
            int S = time % 60;
            int H = M / 60;
            convert = convert.replaceAll("%time%", H + "H " + (M %= 60) + "M " + S + "S");
        }
        return convert;
    }

    public static List<String> decoloredString(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            result.add(StringConverter.decoloredString(s));
        }
        return result;
    }

    public static String decoloredString(String s) {
        String convert = StringConverter.replaceHexCodes(s);
        StringBuilder sb = new StringBuilder();
        char[] sChar = convert.toCharArray();
        boolean isAnd = false;
        for (int i = 0; i < sChar.length; ++i) {
            if (isAnd) {
                if (sChar[i] == ' ') {
                    sb.append("& ");
                }
                isAnd = false;
                continue;
            }
            if (sChar[i] == '&') {
                isAnd = true;
                continue;
            }
            if (sChar[i] == '\u00a7') {
                ++i;
                continue;
            }
            sb.append(sChar[i]);
        }
        return StringConverter.removeHexCodes(sb.toString());
    }

    public static List<String> deconvertColor(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            result.add(StringConverter.deconvertColor(s));
        }
        return result;
    }

    public static String deconvertColor(String s) {
        char[] sChar;
        if (s == null || s.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : sChar = s.toCharArray()) {
            if (c == '\u00a7') {
                sb.append('&');
                continue;
            }
            sb.append(c);
        }
        return StringConverter.replaceHexCodes(sb.toString());
    }

    public static String translateHexCodes(String textToTranslate) {
        if (textToTranslate.contains("BRUT_HEX")) {
            textToTranslate = textToTranslate.replaceAll("\u00a7", "&");
            return textToTranslate.replaceAll("BRUT_HEX", "").trim();
        }
        String convert = textToTranslate;
        convert = convert.replaceAll("\u00a7#", "#");
        Matcher matcher = HEX_PATTERN.matcher(convert);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String color = convert.substring(matcher.start(), matcher.end());
            StringBuilder newColor = new StringBuilder("\u00a7x");
            for (char c : color.toCharArray()) {
                if (c == '#') continue;
                newColor.append("\u00a7").append(c);
            }
            convert = convert.replace(color, newColor);
            matcher = HEX_PATTERN.matcher(convert);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(buffer).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceHexCodes(String s) {
        void var9_11;
        String textToTranslate = s;
        boolean start1 = false;
        boolean startValid = false;
        boolean requireET = false;
        boolean requireLetter = false;
        ArrayList<CallSite> hexCode = new ArrayList<CallSite>();
        char[] cArray = textToTranslate.toCharArray();
        int n = cArray.length;
        boolean bl = false;
        while (var9_11 < n) {
            char c = cArray[var9_11];
            if (c == '&') {
                if (!startValid) {
                    start1 = true;
                }
                if (requireET) {
                    requireLetter = true;
                    requireET = false;
                } else if (requireLetter) {
                    startValid = false;
                }
            } else {
                if (start1) {
                    if (c == 'x') {
                        startValid = true;
                        requireET = true;
                    }
                } else if (requireET) {
                    startValid = false;
                } else if (requireLetter && startValid) {
                    hexCode.add((CallSite)((Object)("" + c)));
                    if (hexCode.size() == 6) break;
                    requireET = true;
                    requireLetter = false;
                }
                start1 = false;
            }
            ++var9_11;
        }
        if (hexCode.size() == 6) {
            StringBuilder toReplace = new StringBuilder("&x");
            for (String string : hexCode) {
                toReplace.append("&").append(string);
            }
            StringBuilder replacement = new StringBuilder("#");
            for (String string : hexCode) {
                replacement.append(string);
            }
            textToTranslate = textToTranslate.replaceAll(toReplace.toString(), replacement.toString());
            textToTranslate = StringConverter.replaceHexCodes(textToTranslate);
        }
        return textToTranslate;
    }

    public static String removeHexCodes(String textToTranslate) {
        Matcher matcher = HEX_PATTERN.matcher(textToTranslate);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String color = textToTranslate.substring(matcher.start(), matcher.end());
            textToTranslate = textToTranslate.replace(color, "");
            matcher = HEX_PATTERN.matcher(textToTranslate);
        }
        return matcher.appendTail(buffer).toString();
    }

    public static void main(String[] args) {
        String s = "#44D800&lPioche \u00e0 spawner #35A800";
        s = StringConverter.removeHexCodes(s);
        System.out.println(s);
    }

    public static Date stringToDate(String stringDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        try {
            date = formatter.parse(stringDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }
}

