/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.RunCommand;
import com.ssomar.score.commands.runnable.block.BlockRunCommand;
import com.ssomar.score.commands.runnable.entity.EntityRunCommand;
import com.ssomar.score.commands.runnable.player.PlayerRunCommand;
import com.ssomar.score.data.BlockCommandsQuery;
import com.ssomar.score.data.Database;
import com.ssomar.score.data.EntityCommandsQuery;
import com.ssomar.score.data.PlayerCommandsQuery;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandsHandler
implements Listener {
    private static CommandsHandler instance;
    private final Map<UUID, RunCommand> delayedCommandsByRcUuid = new HashMap<UUID, RunCommand>();
    private final Map<UUID, List<RunCommand>> delayedCommandsByReceiverUuid = new HashMap<UUID, List<RunCommand>>();
    List<BlockRunCommand> delayedCommandsByBlockUuid = new ArrayList<BlockRunCommand>();
    private Map<Player, Long> stopPickup = new HashMap<Player, Long>();
    private Map<Player, List<Material>> stopPickupMaterial = new HashMap<Player, List<Material>>();
    private Map<UUID, List<PlayerRunCommand>> delayedCommandsSaved = new HashMap<UUID, List<PlayerRunCommand>>();
    static int i;

    public static CommandsHandler getInstance() {
        if (instance == null) {
            instance = new CommandsHandler();
        }
        return instance;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void PlayerJoinEvent(PlayerJoinEvent e) {
        if (!SCore.pluginHolder.isEnabled()) {
            return;
        }
        Player p = e.getPlayer();
        if (CommandsHandler.getInstance().getDelayedCommandsSaved().containsKey(p.getUniqueId())) {
            for (PlayerRunCommand command : CommandsHandler.getInstance().getDelayedCommandsSaved().get(p.getUniqueId())) {
                command.run();
                Utils.sendConsoleMsg("&eSCore &7SCore will execute the delayed command saved for &a" + p.getName() + " &7: &6" + command.getBrutCommand() + " &7>> delay: &b" + command.getDelay());
            }
        }
        CommandsHandler.getInstance().getDelayedCommandsSaved().remove(p.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void PlayerQuitEvent(PlayerQuitEvent e) {
        if (!SCore.pluginHolder.isEnabled()) {
            return;
        }
        Player p = e.getPlayer();
        List<PlayerRunCommand> commands = CommandsHandler.getInstance().getDelayedCommandsWithPlayerReceiver(p.getUniqueId());
        ArrayList<PlayerRunCommand> commandsToSave = new ArrayList<PlayerRunCommand>();
        for (PlayerRunCommand command : commands) {
            if (command.isRunOffline() || command.isClearIfDisconnect()) continue;
            commandsToSave.add(command);
        }
        if (CommandsHandler.getInstance().getDelayedCommandsSaved().containsKey(p.getUniqueId())) {
            CommandsHandler.getInstance().getDelayedCommandsSaved().get(p.getUniqueId()).addAll(commandsToSave);
        } else {
            CommandsHandler.getInstance().getDelayedCommandsSaved().put(p.getUniqueId(), commandsToSave);
        }
        for (PlayerRunCommand command : commandsToSave) {
            CommandsHandler.getInstance().removeDelayedCommand(command.getUuid(), p.getUniqueId());
        }
    }

    public void onEnable() {
        CommandsHandler.getInstance().setDelayedCommandsSaved(PlayerCommandsQuery.loadSavedCommands(Database.getInstance().connect()));
        int cpt = 0;
        for (UUID uUID : CommandsHandler.getInstance().getDelayedCommandsSaved().keySet()) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uUID);
            for (PlayerRunCommand command : CommandsHandler.getInstance().getDelayedCommandsSaved().get(uUID)) {
                Utils.sendConsoleMsg("&eSCore &7SCore loaded the delayed command for &a" + player.getName() + " &7: &6" + command.getBrutCommand() + " &7>> delay: &b" + command.getDelay());
                ++cpt;
            }
        }
        Utils.sendConsoleMsg("&eSCore &7SCore loaded &6" + cpt + " &7delayed commands saved");
        List<EntityRunCommand> commands = EntityCommandsQuery.selectEntityCommands(Database.getInstance().connect());
        for (EntityRunCommand eCommand : commands) {
            eCommand.run();
        }
        EntityCommandsQuery.deleteEntityCommands(Database.getInstance().connect(true));
        List<BlockRunCommand> list = BlockCommandsQuery.selectAllCommands(Database.getInstance().connect());
        for (BlockRunCommand bCommand : list) {
            bCommand.run();
        }
        BlockCommandsQuery.deleteCommands(Database.getInstance().connect(true));
    }

    public void onDisable() {
        ArrayList<PlayerRunCommand> savedCommands = new ArrayList<PlayerRunCommand>(CommandsHandler.getInstance().getDelayedPlayerCommands());
        for (UUID uuid : CommandsHandler.getInstance().getDelayedCommandsSaved().keySet()) {
            savedCommands.addAll((Collection<PlayerRunCommand>)CommandsHandler.getInstance().getDelayedCommandsSaved().get(uuid));
        }
        for (PlayerRunCommand command : savedCommands) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)command.getReceiverUUID());
            Utils.sendConsoleMsg("&eSCore &7SCore saved the delayed command for &a" + player.getName() + " &7: &6" + command.getBrutCommand() + " &7>> delay: &b" + command.getDelay());
        }
        PlayerCommandsQuery.deleteCommands(Database.getInstance().connect());
        PlayerCommandsQuery.insertCommand(Database.getInstance().connect(), savedCommands, false);
        CommandsHandler.getInstance().getDelayedCommandsSaved().clear();
        EntityCommandsQuery.insertCommand(Database.getInstance().connect(), this.getDelayedEntityCommands());
        BlockCommandsQuery.insertCommand(Database.getInstance().connect(), this.delayedCommandsByBlockUuid);
        this.delayedCommandsByBlockUuid.clear();
        this.delayedCommandsByReceiverUuid.clear();
    }

    public void addDelayedCommand(@NotNull RunCommand command) {
        this.delayedCommandsByRcUuid.put(command.getUuid(), command);
        if (command instanceof PlayerRunCommand) {
            UUID receiverUUID = ((PlayerRunCommand)command).getReceiverUUID();
            if (this.delayedCommandsByReceiverUuid.containsKey(receiverUUID)) {
                this.delayedCommandsByReceiverUuid.get(receiverUUID).add(command);
            } else {
                ArrayList<RunCommand> list = new ArrayList<RunCommand>();
                list.add(command);
                this.delayedCommandsByReceiverUuid.put(((PlayerRunCommand)command).getReceiverUUID(), list);
            }
        } else if (command instanceof EntityRunCommand) {
            UUID receiverUUID = ((EntityRunCommand)command).getEntityUUID();
            if (this.delayedCommandsByReceiverUuid.containsKey(receiverUUID)) {
                this.delayedCommandsByReceiverUuid.get(receiverUUID).add(command);
            } else {
                ArrayList<RunCommand> list = new ArrayList<RunCommand>();
                list.add(command);
                this.delayedCommandsByReceiverUuid.put(((EntityRunCommand)command).getEntityUUID(), list);
            }
        } else if (command instanceof BlockRunCommand) {
            this.delayedCommandsByBlockUuid.add((BlockRunCommand)command);
        }
    }

    public void removeDelayedCommand(UUID uuid, @Nullable UUID receiverUUID) {
        this.removeDelayedCommand(uuid, receiverUUID, true);
    }

    public void removeDelayedCommand(UUID uuid, @Nullable UUID receiverUUID, boolean canceltask) {
        if (this.delayedCommandsByRcUuid.containsKey(uuid)) {
            ScheduledTask task = this.delayedCommandsByRcUuid.get(uuid).getTask();
            if (task != null && canceltask) {
                task.cancel();
            }
            this.delayedCommandsByRcUuid.remove(uuid);
        }
        RunCommand toDelete = null;
        for (RunCommand runCommand : this.delayedCommandsByBlockUuid) {
            if (!runCommand.getUuid().equals(uuid)) continue;
            toDelete = runCommand;
            ScheduledTask task = runCommand.getTask();
            if (task == null || !canceltask) continue;
            task.cancel();
        }
        if (toDelete != null) {
            this.delayedCommandsByBlockUuid.remove(toDelete);
        }
        if (receiverUUID != null && this.delayedCommandsByReceiverUuid.containsKey(receiverUUID)) {
            List<RunCommand> runCommands = this.delayedCommandsByReceiverUuid.get(receiverUUID);
            toDelete = null;
            for (RunCommand rC : runCommands) {
                if (!rC.getUuid().equals(uuid)) continue;
                toDelete = rC;
                ScheduledTask task = rC.getTask();
                if (task == null || !canceltask) continue;
                task.cancel();
            }
            if (toDelete != null) {
                runCommands.remove(toDelete);
            }
            if (runCommands.isEmpty()) {
                this.delayedCommandsByReceiverUuid.remove(receiverUUID);
            }
        }
    }

    public void removeAllDelayedCommands(UUID receiverUUID) {
        if (this.delayedCommandsByReceiverUuid.containsKey(receiverUUID)) {
            List<RunCommand> runCommands = this.delayedCommandsByReceiverUuid.get(receiverUUID);
            for (RunCommand rC : runCommands) {
                this.removeDelayedCommand(rC.getUuid(), null);
            }
            this.delayedCommandsByReceiverUuid.remove(receiverUUID);
        }
    }

    public List<PlayerRunCommand> getDelayedCommandsWithPlayerReceiver(UUID receiverUUID) {
        ArrayList<PlayerRunCommand> commands = new ArrayList<PlayerRunCommand>();
        if (this.delayedCommandsByReceiverUuid.containsKey(receiverUUID)) {
            List<RunCommand> runCommands = this.delayedCommandsByReceiverUuid.get(receiverUUID);
            for (RunCommand rC : runCommands) {
                if (!(rC instanceof PlayerRunCommand)) continue;
                commands.add((PlayerRunCommand)rC);
            }
        }
        ++i;
        return commands;
    }

    public List<PlayerRunCommand> getDelayedPlayerCommands() {
        ArrayList<PlayerRunCommand> commands = new ArrayList<PlayerRunCommand>();
        for (List<RunCommand> runCommands : CommandsHandler.getInstance().getDelayedCommandsByReceiverUuid().values()) {
            for (RunCommand rC : runCommands) {
                if (!(rC instanceof PlayerRunCommand)) continue;
                commands.add((PlayerRunCommand)rC);
            }
        }
        return commands;
    }

    public List<EntityRunCommand> getDelayedEntityCommands() {
        ArrayList<EntityRunCommand> commands = new ArrayList<EntityRunCommand>();
        for (List<RunCommand> runCommands : CommandsHandler.getInstance().getDelayedCommandsByReceiverUuid().values()) {
            for (RunCommand rC : runCommands) {
                if (!(rC instanceof EntityRunCommand)) continue;
                commands.add((EntityRunCommand)rC);
            }
        }
        return commands;
    }

    public void addStopPickup(Player p, Integer delay) {
        if (p == null) {
            return;
        }
        long time = System.currentTimeMillis() + (long)(delay * 50);
        this.stopPickup.put(p, time);
        Runnable runnable = () -> {
            if (this.stopPickup.containsKey(p) && this.stopPickup.get(p) == time) {
                this.stopPickup.remove(p);
            }
        };
        SCore.schedulerHook.runEntityTask(runnable, null, (Entity)p, delay.intValue());
    }

    public void addStopPickup(Player p, Integer delay, Material material) {
        if (p == null) {
            return;
        }
        if (this.stopPickupMaterial.containsKey(p)) {
            this.stopPickupMaterial.get(p).add(material);
        } else {
            ArrayList<Material> list = new ArrayList<Material>();
            list.add(material);
            this.stopPickupMaterial.put(p, list);
        }
        Runnable runnable = () -> {
            if (this.stopPickupMaterial.containsKey(p) && this.stopPickupMaterial.get(p).contains(material)) {
                this.stopPickupMaterial.get(p).remove(material);
            }
        };
        SCore.schedulerHook.runEntityTask(runnable, null, (Entity)p, delay.intValue());
    }

    public boolean hasStopPickup(@NotNull Player p) {
        long time = System.currentTimeMillis();
        if (this.stopPickup.containsKey(p)) {
            boolean stop;
            boolean bl = stop = this.stopPickup.get(p) > time;
            if (!stop) {
                this.stopPickup.remove(p);
            }
            return stop;
        }
        return false;
    }

    public boolean hasStopPickup(@NotNull Player p, Material material) {
        return this.stopPickupMaterial.containsKey(p) && this.stopPickupMaterial.get(p).contains(material);
    }

    @Generated
    public Map<UUID, RunCommand> getDelayedCommandsByRcUuid() {
        return this.delayedCommandsByRcUuid;
    }

    @Generated
    public Map<UUID, List<RunCommand>> getDelayedCommandsByReceiverUuid() {
        return this.delayedCommandsByReceiverUuid;
    }

    @Generated
    public List<BlockRunCommand> getDelayedCommandsByBlockUuid() {
        return this.delayedCommandsByBlockUuid;
    }

    @Generated
    public Map<Player, List<Material>> getStopPickupMaterial() {
        return this.stopPickupMaterial;
    }

    @Generated
    public Map<UUID, List<PlayerRunCommand>> getDelayedCommandsSaved() {
        return this.delayedCommandsSaved;
    }

    @Generated
    public void setDelayedCommandsByBlockUuid(List<BlockRunCommand> delayedCommandsByBlockUuid) {
        this.delayedCommandsByBlockUuid = delayedCommandsByBlockUuid;
    }

    @Generated
    public void setStopPickupMaterial(Map<Player, List<Material>> stopPickupMaterial) {
        this.stopPickupMaterial = stopPickupMaterial;
    }

    @Generated
    public void setDelayedCommandsSaved(Map<UUID, List<PlayerRunCommand>> delayedCommandsSaved) {
        this.delayedCommandsSaved = delayedCommandsSaved;
    }

    @Generated
    public void setStopPickup(Map<Player, Long> stopPickup) {
        this.stopPickup = stopPickup;
    }

    @Generated
    public Map<Player, Long> getStopPickup() {
        return this.stopPickup;
    }

    static {
        i = 0;
    }
}

