/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.events.BlockBreakEventExtension;
import com.ssomar.score.utils.ToolsListMaterial;
import com.ssomar.score.utils.safebreak.SafeBreak;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FarmInCube
extends BlockCommand {
    private static final boolean DEBUG = false;

    private static void processBlock(Block toDestroy, boolean onlyMaxAge, boolean drop, boolean replant, @Nullable UUID playerUuid, @Nullable Player player, boolean event, int slot, List<Material> validMaterials) {
        Ageable ageable;
        BlockData data = toDestroy.getBlockData();
        Material bMat = toDestroy.getType();
        if (onlyMaxAge && data instanceof Ageable && (ageable = (Ageable)data).getAge() != ageable.getMaximumAge()) {
            return;
        }
        if (validMaterials.contains(bMat)) {
            BlockData dataForReplant;
            BlockData blockData = dataForReplant = replant ? data.clone() : null;
            if (!SafeBreak.breakBlockWithEvent(toDestroy, playerUuid, slot, drop, event, true, BlockBreakEventExtension.BreakCause.MINE_IN_CUBE)) {
                return;
            }
            if (replant && dataForReplant != null) {
                FarmInCube.replant(toDestroy, dataForReplant, bMat, player);
            }
        }
    }

    public static void replant(Block block, BlockData oldData, Material material, @Nullable Player player) {
        if (!(oldData instanceof Ageable)) {
            block.setType(Material.AIR);
            return;
        }
        Ageable ageable = (Ageable)oldData;
        Material required = ToolsListMaterial.getInstance().getRealMaterialOfBlock(material);
        boolean needReplant = false;
        if (player != null) {
            if (player.getInventory().removeItem(new ItemStack[]{new ItemStack(required)}).isEmpty()) {
                needReplant = true;
            } else {
                block.setType(Material.AIR);
            }
        } else {
            needReplant = true;
        }
        if (needReplant) {
            ageable.setAge(0);
            block.setBlockData(oldData);
        }
    }

    @Override
    public void run(Player p, @NotNull Block block, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        ActionInfo aInfo = sCommandToExec.getActionInfo();
        Material oldMaterial = aInfo.getOldBlockMaterial();
        if (aInfo.isEventFromCustomBreakCommand()) {
            return;
        }
        List<Material> validMaterials = ToolsListMaterial.getInstance().getPlantWithGrowth();
        try {
            int radius = Integer.parseInt(args.get(0));
            boolean drop = true;
            if (args.size() >= 2) {
                drop = Boolean.parseBoolean(args.get(1));
            }
            boolean onlyMaxAge = true;
            if (args.size() >= 3) {
                onlyMaxAge = Boolean.parseBoolean(args.get(2));
            }
            boolean replant = false;
            if (args.size() >= 4) {
                replant = Boolean.parseBoolean(args.get(3));
            }
            boolean event = false;
            if (args.size() >= 5) {
                event = Boolean.parseBoolean(args.get(4));
            }
            if (radius >= 10) {
                radius = 9;
            }
            World world = block.getWorld();
            int baseX = block.getX();
            int baseY = block.getY();
            int baseZ = block.getZ();
            ArrayList<Block> blocksToProcess = new ArrayList<Block>();
            for (int y = -radius; y <= radius; ++y) {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        Block toDestroy;
                        if (x == 0 && y == 0 && z == 0 || !validMaterials.contains((toDestroy = world.getBlockAt(baseX + x, baseY + y, baseZ + z)).getType())) continue;
                        blocksToProcess.add(toDestroy);
                    }
                }
            }
            if (!blocksToProcess.isEmpty()) {
                boolean dropFinal = drop;
                boolean onlyMaxAgeFinal = onlyMaxAge;
                boolean replantFinal = replant;
                boolean eventFinal = event;
                int slot = aInfo.getSlot();
                UUID playerUuid = p != null ? p.getUniqueId() : null;
                Runnable batchTask = () -> {
                    for (Block toDestroy : blocksToProcess) {
                        FarmInCube.processBlock(toDestroy, onlyMaxAgeFinal, dropFinal, replantFinal, playerUuid, p, eventFinal, slot, validMaterials);
                    }
                };
                SCore.schedulerHook.runTask(batchTask, 1L);
            }
            SsomarDev.testMsg("OldMaterial : " + oldMaterial.toString(), false);
            if (validMaterials.contains(oldMaterial) && replant) {
                boolean onlyMaxAgeFinal = onlyMaxAge;
                boolean dropFinal = drop;
                boolean eventFinal = event;
                UUID uuidFinal = p != null ? p.getUniqueId() : null;
                Runnable runnable = () -> {
                    Ageable ageable;
                    BlockData data = block.getBlockData();
                    if (onlyMaxAgeFinal && data instanceof Ageable && (ageable = (Ageable)data).getAge() != ageable.getMaximumAge()) {
                        return;
                    }
                    if (!block.getType().equals((Object)Material.AIR) && !SafeBreak.breakBlockWithEvent(block, uuidFinal, aInfo.getSlot(), dropFinal, eventFinal, true, BlockBreakEventExtension.BreakCause.MINE_IN_CUBE)) {
                        return;
                    }
                    block.setType(oldMaterial);
                    BlockData newData = block.getBlockData();
                    if (aInfo.getBlockFace() != null && newData instanceof Directional) {
                        Directional directional = (Directional)newData;
                        directional.setFacing(aInfo.getBlockFace());
                        block.setBlockData((BlockData)directional);
                    }
                    FarmInCube.replant(block, block.getBlockData().clone(), oldMaterial, p);
                };
                SCore.schedulerHook.runLocationTask(runnable, block.getLocation(), 1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("FARMINCUBE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "FARMINCUBE {radius} [ActiveDrop true or false] [onlyMaxAge true or false] [replant true or false] [event true or false]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

