/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.events.BlockBreakEventExtension;
import com.ssomar.score.features.custom.detailedblocks.DetailedBlocks;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.safebreak.SafeBreak;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MineInCube
extends BlockCommand {
    public MineInCube() {
        CommandSetting radius = new CommandSetting("radius", 0, Integer.class, (Object)0);
        CommandSetting droploot = new CommandSetting("droploot", 1, Boolean.class, (Object)true);
        CommandSetting createEvent = new CommandSetting("createEvent", 2, Boolean.class, (Object)true);
        CommandSetting offsetBreak = new CommandSetting("offsetBreak", 3, Boolean.class, (Object)false);
        List<CommandSetting> settings = this.getSettings();
        settings.add(radius);
        settings.add(droploot);
        settings.add(createEvent);
        settings.add(offsetBreak);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(final Player p, final @NotNull Block block, final SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        final ActionInfo aInfo = sCommandToExec.getActionInfo();
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                if (aInfo.isEventFromCustomBreakCommand()) {
                    return;
                }
                try {
                    int radius = Integer.parseInt(sCommandToExec.getSettingValue("radius").toString());
                    boolean drop = Boolean.parseBoolean(sCommandToExec.getSettingValue("droploot").toString());
                    boolean createBBEvent = Boolean.parseBoolean(sCommandToExec.getSettingValue("createEvent").toString());
                    boolean offset = Boolean.parseBoolean(sCommandToExec.getSettingValue("offsetBreak").toString());
                    ArrayList<Material> blackList = new ArrayList<Material>();
                    blackList.add(Material.BEDROCK);
                    blackList.add(Material.AIR);
                    int offsetx = 0;
                    int offsety = 0;
                    int offsetz = 0;
                    if (offset) {
                        HashSet<Material> transparent = new HashSet<Material>();
                        transparent.add(Material.WATER);
                        transparent.add(Material.AIR);
                        if (SCore.is1v18Plus()) {
                            transparent.add(Material.CAVE_AIR);
                        }
                        List lastBlocks = p.getLastTwoTargetBlocks(transparent, 5);
                        BlockFace face = null;
                        try {
                            face = ((Block)lastBlocks.get(1)).getFace((Block)lastBlocks.get(0)).getOppositeFace();
                        }
                        catch (Exception ignored) {
                            return;
                        }
                        if (face == BlockFace.NORTH) {
                            offsetz = -1 * radius;
                        } else if (face == BlockFace.SOUTH) {
                            offsetz = radius;
                        } else if (face == BlockFace.WEST) {
                            offsetx = -1 * radius;
                        } else if (face == BlockFace.EAST) {
                            offsetx = radius;
                        } else if (face == BlockFace.UP) {
                            offsety = radius;
                        } else if (face == BlockFace.DOWN) {
                            offsety = -1 * radius;
                        }
                    }
                    boolean isv18plus = SCore.is1v18Plus();
                    if (radius < 10) {
                        for (int y = -radius; y < radius + 1; ++y) {
                            for (int x = -radius; x < radius + 1; ++x) {
                                for (int z = -radius; z < radius + 1; ++z) {
                                    if (isv18plus ? block.getY() + y + offsety < -64 : block.getY() + y + offsety < 0) continue;
                                    Block toBreak = block.getWorld().getBlockAt(block.getX() + x + offsetx, block.getY() + y + offsety, block.getZ() + z + offsetz);
                                    DetailedBlocks whiteList = aInfo.getDetailedBlocks();
                                    if (whiteList != null && !whiteList.isValid(toBreak, Optional.empty(), null, new StringPlaceholder()) || blackList.contains(toBreak.getType())) continue;
                                    UUID pUUID = null;
                                    if (p != null) {
                                        pUUID = p.getUniqueId();
                                    }
                                    SafeBreak.breakBlockWithEvent(toBreak, pUUID, aInfo.getSlot(), drop, createBBEvent, true, BlockBreakEventExtension.BreakCause.MINE_IN_CUBE);
                                }
                            }
                        }
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        SCore.schedulerHook.runTask(runnable3, 1L);
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("MINEINCUBE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "MINEINCUBE {radius} {ActiveDrop true or false} {create blockBreakEvent true or false} {offset default false}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

