/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.utils.ToolsListMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class PlantInSquare
extends BlockCommand {
    public PlantInSquare() {
        CommandSetting radius = new CommandSetting("radius", 0, Integer.class, (Object)1);
        CommandSetting takeFromInv = new CommandSetting("takeFromInv", 1, Boolean.class, (Object)false);
        CommandSetting acceptEI = new CommandSetting("acceptEI", 2, Boolean.class, (Object)false);
        CommandSetting cropType = new CommandSetting("cropType", 3, String.class, (Object)"WHEAT");
        CommandSetting isCube = new CommandSetting("isCube", 4, Boolean.class, (Object)false);
        List<CommandSetting> settings = this.getSettings();
        settings.add(radius);
        settings.add(takeFromInv);
        settings.add(acceptEI);
        settings.add(cropType);
        settings.add(isCube);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, @NotNull Block block, SCommandToExec sCommandToExec) {
        int slot;
        List<Material> validCropsToPlace;
        int radius = Integer.parseInt(sCommandToExec.getSettingValue("radius").toString());
        boolean takeFromInventory = Boolean.parseBoolean(sCommandToExec.getSettingValue("takeFromInv").toString());
        boolean acceptEI = Boolean.parseBoolean(sCommandToExec.getSettingValue("acceptEI").toString());
        List<String> specifiedCropTypes = Arrays.asList(sCommandToExec.getSettingValue("cropType").toString().toUpperCase().split(","));
        boolean isCube = Boolean.parseBoolean(sCommandToExec.getSettingValue("isCube").toString());
        Material determineMode = block.getType();
        if (determineMode == Material.FARMLAND) {
            validCropsToPlace = ToolsListMaterial.getInstance().getPlantWithGrowthOnlyFarmland();
        } else if (determineMode == Material.SOUL_SAND) {
            validCropsToPlace = ToolsListMaterial.getInstance().getPlantWithGrowthOnlySoulSand();
        } else if (ToolsListMaterial.getInstance().getValidJungleBlockMaterials().contains(determineMode)) {
            validCropsToPlace = ToolsListMaterial.getInstance().getPlantWithGrowthOnlyJungleWood();
        } else {
            SsomarDev.testMsg("[#s0001] CLICKED BLOCK IS UNSUPPORTED", true);
            return;
        }
        int resourcesNeeded = (radius * 2 + 1) * (radius * 2 + 1);
        if (radius == 0) {
            resourcesNeeded = 1;
        }
        ArrayList<Material> cropsToPlace = new ArrayList<Material>();
        for (Material cropMaterial : validCropsToPlace) {
            if (!specifiedCropTypes.isEmpty() && !specifiedCropTypes.contains(cropMaterial.toString())) continue;
            cropsToPlace.add(ToolsListMaterial.getInstance().getRealMaterialOfBlock(cropMaterial));
        }
        HashMap<Integer, ItemStack> resources = new HashMap<Integer, ItemStack>();
        if (takeFromInventory) {
            slot = 0;
            for (ItemStack item : p.getInventory().getContents()) {
                if (item != null && cropsToPlace.contains(item.getType()) && (acceptEI || !new ExecutableItemObject(item).isValid())) {
                    resources.put(slot, item);
                    resourcesNeeded -= item.getAmount();
                }
                if (resourcesNeeded > 0) {
                    ++slot;
                    continue;
                }
                break;
            }
        } else {
            slot = 0;
            while (resourcesNeeded > 0) {
                int randomIndex = new Random().nextInt(cropsToPlace.size());
                Material randomMaterial = (Material)cropsToPlace.get(randomIndex);
                ItemStack item = new ItemStack(randomMaterial);
                int randomAmount = new Random().nextInt(64);
                item.setAmount(randomAmount);
                resources.put(slot, item);
                resourcesNeeded -= randomAmount;
                ++slot;
            }
        }
        if (!resources.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ItemStack item : resources.values()) {
                sb.append(item.getAmount()).append(" ").append(item.getType().toString()).append(", ");
            }
            SsomarDev.testMsg(ChatColor.GREEN + "[#s0002] Resources: " + sb.toString(), true);
        }
        if (radius == 0) {
            ItemStack item = this.getValidItem(resources);
            if (item == null) {
                return;
            }
            this.plant(determineMode, block, item);
        }
        block4: for (int x = -radius; x < radius + 1; ++x) {
            for (int z = -radius; z < radius + 1; ++z) {
                if (isCube) {
                    ItemStack item;
                    for (int y = -radius; y < radius + 1 && (item = this.getValidItem(resources)) != null; ++y) {
                        Block farm = block.getWorld().getBlockAt(block.getX() + x, block.getY() + y, block.getZ() + z);
                        this.plant(determineMode, farm, item);
                    }
                    continue;
                }
                ItemStack item = this.getValidItem(resources);
                if (item == null) continue block4;
                Block farm = block.getWorld().getBlockAt(block.getX() + x, block.getY(), block.getZ() + z);
                this.plant(determineMode, farm, item);
            }
        }
        if (takeFromInventory) {
            PlayerInventory inv = p.getInventory();
            Iterator iterator = resources.keySet().iterator();
            while (iterator.hasNext()) {
                int s = (Integer)iterator.next();
                inv.setItem(s, (ItemStack)resources.get(s));
            }
        }
    }

    private void plant(Material mode, Block farm, ItemStack item) {
        if (farm.getType() != mode) {
            if (!farm.isEmpty()) {
                return;
            }
            if (ToolsListMaterial.getInstance().getValidJungleBlockMaterials().contains(mode) && farm.getType() == Material.AIR) {
                this.plantCocoa(farm, item);
            }
        } else {
            if (item.getType() == Material.COCOA_BEANS) {
                return;
            }
            Block toPlant = farm.getWorld().getBlockAt(farm.getX(), farm.getY() + 1, farm.getZ());
            if (!toPlant.isEmpty()) {
                return;
            }
            toPlant.setType(ToolsListMaterial.getInstance().getBlockMaterialOfItem(item.getType()));
            item.setAmount(item.getAmount() - 1);
        }
    }

    private ItemStack getValidItem(Map<Integer, ItemStack> disposal) {
        for (ItemStack item : disposal.values()) {
            if (item.getAmount() <= 0) continue;
            return item;
        }
        return null;
    }

    private void plantCocoa(Block farm, ItemStack item) {
        Object[][] offsetChecks;
        for (Object[] offsetVal : offsetChecks = new Object[][]{{1, 0, BlockFace.EAST}, {-1, 0, BlockFace.WEST}, {0, 1, BlockFace.SOUTH}, {0, -1, BlockFace.NORTH}}) {
            Material neigborBlock = farm.getWorld().getBlockAt(farm.getX() + (Integer)offsetVal[0], farm.getY(), farm.getZ() + (Integer)offsetVal[1]).getType();
            if (!ToolsListMaterial.getInstance().getValidJungleBlockMaterials().contains(neigborBlock)) continue;
            farm.setType(Material.COCOA);
            BlockData toPlantData = farm.getBlockData();
            Directional toPlantDirectional = (Directional)toPlantData;
            toPlantDirectional.setFacing((BlockFace)offsetVal[2]);
            farm.setBlockData(toPlantData);
            item.setAmount(item.getAmount() - 1);
            break;
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("PLANT_IN_SQUARE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "PLANT_IN_SQUARE radius:{int} takeFromInv:{true/false} acceptEI:{true/false} cropType:WHEAT isCube:{true/false}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

