/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Spin
extends MixedCommand {
    @Override
    public void run(Player p, final Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        final Integer duration = NTools.getInteger(args.get(0)).get();
        final Float velocity = NTools.getFloat(args.get(1)).get();
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            int ticks = 0;

            @Override
            public void run() {
                if (this.ticks >= duration) {
                    ((ScheduledTask)task.get()).cancel();
                    return;
                }
                receiver.teleport(receiver.getLocation().setDirection(receiver.getLocation().getDirection().rotateAroundY(Math.toRadians(velocity.floatValue()))));
                ++this.ticks;
            }
        };
        task.set(SCore.schedulerHook.runRepeatingTask(runnable, 0L, 1L));
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        if (args.size() < 2) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        ArgumentChecker ac = Spin.checkInteger(args.get(0), isFinalVerification, this.getTemplate());
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        ArgumentChecker ac1 = Spin.checkDouble(args.get(1), isFinalVerification, this.getTemplate());
        if (!ac1.isValid()) {
            return Optional.of(ac1.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SPIN");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SPIN {duration} {velocity}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

