/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandsHandler;
import com.ssomar.score.commands.runnable.RunCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommandManager;
import com.ssomar.score.commands.runnable.player.PlayerSCommand;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class PlayerRunCommand
extends RunCommand {
    private static final long serialVersionUID = 1L;
    private UUID launcherUUID;
    private UUID receiverUUID;
    private boolean silenceOutput;
    private boolean runOffline;
    private boolean clearIfDisconnect;

    public PlayerRunCommand(String brutCommand, int delay, ActionInfo aInfo) {
        super(brutCommand, delay, aInfo);
        this.initRunOffline(brutCommand);
        this.initClearIfDisconnect(brutCommand);
    }

    public PlayerRunCommand(String brutCommand, long runTime, ActionInfo aInfo) {
        super(brutCommand, runTime, aInfo);
        this.initRunOffline(brutCommand);
        this.initClearIfDisconnect(brutCommand);
    }

    public void initRunOffline(String brutCommand) {
        if (brutCommand.contains("[<OFFLINE>]")) {
            this.runOffline = true;
            this.setBrutCommand(brutCommand.replaceAll("\\[<OFFLINE>]", "").trim());
        } else {
            this.runOffline = false;
        }
    }

    public void initClearIfDisconnect(String brutCommand) {
        if (brutCommand.contains("[<CLEAR_IF_DISCONNECT>]")) {
            this.clearIfDisconnect = true;
            this.setBrutCommand(brutCommand.replaceAll("\\[<CLEAR_IF_DISCONNECT>]", "").trim());
        } else {
            this.clearIfDisconnect = false;
        }
    }

    @Override
    public void pickupInfo() {
        ActionInfo aInfo = this.getaInfo();
        this.launcherUUID = aInfo.getLauncherUUID();
        this.receiverUUID = aInfo.getReceiverUUID();
        this.silenceOutput = aInfo.isSilenceOutput();
    }

    @Override
    public void runGetManager() {
        this.runCommand(PlayerCommandManager.getInstance());
    }

    @Override
    public void runCommand(SCommandToExec sCommandToExec) {
        PlayerSCommand pCommand = (PlayerSCommand)((Object)sCommandToExec.getSCommand());
        @Nullable Player launcher = null;
        if (this.launcherUUID != null) {
            launcher = Bukkit.getPlayer((UUID)this.launcherUUID);
        }
        Player receiver = Bukkit.getPlayer((UUID)this.receiverUUID);
        sCommandToExec.setActionInfo(this.getaInfo());
        pCommand.run(launcher, receiver, sCommandToExec);
    }

    @Override
    public void insideDelayedCommand() {
        Player receiver = Bukkit.getPlayer((UUID)this.receiverUUID);
        if (receiver != null && receiver.isOnline() || this.runOffline) {
            this.runCommand(PlayerCommandManager.getInstance());
        }
        CommandsHandler.getInstance().removeDelayedCommand(this.getUuid(), this.receiverUUID);
    }

    @Override
    public void executeRunnable(Runnable runnable) {
        SsomarDev.testMsg("[#s_1] [-1] PlayerRunCommand.java > executeRunnable() : " + this.receiverUUID, false, SsomarDev.DebugMsgGroups._1);
        Player receiver = Bukkit.getPlayer((UUID)this.receiverUUID);
        if (receiver == null) {
            SCore.schedulerHook.runTask(runnable, 0L);
        } else {
            SCore.schedulerHook.runEntityTaskAsap(runnable, null, (Entity)receiver);
        }
    }

    @Generated
    public UUID getLauncherUUID() {
        return this.launcherUUID;
    }

    @Generated
    public void setLauncherUUID(UUID launcherUUID) {
        this.launcherUUID = launcherUUID;
    }

    @Generated
    public UUID getReceiverUUID() {
        return this.receiverUUID;
    }

    @Generated
    public void setReceiverUUID(UUID receiverUUID) {
        this.receiverUUID = receiverUUID;
    }

    @Generated
    public boolean isSilenceOutput() {
        return this.silenceOutput;
    }

    @Generated
    public void setSilenceOutput(boolean silenceOutput) {
        this.silenceOutput = silenceOutput;
    }

    @Generated
    public boolean isRunOffline() {
        return this.runOffline;
    }

    @Generated
    public boolean isClearIfDisconnect() {
        return this.clearIfDisconnect;
    }
}

