/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.RunConsoleCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.usedapi.WorldGuardAPI;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class ReplaceBlock
extends PlayerCommand {
    public ReplaceBlock() {
        CommandSetting material = new CommandSetting("material", 0, String.class, (Object)"STONE");
        List<CommandSetting> settings = this.getSettings();
        settings.add(material);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        String materialName = (String)sCommandToExec.getSettingValue("material");
        Material material = null;
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Block block = receiver.getTargetBlock(null, 5);
        if (SCore.hasWorldGuard && !new WorldGuardAPI().canBuild(receiver, new Location(block.getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ()))) {
            return;
        }
        if (block.getType() != Material.AIR) {
            if (material != null) {
                block.setType(material);
            } else {
                RunConsoleCommand.runConsoleCommand("execute at " + receiver.getName() + " run setblock " + block.getX() + " " + block.getY() + " " + block.getZ() + " " + materialName.toLowerCase(), sCommandToExec.getActionInfo().isSilenceOutput());
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("REPLACE_BLOCK");
        names.add("REPLACEBLOCK");
        return names;
    }

    @Override
    public String getTemplate() {
        return "REPLACE_BLOCK material:STONE";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

