/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.backward_compatibility.AttributeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SetItemAttribute
extends PlayerCommand {
    public SetItemAttribute() {
        CommandSetting slot = new CommandSetting("slot", 0, Integer.class, (Object)-1);
        slot.setSlot(true);
        CommandSetting attribute = new CommandSetting("attribute", 1, AttributeUtils.class, (Object)AttributeUtils.getAttribute("GENERIC_MAX_HEALTH"));
        CommandSetting value = new CommandSetting("value", 2, Double.class, (Object)2.0);
        CommandSetting equipmentSlot = new CommandSetting("equipmentSlot", 3, EquipmentSlot.class, null);
        List<CommandSetting> settings = this.getSettings();
        settings.add(slot);
        settings.add(attribute);
        settings.add(value);
        settings.add(equipmentSlot);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        Attribute attribute = (Attribute)sCommandToExec.getSettingValue("attribute");
        EquipmentSlot equipmentSlot = (EquipmentSlot)sCommandToExec.getSettingValue("equipmentSlot");
        double attributeValue = (Double)sCommandToExec.getSettingValue("value");
        int slot = (Integer)sCommandToExec.getSettingValue("slot");
        ItemStack item = slot == -1 ? receiver.getInventory().getItemInMainHand() : receiver.getInventory().getItem(slot);
        if (item == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        ItemMeta itemmeta = item.getItemMeta();
        AttributeModifier existingModifier = null;
        try {
            Collection existingModifiers = itemmeta.getAttributeModifiers(attribute);
            if (existingModifiers != null && !existingModifiers.isEmpty()) {
                for (AttributeModifier attributeModifier : existingModifiers) {
                    if (!attributeModifier.getSlot().equals((Object)equipmentSlot)) continue;
                    existingModifier = attributeModifier;
                }
            }
        }
        catch (NullPointerException existingModifiers) {
            // empty catch block
        }
        if (existingModifier == null) {
            AttributeModifier newModifier = new AttributeModifier(UUID.randomUUID(), "ScoreAttribute", attributeValue, AttributeModifier.Operation.ADD_NUMBER, equipmentSlot);
            itemmeta.addAttributeModifier(attribute, newModifier);
        } else {
            AttributeModifier copyExistingModifier = existingModifier;
            try {
                existingModifier = new AttributeModifier(existingModifier.getUniqueId(), "ScoreAttribute", attributeValue, existingModifier.getOperation(), existingModifier.getSlot());
            }
            catch (IllegalArgumentException err) {
                existingModifier = new AttributeModifier(UUID.randomUUID(), "ScoreAttribute", attributeValue, existingModifier.getOperation(), existingModifier.getSlot());
            }
            itemmeta.removeAttributeModifier(attribute, existingModifier);
            if (copyExistingModifier.getAmount() + attributeValue != 0.0) {
                itemmeta.addAttributeModifier(attribute, existingModifier);
            }
        }
        item.setItemMeta(itemmeta);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SET_ITEM_ATTRIBUTE");
        names.add("SET_ATTRIBUTE");
        names.add("SETITEMATTRIBUTE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SET_ITEM_ATTRIBUTE slot:-1 attribute:GENERIC_MAX_HEALTH value:2.0 equipmentSlot:HAND";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

