/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands.absorption;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.commands.runnable.player.commands.absorption.AbsorptionManager;
import com.ssomar.score.commands.runnable.player.commands.absorption.AbsorptionObject;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Absorption
extends PlayerCommand {
    public Absorption() {
        CommandSetting amount = new CommandSetting("amount", 0, Double.class, (Object)5.0);
        CommandSetting time = new CommandSetting("time", 1, Integer.class, (Object)200);
        List<CommandSetting> settings = this.getSettings();
        settings.add(amount);
        settings.add(time);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        double absorption = (Double)sCommandToExec.getSettingValue("amount");
        int time = (Integer)sCommandToExec.getSettingValue("time");
        double currentAbsorption = receiver.getAbsorptionAmount();
        try {
            if (time <= 0) {
                receiver.setAbsorptionAmount(currentAbsorption + absorption);
            } else {
                long timestamp = System.currentTimeMillis();
                long finalTime = (long)(time *= 50) + timestamp;
                AbsorptionObject absorptionObject = new AbsorptionObject(receiver.getUniqueId(), absorption, finalTime);
                AbsorptionManager.getInstance().applyAbsorption(absorptionObject);
            }
        }
        catch (IllegalArgumentException e) {
            SsomarDev.testMsg("ABSORPTION Error: " + e.getMessage(), true);
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("ABSORPTION");
        return names;
    }

    @Override
    public String getTemplate() {
        return "ABSORPTION amount:5.0 time:200";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

