/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands.absorption;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.player.commands.absorption.AbsorptionObject;
import com.ssomar.score.data.AbsorptionQuery;
import com.ssomar.score.data.Database;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class AbsorptionManager {
    public static AbsorptionManager instance;

    public AbsorptionManager() {
        instance = this;
    }

    public AbsorptionObject applyAbsorption(AbsorptionObject absorption) {
        return this.applyAbsorption(absorption, false);
    }

    private AbsorptionObject applyAbsorption(final AbsorptionObject absorption, boolean isReschedule) {
        UUID absorptionUUID;
        Player receiver;
        SsomarDev.testMsg(ChatColor.GOLD + "[#s0014] AbsorptionManager.applyAbsorption() is triggered (isReschedule: " + isReschedule + ")", true);
        if (absorption.getTask() != null) {
            absorption.getTask().cancel();
        }
        if ((receiver = SCore.plugin.getServer().getPlayer(absorption.getPlayerUUID())) == null) {
            return absorption;
        }
        double currentabsorption = receiver.getAbsorptionAmount();
        long remainingTimeTiksTime = absorption.getExpiryTime() - System.currentTimeMillis();
        remainingTimeTiksTime /= 50L;
        SsomarDev.testMsg("currentAbso: " + currentabsorption + " abso to add " + absorption.getAbsorption(), true);
        receiver.setAbsorptionAmount(currentabsorption + absorption.getAbsorption());
        SsomarDev.testMsg("newAbso: " + receiver.getAbsorptionAmount(), true);
        if (absorption.getAbsorptionUUID() != null) {
            absorptionUUID = absorption.getAbsorptionUUID();
        } else {
            absorptionUUID = UUID.randomUUID();
            absorption.setAbsorptionUUID(absorptionUUID);
        }
        if (!isReschedule) {
            SCore.schedulerHook.runAsyncTask(() -> AbsorptionQuery.insertToRecords(Database.getInstance().connect(), absorptionUUID, receiver.getUniqueId(), absorption.getAbsorption(), absorption.getExpiryTime()), 0L);
        }
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                SsomarDev.testMsg("REMOVE receiver: " + receiver.getUniqueId() + " ABSORPTION: " + absorption.getAbsorption(), true);
                if (!receiver.isDead() || receiver.isOnline()) {
                    try {
                        AbsorptionManager.modifyAbsorption(receiver.getUniqueId().toString(), receiver.getAbsorptionAmount() - absorption.getAbsorption());
                        SCore.schedulerHook.runAsyncTask(() -> AbsorptionQuery.deleteAbsorption(Database.getInstance().connect(), absorptionUUID.toString()), 0L);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        };
        absorption.setTask(SCore.schedulerHook.runTask(runnable3, remainingTimeTiksTime));
        return absorption;
    }

    public void onConnect(final Player player) {
        SsomarDev.testMsg(ChatColor.GOLD + "[#s0015] AbsorptionManager.onConnect() is triggered", true);
        final UUID playerUUID = player.getUniqueId();
        Runnable runnableAsync = new Runnable(){

            @Override
            public void run() {
                final ArrayList<AbsorptionObject> toRemove = AbsorptionQuery.getAbsorptionsToRemove(Database.getInstance().connect(), player.getUniqueId().toString());
                SsomarDev.testMsg("[#s0016] Amount of expired absorptions: " + toRemove.size(), true);
                Runnable runnableSync = new Runnable(){

                    @Override
                    public void run() {
                        Player getBackPlayer = Bukkit.getPlayer((UUID)playerUUID);
                        if (getBackPlayer == null || !getBackPlayer.isOnline()) {
                            return;
                        }
                        for (AbsorptionObject absorption : toRemove) {
                            if (getBackPlayer.getAbsorptionAmount() > absorption.getAbsorption()) {
                                getBackPlayer.setAbsorptionAmount(getBackPlayer.getAbsorptionAmount() - absorption.getAbsorption());
                                continue;
                            }
                            if (getBackPlayer.getAbsorptionAmount() == 0.0) break;
                            getBackPlayer.setAbsorptionAmount(0.0);
                        }
                        SCore.schedulerHook.runAsyncTask(() -> {
                            for (AbsorptionObject absorption : toRemove) {
                                AbsorptionQuery.deleteAbsorption(Database.getInstance().connect(), absorption.getAbsorptionUUID().toString());
                            }
                        }, 0L);
                    }
                };
                SCore.schedulerHook.runTask(runnableSync, 0L);
            }
        };
        SCore.schedulerHook.runAsyncTask(runnableAsync, 0L);
    }

    public static AbsorptionManager getInstance() {
        if (instance == null) {
            instance = new AbsorptionManager();
        }
        return instance;
    }

    private static void modifyAbsorption(String player_uuid, double new_value) {
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(player_uuid));
        assert (player != null);
        player.setAbsorptionAmount(new_value);
    }
}

